/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractMessageMgr;
import com.trs.scm.sdk.model.MicroMessage;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.T163ErrorMessage;
import java.util.HashMap;
import org.apache.log4j.Logger;
import t4j.TBlog;
import t4j.org.json.JSONObject;

public class T163MessageMgr
extends AbstractMessageMgr {
    private static Logger logger = Logger.getLogger(T163MessageMgr.class);
    private TBlog tBlog = new TBlog();
    private static HashMap<String, Long> m_lLastSetReadTimeMellions = null;

    public T163MessageMgr(OAuth auth) {
        super(auth);
        this.tBlog.setToken(auth.getOAuth_token(), auth.getOAuth_token_secret());
        if (m_lLastSetReadTimeMellions == null) {
            m_lLastSetReadTimeMellions = new HashMap();
        }
    }

    @Override
    public MicroMessage getMessage() throws Exception {
        String sKey = this.m_oOAuth.getOAuth_token();
        Long lLastSetReadTime = m_lLastSetReadTimeMellions.get(sKey);
        MicroMessage oCurrMessage = new MicroMessage();
        JSONObject json = null;
        try {
            json = lLastSetReadTime != null ? this.tBlog.getLatestMessages(lLastSetReadTime.longValue()) : this.tBlog.getLatestMessages();
            oCurrMessage.setUnreadCount(1, json.getInt("timelineCount"));
            oCurrMessage.setUnreadCount(2, json.getInt("commentOfMeCount"));
            oCurrMessage.setUnreadCount(3, json.getInt("replyCount"));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return oCurrMessage;
    }

    @Override
    public boolean setMessageRead(int messageType) throws Exception {
        String sKey = this.m_oOAuth.getOAuth_token();
        m_lLastSetReadTimeMellions.put(sKey, CMyDateTime.now().getTimeInMillis());
        return true;
    }
}

