/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractUserMgr;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.SinaErrorMessage;
import com.trs.scm.sdk.util.SinaObjectUtil;
import org.apache.log4j.Logger;
import weibo4j.Account;
import weibo4j.Users;
import weibo4j.Weibo;
import weibo4j.model.User;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class SinaUserMgr
extends AbstractUserMgr {
    private static Logger logger = Logger.getLogger(SinaUserMgr.class);
    private Weibo m_oSinaWeibo;
    private Users oUsers = null;

    public SinaUserMgr(OAuth auth) {
        super(auth);
        String sAccessToken = this.m_oOAuth.getOAuth_token();
        this.m_oSinaWeibo = new Weibo();
        this.m_oSinaWeibo.setToken(sAccessToken);
        this.oUsers = new Users();
        this.oUsers.setToken(sAccessToken);
    }

    @Override
    public MicroUser showUser() throws Exception {
        Account oSinaAccount = new Account();
        oSinaAccount.setToken(this.m_oOAuth.getOAuth_token());
        String sUID = null;
        try {
            JSONObject oJsonObject = oSinaAccount.getUid();
            sUID = oJsonObject.getString("uid");
        }
        catch (JSONException _oJSONException) {
            logger.error((Object)_oJSONException.getStackTrace());
            throw new Exception("JSON\u83b7\u53d6UID\u53c2\u6570\u9519\u8bef", _oJSONException);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return this.findUserById(sUID);
    }

    @Override
    public MicroUser findUserById(String userId) throws Exception {
        User oUser;
        if (userId == null || userId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7528\u6237ID\u4e3a\u7a7a\uff01");
        }
        Users um = this.oUsers;
        try {
            oUser = um.showUserById(userId);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return SinaObjectUtil.constructMicroUser(oUser);
    }

    @Override
    public MicroUser findUserByNickName(String nickName) throws Exception {
        User oUser;
        if (nickName == null || nickName.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7528\u6237\u6635\u79f0\u4e3a\u7a7a\uff01");
        }
        Users um = this.oUsers;
        try {
            oUser = um.showUserByScreenName(nickName);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return SinaObjectUtil.constructMicroUser(oUser);
    }
}

