/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.crawler.impl;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.persistent.WCMFilter;
import com.trs.scm.domain.OAuthObjUtil;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.sdk.crawler.impl.SCMWeiboCrawler;
import com.trs.scm.sdk.crawler.impl.WeiboVisitorImpl;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.OAuth;
import com.trs.util.CMyString;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class SCMWeiboCrawlerHelper {
    private Map m_oCrawlerMapping = new HashMap();

    public SCMWeiboCrawlerHelper() {
        this.m_oCrawlerMapping.put("Sina", "com.trs.scm.sdk.crawler.impl.SinaWeiboCrawler");
        this.m_oCrawlerMapping.put("Tencent", "com.trs.scm.sdk.crawler.impl.TencentWeiboCrawler");
    }

    public void execute(Map _hMap) throws Exception {
        Accounts accounts = Accounts.createNewInstance(User.getSystem());
        String sAccountIds = null;
        if (_hMap.get("AccountIds") != null) {
            sAccountIds = _hMap.get("AccountIds").toString();
        }
        if (!CMyString.isEmpty(sAccountIds)) {
            String[] pAccountIds = sAccountIds.split(",");
            for (int i = 0; i < pAccountIds.length; ++i) {
                int nAccountId = Integer.parseInt(pAccountIds[i]);
                Account tempAccount = Account.findById(nAccountId);
                if (tempAccount == null || tempAccount.getStatus() != 1) continue;
                accounts.addElement(tempAccount);
            }
        } else {
            accounts.open(new WCMFilter());
        }
        int nSize = accounts.size();
        for (int i = 0; i < nSize; ++i) {
            SCMWeiboCrawler oCrawler;
            Account oAccount = (Account)accounts.getAt(i);
            if (oAccount == null || oAccount.getStatus() != 1) continue;
            OAuth oOAuth = OAuthObjUtil.constructOAuth(oAccount);
            String sPlatfrom = oAccount.getPlatform();
            String sCrawlerClz = (String)this.m_oCrawlerMapping.get(sPlatfrom);
            if (sCrawlerClz == null) continue;
            try {
                Class<?> oCrawlerClz = Class.forName(sCrawlerClz);
                Constructor<?> construtor = oCrawlerClz.getConstructor(OAuth.class);
                oCrawler = (SCMWeiboCrawler)construtor.newInstance(oOAuth);
                ExtraParams params = new ExtraParams();
                params.setParam("UserId", oAccount.getUId());
                for (String key : _hMap.keySet()) {
                    if (_hMap.get(key) == null) continue;
                    String value = _hMap.get(key).toString();
                    params.setParam(key, value);
                }
                oCrawler.setExtraParams(params);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6839\u636e\u5e73\u53f0\u52a0\u8f7d\u6293\u53d6\u7c7b\u51fa\u73b0\u5f02\u5e38", e);
            }
            WeiboVisitorImpl visitor = new WeiboVisitorImpl(oAccount);
            oCrawler.accept(visitor);
        }
    }
}

