/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.scm.domain.ISCMAccountMgr;
import com.trs.scm.domain.ISCMMessageMgr;
import com.trs.scm.domain.OAuthObjUtil;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.sdk.IMicroMessageMgr;
import com.trs.scm.sdk.factory.PlatformFactory;
import com.trs.scm.sdk.model.MicroMessage;
import com.trs.scm.sdk.model.OAuth;
import java.util.HashMap;
import java.util.Map;

public class SCMMessageMgr
implements ISCMMessageMgr {
    @Override
    public Map<Account, MicroMessage> queryUnReadMessages() throws Exception {
        User oUser = ContextHelper.getLoginUser();
        ISCMAccountMgr oAccountMgr = (ISCMAccountMgr)DreamFactory.createObjectById("ISCMAccountMgr");
        Accounts oAccounts = oAccountMgr.findAccountsForUser(oUser);
        if (oAccounts == null || oAccounts.size() == 0) {
            return new HashMap<Account, MicroMessage>();
        }
        return this.getUnReadMessages(oAccounts);
    }

    @Override
    public boolean setMessageRead(Account _oAccount, int _nMessageType) throws Exception {
        IMicroMessageMgr oMessageMgr = this.getMessageMgrByAccount(_oAccount);
        boolean bSuccessful = oMessageMgr.setMessageRead(_nMessageType);
        return bSuccessful;
    }

    private Map<Account, MicroMessage> getUnReadMessages(Accounts _oAccounts) throws Exception {
        HashMap<Account, MicroMessage> messageMap = new HashMap<Account, MicroMessage>();
        int nSize = _oAccounts.size();
        for (int i = 0; i < nSize; ++i) {
            Account tempAccount = (Account)_oAccounts.getAt(i);
            if (tempAccount == null) continue;
            IMicroMessageMgr oMicroMessageMgr = this.getMessageMgrByAccount(tempAccount);
            MicroMessage oMessage = null;
            try {
                oMessage = oMicroMessageMgr.getMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oMessage == null) continue;
            messageMap.put(tempAccount, oMessage);
        }
        return messageMap;
    }

    private IMicroMessageMgr getMessageMgrByAccount(Account _oAccount) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        OAuth oOAuth = OAuthObjUtil.constructOAuth(_oAccount);
        String sPlatform = _oAccount.getPlatform();
        IMicroMessageMgr oMessageMgr = PlatformFactory.createMicroMessageMgr(sPlatform, oOAuth);
        return oMessageMgr;
    }
}

