/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.parser;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.scene.parser.SceneConnector;
import com.trs.scene.parser.SceneNode;
import java.util.ArrayList;

public class ScenePathsParser {
    private SceneNode m_oFirstNode = null;
    private ArrayList m_arNodeStack = new ArrayList();

    public ScenePathsParser(SceneNode _oFirstNode) {
        this.m_oFirstNode = _oFirstNode;
    }

    public SceneConnector[][] parse() throws WCMException {
        SceneNode currNode = this.m_oFirstNode;
        SceneConnector[][] pResult = new SceneConnector[1][];
        SceneConnector[] path = new SceneConnector[]{};
        pResult[0] = this.parser(currNode, path, 0);
        if (!this.m_arNodeStack.isEmpty()) {
            StackNode stackNode = (StackNode)this.m_arNodeStack.get(this.m_arNodeStack.size() - 1);
            int i = 1;
            while (stackNode != null) {
                SceneConnector[] pathTemp = this.parser(stackNode.m_oNode, stackNode.m_path, stackNode.m_nConnectorIndex + 1);
                SceneConnector[][] pResultTemp = new SceneConnector[pResult.length + 1][];
                System.arraycopy(pResult, 0, pResultTemp, 0, pResult.length);
                pResultTemp[pResult.length] = pathTemp;
                pResult = pResultTemp;
                if (this.m_arNodeStack.isEmpty()) break;
                stackNode = (StackNode)this.m_arNodeStack.get(this.m_arNodeStack.size() - 1);
                ++i;
            }
        }
        return pResult;
    }

    private SceneConnector[] parser(SceneNode _currNode, SceneConnector[] _path, int _nConnectorIndex) throws WCMException {
        if (_currNode == null) {
            return _path;
        }
        ArrayList arConnectors = _currNode.getNextConnectors();
        if (arConnectors == null) {
            return _path;
        }
        int nConnectorSize = arConnectors.size();
        if (nConnectorSize == 0 || _nConnectorIndex >= nConnectorSize) {
            return _path;
        }
        SceneConnector connector = (SceneConnector)arConnectors.get(_nConnectorIndex);
        for (int i = 0; i < _path.length; ++i) {
            if (_path[i].getId() != connector.getId()) continue;
            throw new WCMException(I18NMessage.get(ScenePathsParser.class, "ScenePathsParser.label1", "\u5f53\u524d\u7684\u573a\u666f\u5b58\u5728\u56de\u8def\uff01\u8fde\u7ebf\u4fe1\u606f\u4e3a:Name=[") + connector.getName() + "] ID=[" + connector.getId() + "] StartNode=[" + connector.getPreNode().getName() + "] EndNode=[" + connector.getNextNode().getName() + "]");
        }
        SceneConnector[] newPath = new SceneConnector[_path.length + 1];
        newPath[_path.length] = connector;
        if (_path.length > 0) {
            System.arraycopy(_path, 0, newPath, 0, _path.length);
        }
        StackNode stackNode = null;
        if (!this.m_arNodeStack.isEmpty()) {
            stackNode = (StackNode)this.m_arNodeStack.get(this.m_arNodeStack.size() - 1);
        }
        if (stackNode != null && stackNode.m_oNode == _currNode) {
            if (_nConnectorIndex + 1 == nConnectorSize) {
                this.m_arNodeStack.remove(this.m_arNodeStack.size() - 1);
            } else {
                ++stackNode.m_nConnectorIndex;
            }
        } else if (nConnectorSize > 1) {
            stackNode = new StackNode(_currNode, _nConnectorIndex, _path);
            this.m_arNodeStack.add(stackNode);
        }
        return this.parser(connector.getNextNode(), newPath, 0);
    }

    private class StackNode {
        public SceneNode m_oNode = null;
        public int m_nConnectorIndex = 0;
        public SceneConnector[] m_path = null;

        public StackNode(SceneNode _node, int _nConnectorIndex, SceneConnector[] _path) {
            this.m_oNode = _node;
            this.m_nConnectorIndex = _nConnectorIndex;
            this.m_path = _path;
        }
    }
}

