/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;

public class PageViewUtil {
    public static String ORDERBY_TYPE_DESC = "desc";
    public static String ORDERBY_TYPE_ASC = "asc";

    public static String ObjectToHtml(Object _obj) {
        if (_obj == null) {
            return "";
        }
        if (_obj instanceof String) {
            return PageViewUtil.toHtml((String)_obj);
        }
        if (_obj instanceof CMyDateTime) {
            return PageViewUtil.toHtml((CMyDateTime)_obj);
        }
        if (_obj instanceof CDBText) {
            return PageViewUtil.toHtml(_obj.toString());
        }
        return _obj.toString();
    }

    public static String ObjectToHtmlValue(Object _obj) {
        if (_obj == null) {
            return "";
        }
        if (_obj instanceof String) {
            return PageViewUtil.toHtmlValue((String)_obj);
        }
        if (_obj instanceof CMyDateTime) {
            return PageViewUtil.toHtml((CMyDateTime)_obj);
        }
        if (_obj instanceof CDBText) {
            return PageViewUtil.toHtmlValue(_obj.toString());
        }
        return _obj.toString();
    }

    public static String toHtmlValue(String _sValue) {
        return PageViewUtil.toHtml(_sValue, false, false);
    }

    public static String toHtml(String _sValue) {
        return PageViewUtil.toHtml(_sValue, true, false);
    }

    public static String toHtml(String _sValue, boolean _bDisplay, boolean _bMultiLanguage) {
        if (!_bDisplay) {
            return CMyString.filterForHTMLValue(CMyString.showNull(_sValue));
        }
        if (!_bMultiLanguage) {
            return CMyString.transDisplay(CMyString.showNull(_sValue));
        }
        StringBuffer sb = new StringBuffer("<SPAN style='font-family:arial'>");
        sb.append(CMyString.transDisplay(CMyString.showNull(_sValue)));
        sb.append("</SPAN>");
        return sb.toString();
    }

    public static String toHtml(CMyDateTime _date) {
        if (_date == null) {
            return "";
        }
        return PageViewUtil.toHtml(_date, "yyyy-MM-dd");
    }

    public static String toHtml(CMyDateTime _date, String _dateFormat) {
        if (_date == null) {
            return "";
        }
        if (_dateFormat == null || _dateFormat.trim().length() == 0) {
            return _date.toString("yy-MM-dd");
        }
        return _date.toString(_dateFormat);
    }

    public static String showOrdImg(String _sCurrOrderType) {
        if (_sCurrOrderType.equalsIgnoreCase(ORDERBY_TYPE_ASC)) {
            return "\u25b2";
        }
        if (_sCurrOrderType.equalsIgnoreCase(ORDERBY_TYPE_DESC)) {
            return "\u25bc";
        }
        return "";
    }

    public static String getHeadTitle(String _sField, String _sFieldDesc, String _sCurrOrderField, String _sCurrOrderType) {
        boolean bIsOrderField = _sField.equalsIgnoreCase(_sCurrOrderField);
        String sOrderType = ORDERBY_TYPE_DESC;
        if (bIsOrderField && _sCurrOrderType.equalsIgnoreCase(ORDERBY_TYPE_DESC)) {
            sOrderType = ORDERBY_TYPE_ASC;
        }
        String sz = "";
        sz = sz + "<span onclick=\"CTRSAction_doOrderBy('" + _sField + "', '" + sOrderType + "');\" style=\"cursor:hand\">\n    <u><font color=\"#000000\">" + _sFieldDesc + "</font></u>" + (bIsOrderField ? PageViewUtil.showOrdImg(_sCurrOrderType) : "") + "\n   </span>\n";
        return sz;
    }
}

