/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.PageParameter;
import com.trs.presentation.util.Parameter;
import com.trs.presentation.util.Parameters;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class PageParameters
extends Parameters {
    private static Hashtable m_hPageParametersCache = new Hashtable();

    public PageParameters() {
    }

    public PageParameters(int _nParameterSize) {
        super(_nParameterSize);
    }

    @Override
    public Parameter createParameterInstance() {
        return new PageParameter();
    }

    public static PageParameters getParametersOfPage(String _sPageName, String _sAbsolutePagePath) throws WCMException {
        if (_sPageName == null) {
            throw new WCMException(10, I18NMessage.get(PageParameters.class, "PageParameters.label1", "\u6307\u5b9a\u7684\u9875\u9762\u540d\u79f0\u65e0\u6548\uff01"));
        }
        PageParameters oPageParameters = (PageParameters)m_hPageParametersCache.get((_sAbsolutePagePath + _sPageName).toUpperCase());
        if (oPageParameters != null) {
            return oPageParameters;
        }
        return PageParameters.loadParametersOfPage(_sPageName, _sAbsolutePagePath);
    }

    private static synchronized PageParameters loadParametersOfPage(String _sPageName, String _sAbsolutePagePath) throws WCMException {
        System.out.println("Load parameters of the page [" + _sPageName + "]...");
        if (_sPageName == null || _sAbsolutePagePath == null || _sPageName.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(PageParameters.class, "PageParameters.label2", "\u6ca1\u6709\u6307\u5b9a\u9875\u9762\u76f8\u5173\u53c2\u6570\uff01"));
        }
        String sKey = ((_sAbsolutePagePath = CMyString.setStrEndWith(_sAbsolutePagePath, File.separatorChar)) + _sPageName).toUpperCase();
        PageParameters aPageParameters = (PageParameters)m_hPageParametersCache.get(sKey);
        if (aPageParameters != null) {
            return aPageParameters;
        }
        int nPose = _sPageName.indexOf(".");
        String sFilePrefix = "";
        sFilePrefix = nPose > 0 ? _sPageName.substring(0, nPose) : _sPageName;
        String sAbsolutInfoFile = _sAbsolutePagePath + sFilePrefix + ".xml";
        aPageParameters = new PageParameters();
        aPageParameters.loadParametersFromXML(sAbsolutInfoFile);
        m_hPageParametersCache.put(sKey, aPageParameters);
        return aPageParameters;
    }

    public static synchronized PageParameters reloadParametersOfPageName(String _sPageName, String _sAbsolutePagePath) throws WCMException {
        if (_sPageName == null || _sAbsolutePagePath == null || _sPageName.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(PageParameters.class, "PageParameters.label2", "\u6ca1\u6709\u6307\u5b9a\u9875\u9762\u76f8\u5173\u53c2\u6570\uff01"));
        }
        String sKey = (_sAbsolutePagePath + _sPageName).toUpperCase();
        m_hPageParametersCache.remove(sKey);
        return PageParameters.loadParametersOfPage(_sPageName, _sAbsolutePagePath);
    }

    public static void removeParametersOfPageName(String _sKey) {
        m_hPageParametersCache.remove(_sKey.toUpperCase());
    }

    public static Enumeration getPages() {
        return m_hPageParametersCache.keys();
    }

    public static void main(String[] args) {
        try {
            String sInfoFileName = "c:\\document_list_of_channel.xml";
            if (!CMyFile.fileExists(sInfoFileName)) {
                throw new WCMException(10, I18NMessage.get(PageParameters.class, "PageParameters.label3", "\u914d\u7f6e\u6587\u4ef6[") + sInfoFileName + I18NMessage.get(PageParameters.class, "PageParameters.label4", "]\u4e0d\u5b58\u5728!"));
            }
            System.out.println(I18NMessage.get(PageParameters.class, "PageParameters.label5", "\u6d4b\u8bd5 loadParametersFromXML \u63a5\u53e3..."));
            PageParameters aPageParameters = new PageParameters();
            aPageParameters.loadParametersFromXML(sInfoFileName);
            System.out.println(aPageParameters.toString());
            for (int i = 0; i < aPageParameters.size(); ++i) {
                PageParameter aPageParameter = (PageParameter)aPageParameters.get(i);
                if (aPageParameter == null) continue;
                System.out.println("Name:" + aPageParameter.getName());
                System.out.println("Desc:" + aPageParameter.getDesc());
                System.out.println("isRequired:" + aPageParameter.isRequired());
                System.out.println("Type:" + aPageParameter.getType());
                System.out.println("getDefault:" + aPageParameter.getDefault());
            }
            System.out.println(I18NMessage.get(PageParameters.class, "PageParameters.label6", "\u6d4b\u8bd5 loadParametersOfPage \u63a5\u53e3..."));
            String sPageName = "page_info.jsp";
            String sAbsolutePagePath = "c:\\";
            aPageParameters = PageParameters.loadParametersOfPage(sPageName, sAbsolutePagePath);
            System.out.println(aPageParameters.toString());
            for (int i = 0; i < aPageParameters.size(); ++i) {
                PageParameter aPageParameter = (PageParameter)aPageParameters.get(i);
                if (aPageParameter == null) continue;
                System.out.println("Name:" + aPageParameter.getName());
                System.out.println("Desc:" + aPageParameter.getDesc());
                System.out.println("isRequired:" + aPageParameter.isRequired());
                System.out.println("Type:" + aPageParameter.getType());
                System.out.println("getDefault:" + aPageParameter.getDefault());
            }
            System.out.println(I18NMessage.get(PageParameters.class, "PageParameters.label7", "\u6d4b\u8bd5 getParametersOfPage \u63a5\u53e3..."));
            aPageParameters = PageParameters.getParametersOfPage(sPageName, sAbsolutePagePath);
            System.out.println(aPageParameters.toString());
            System.out.println(I18NMessage.get(PageParameters.class, "PageParameters.label8", "\u6d4b\u8bd5 Cache \u673a\u5236..."));
            aPageParameters = PageParameters.getParametersOfPage(sPageName, sAbsolutePagePath);
            System.out.println(aPageParameters.toString());
            System.out.println(I18NMessage.get(PageParameters.class, "PageParameters.label9", "\u6d4b\u8bd5reloadParametersOfPageName \u63a5\u53e3"));
            aPageParameters = PageParameters.reloadParametersOfPageName(sPageName, sAbsolutePagePath);
            System.out.println(aPageParameters.toString());
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(PageParameters.class, "PageParameters.label10", "\u6d4b\u8bd5\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
    }
}

