/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.login;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.LockerMgr;
import com.trs.infra.cluster.session.Acknowledged;
import com.trs.presentation.util.LoginHelper;
import java.io.Serializable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class SessionListener
implements HttpSessionBindingListener,
Serializable,
Acknowledged {
    private static transient int s_nCount = 0;
    private static transient int s_nVersion = 0;
    private Integer m_oUserKey;
    private static transient Vector s_arOnlineUsers = new Vector();

    public SessionListener(Integer _oUserKey) {
        this.m_oUserKey = _oUserKey;
    }

    public static int getCount() {
        return s_nCount;
    }

    public static Vector getOnlineUsers() {
        return s_arOnlineUsers;
    }

    public void valueBound(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        LoginHelper.putSession(this.m_oUserKey, session);
        if (s_arOnlineUsers.indexOf(this.m_oUserKey) < 0) {
            ++s_nCount;
            s_arOnlineUsers.add(this.m_oUserKey);
            ++s_nVersion;
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        LoginHelper.removeSession(session, this.m_oUserKey);
        --s_nCount;
        s_arOnlineUsers.remove(this.m_oUserKey);
        ++s_nVersion;
        User loginUser = null;
        try {
            loginUser = User.findByKey(this.m_oUserKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loginUser == null) {
            return;
        }
        if (loginUser.isLogined()) {
            loginUser.logout();
        }
        final User currUser = loginUser;
        Thread t = new Thread(){

            @Override
            public void run() {
                LockerMgr manager = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
                manager.freeLockedObjBy(currUser);
            }
        };
        t.start();
    }

    public static int getVersion() {
        return s_nVersion;
    }
}

