/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mobile;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.mobile.MyDBManager;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CreateMobileSite3 {
    private static Logger logger = Logger.getLogger(CreateMobileSite3.class);
    public static int DOCUMENT_CREATE_NUM = 200;
    private MyDBManager m_oMyDBMgr;
    private boolean m_bWJBhd = false;
    private static String m_sMessage = "";
    public static String m_sTemplateFile = "TEMPLATE--MOBILEPORTAL";
    private static Templates m_oTemplats = null;
    public static String[] m_sSiteOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u7ad9\u70b9\u9996\u9875", "\u7ad9\u70b9\u8f85\u52a9\u6a21\u677f"};
    public static String[] m_sChnlOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f"};
    public static String[] m_sPushMsgOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f", "\u6d88\u606f\u63a8\u9001\u6700\u65b0\u65f6\u95f4"};
    public static String m_sDetailTemplateNames = "\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u4e0d\u5e26\u683c\u5f0f,\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u5e26\u683c\u5f0f";
    private TemplateEmployMgr m_oEmployMgr = null;

    public CreateMobileSite3(MyDBManager _oMyDBMgr) {
        this.m_oMyDBMgr = _oMyDBMgr;
        this.m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    }

    public WebSite createMobileSite(int _nSrcSiteId, String _sTemplateType) throws Exception {
        WebSite oNewSite = this.createMobileSiteOnly(_nSrcSiteId);
        this.createMobileSiteFolderPublishConfig(oNewSite, _nSrcSiteId);
        this.importTemplate(_nSrcSiteId, _sTemplateType);
        this.configSiteTemplate(oNewSite.getId());
        this.createMobileChannels(_nSrcSiteId, 0, oNewSite.getId());
        return oNewSite;
    }

    private WebSite createMobileSiteOnly(int _nSrcSiteId) throws Exception {
        WebSite oNewSite;
        block17: {
            User loginUser = ContextHelper.getLoginUser();
            oNewSite = WebSite.createNewInstance();
            String SQL_QUERY_SITE = "select * from WCMWebSite where SiteId=?";
            Connection oConn = null;
            PreparedStatement oPreStmt = null;
            ResultSet result = null;
            try {
                oConn = this.m_oMyDBMgr.getConnection();
                oPreStmt = oConn.prepareStatement("select * from WCMWebSite where SiteId=?");
                oPreStmt.setInt(1, _nSrcSiteId);
                result = oPreStmt.executeQuery();
                if (result.next()) {
                    oNewSite.setName(result.getString("SiteName") + "_\u624b\u673a");
                    oNewSite.setDesc(oNewSite.getName());
                    oNewSite.setParent(0);
                    oNewSite.setType(result.getInt("SiteType"));
                    oNewSite.save(loginUser);
                    int nNewSiteId = oNewSite.getId();
                    String SQL_INSERT_RELATION = "insert into XWCMWEBSITEMAPPING(SrcSiteId, NewSiteId) values(" + _nSrcSiteId + ", " + nNewSiteId + ")";
                    DBManager.getDBManager().sqlExecuteUpdate(SQL_INSERT_RELATION);
                    break block17;
                }
                throw new Exception("\u6307\u5b9a\u7ad9\u70b9[SiteId=" + _nSrcSiteId + "]\u4e0d\u5b58\u5728!");
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to query data!", ex);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to close result", (Throwable)e);
                    }
                }
                if (oPreStmt != null) {
                    try {
                        oPreStmt.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                    }
                }
                if (oConn != null) {
                    this.m_oMyDBMgr.freeConnection(oConn);
                }
            }
        }
        return oNewSite;
    }

    private void createMobileSiteFolderPublishConfig(WebSite oNewSite, int _nSrcSiteId) throws WCMException {
        String sStatusCanDoPub;
        String sRootDomain;
        String sDataPath;
        block19: {
            sDataPath = "";
            sRootDomain = "";
            sStatusCanDoPub = "";
            String SQL_QUERY_SITE_PUBLISH_CONFIG = "select * from WCMFolerPublishConfig where FolderType=? and FolderId=?";
            Connection oConn = null;
            PreparedStatement oPreStmt = null;
            ResultSet result = null;
            try {
                oConn = this.m_oMyDBMgr.getConnection();
                oPreStmt = oConn.prepareStatement("select * from WCMFolerPublishConfig where FolderType=? and FolderId=?");
                oPreStmt.setInt(1, 103);
                oPreStmt.setInt(1, _nSrcSiteId);
                result = oPreStmt.executeQuery();
                if (result.next()) {
                    sDataPath = result.getString("DataPath");
                    sRootDomain = result.getString("RootDomain");
                    sStatusCanDoPub = result.getString("RootDomain");
                    break block19;
                }
                throw new Exception("\u6307\u5b9a\u7ad9\u70b9[SiteId=" + _nSrcSiteId + "]\u4e0d\u5b58\u5728!");
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to query data!", ex);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to close result", (Throwable)e);
                    }
                }
                if (oPreStmt != null) {
                    try {
                        oPreStmt.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                    }
                }
                if (oConn != null) {
                    this.m_oMyDBMgr.freeConnection(oConn);
                }
            }
        }
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        int nNewSiteId = oNewSite.getId();
        IPublishElement srcPublishElement = PublishElementFactory.lookupElement(103, nNewSiteId);
        WCMFolderPublishConfig srcPublishConfig = new WCMFolderPublishConfig((IPublishFolder)srcPublishElement);
        sRootDomain = sRootDomain.lastIndexOf("/") == sRootDomain.length() - 1 ? sRootDomain.substring(0, sRootDomain.length() - 1) : sRootDomain;
        sRootDomain = sRootDomain.substring(0, sRootDomain.lastIndexOf("/") + 1);
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter filter = new WCMFilter("", "FolderType=?", "");
        filter.addSearchValues(103);
        sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", sDataPath + "mobile", filter);
        JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
        HashMap<String, Object> serviceMap = new HashMap<String, Object>();
        String sServiceId = "wcm6_publish";
        String sMethodName = "saveSitePublishConfig";
        serviceMap.put("OBJECTID", nNewSiteId);
        serviceMap.put("SITETYPE", oNewSite.getType());
        serviceMap.put("DATAPATH", sDataPath);
        serviceMap.put("SITELANGUAGE", "8");
        serviceMap.put("PAGEENCODING", "utf-8");
        serviceMap.put("ROOTDOMAIN", sRootDomain + sDataPath);
        serviceMap.put("STATUSESCANDOPUB", sStatusCanDoPub);
        serviceMap.put("STATUSIDAFTERMODIFY", "1");
        try {
            processor.excute(sServiceId, sMethodName, serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u521b\u5efa\u7ad9\u70b9\u53d1\u5e03\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
    }

    private void importTemplate(int _nSiteId, String _sTemplateType) throws CMyException {
        String sTemplateDataPath;
        String sTempPath;
        m_sMessage = "\u6b63\u5728\u5bfc\u5165\u7ad9\u70b9\u6a21\u677f";
        String sMobileDataPath = this.getMobileDataPath();
        String sTemplateFileName = m_sTemplateFile + ".zip";
        String sTemplateDataFileBak = m_sTemplateFile + "_bak.zip";
        if (!CMyString.isEmpty(_sTemplateType) && CMyFile.fileExists(sMobileDataPath + m_sTemplateFile + _sTemplateType + ".zip")) {
            sTemplateFileName = m_sTemplateFile + _sTemplateType + ".zip";
            sTemplateDataFileBak = m_sTemplateFile + _sTemplateType + "_bak.zip";
        }
        if (!CMyFile.fileExists(sTempPath = (sTemplateDataPath = sMobileDataPath + sTemplateFileName) + "datatemp")) {
            CMyFile.makeDir(sTempPath, true);
        }
        sTemplateDataFileBak = sTempPath + File.separator + sTemplateDataFileBak;
        try {
            if (!CMyFile.fileExists(sTemplateDataPath)) {
                throw new WCMException("\u79fb\u52a8\u95e8\u6237\u7684\u6a21\u677f\u6587\u4ef6\u5305\u4e0d\u5b58\u5728\uff01\u3010" + sTemplateDataPath + "\u3011");
            }
            CMyFile.copyFile(sTemplateDataPath, sTemplateDataFileBak);
            JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
            HashMap<String, Object> serviceMap = new HashMap<String, Object>();
            String sServiceId = "wcm6_template";
            String sMethodName = "importTemplates";
            serviceMap.put("IMPORTFILE", sTemplateDataFileBak);
            serviceMap.put("SRCFILENAME", "TEMPLATE--MOBILEPORTAL.zip");
            serviceMap.put("IMPORTMODE", 1);
            serviceMap.put("PICMODE", 1);
            serviceMap.put("HOSTID", _nSiteId);
            serviceMap.put("HOSTTYPE", 103);
            serviceMap.put("FILEENCODE", "utf-8");
            processor.excute(sServiceId, sMethodName, serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u5bfc\u5165\u6a21\u677f\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
        finally {
            CMyFile.deleteDir(sTempPath);
            m_oTemplats.clear();
        }
    }

    private void configSiteTemplate(int nSiteId) throws WCMException {
        m_sMessage = "\u6b63\u5728\u914d\u7f6e\u7ad9\u70b9\u6a21\u677f";
        String sOutlineTemplateIds = this.getSiteOutLineTemplatesIds(nSiteId);
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, nSiteId);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, sOutlineTemplateIds, false);
    }

    private String getSiteOutLineTemplatesIds(int _siteId) throws WCMException {
        String sTemplateName;
        Template template;
        int i;
        Templates templates = this.getSiteAllTemplates(_siteId);
        StringBuffer outlineTemplateIds = new StringBuffer();
        for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            if (!m_sSiteOutlineTemplateNames[0].equals(sTemplateName)) continue;
            outlineTemplateIds.append(template.getId());
        }
        block1: for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            for (int k = 1; k < m_sSiteOutlineTemplateNames.length; ++k) {
                if (!m_sSiteOutlineTemplateNames[k].equals(sTemplateName)) continue;
                if (CMyString.isEmpty(outlineTemplateIds.toString())) {
                    outlineTemplateIds.append(template.getId());
                    continue block1;
                }
                outlineTemplateIds.append("," + template.getId());
                continue block1;
            }
        }
        return outlineTemplateIds.toString();
    }

    private Templates getSiteAllTemplates(int _nSiteId) throws WCMException {
        if (m_oTemplats != null) {
            return m_oTemplats;
        }
        IPublishFolder publishFolder = (IPublishFolder)PublishElementFactory.lookupElement(103, _nSiteId);
        TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        m_oTemplats = m_oTemplateMgr.getManagedTemplates(publishFolder, -1, null, true);
        return m_oTemplats;
    }

    private String getMobileDataPath() throws WCMException {
        String sAppDir = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if ("\\".equals(File.separator)) {
            sAppDir = CMyString.replaceStr(sAppDir, "/", File.separator);
        }
        if ((sAppDir = CMyString.setStrEndWith(sAppDir, File.separatorChar)) == null || sAppDir.trim().equals("")) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u6240\u5728\u8def\u5f84\uff01");
        }
        String sMobileDataPath = sAppDir + "app" + File.separator + "mobile" + File.separator + "data" + File.separator;
        return sMobileDataPath;
    }

    private void createMobileChannels(int _nSrcSiteId, int _nParentId, int _nNewSiteId) throws Exception {
        User loginUser = this.getLoginUser();
        Channels channels = Channels.createNewInstance(loginUser);
        String SQL_QUERY_CHANNELS = "select * from WCMChannel where SiteId=? and ParentId=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oMyDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(SQL_QUERY_CHANNELS);
            oPreStmt.setInt(1, _nSrcSiteId);
            oPreStmt.setInt(2, _nParentId);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                int nSrcChannelId = result.getInt("ChannelId");
                Channel oTempChannel = Channel.createNewInstance();
                oTempChannel.readFromRs(result, result.getMetaData());
                Channel oNewChannel = (Channel)oTempChannel.cloneToNewObj();
                oNewChannel.setSite(_nNewSiteId);
                oNewChannel.setParent(_nParentId);
                oNewChannel.save(loginUser);
                channels.addElement(oNewChannel);
                m_sMessage = "\u6b63\u5728\u521b\u5efa\u79fb\u52a8\u680f\u76ee[" + oNewChannel + "]";
                int nNewChannelId = oNewChannel.getId();
                String SQL_INSERT_RELATION = "insert into XWCMCHANNELMAPPING(SrcChannelId, NewChannelId) values(" + nSrcChannelId + ", " + nNewChannelId + ")";
                DBManager.getDBManager().sqlExecuteUpdate(SQL_INSERT_RELATION);
                this.createMobileChannelFolderPublishConfig(oNewChannel, nSrcChannelId);
                this.configChannelTemplate(oNewChannel);
                this.createDocuments(nSrcChannelId, nNewChannelId);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oMyDBMgr.freeConnection(oConn);
            }
        }
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.createMobileChannels(_nSrcSiteId, channel.getId(), _nNewSiteId);
        }
    }

    private void createMobileChannelFolderPublishConfig(Channel oNewChannel, int _nSrcChannelId) throws WCMException {
        String sDataPath;
        block17: {
            m_sMessage = "\u6b63\u5728\u521b\u5efa\u680f\u76ee[" + oNewChannel + "]\u7684\u53d1\u5e03\u4fe1\u606f";
            sDataPath = "";
            String SQL_QUERY__PUBLISH_CONFIG = "select * from WCMFolerPublishConfig where FolderType=? and FolderId=?";
            Connection oConn = null;
            PreparedStatement oPreStmt = null;
            ResultSet result = null;
            try {
                oConn = this.m_oMyDBMgr.getConnection();
                oPreStmt = oConn.prepareStatement(SQL_QUERY__PUBLISH_CONFIG);
                oPreStmt.setInt(1, 103);
                oPreStmt.setInt(1, _nSrcChannelId);
                result = oPreStmt.executeQuery();
                if (result.next()) {
                    sDataPath = result.getString("DataPath");
                    break block17;
                }
                throw new Exception("\u6307\u5b9a\u680f\u76ee[ChannelId=" + _nSrcChannelId + "]\u4e0d\u5b58\u5728!");
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to query data!", ex);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to close result", (Throwable)e);
                    }
                }
                if (oPreStmt != null) {
                    try {
                        oPreStmt.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                    }
                }
                if (oConn != null) {
                    this.m_oMyDBMgr.freeConnection(oConn);
                }
            }
        }
        int mobileChannelId = oNewChannel.getId();
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, mobileChannelId);
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, mobileChannelId);
        currPublishConfig.setDataPath(sDataPath);
        currPublishConfig.canEdit(this.getLoginUser());
        currPublishConfig.save(this.getLoginUser());
    }

    private void configChannelTemplate(Channel channel) throws WCMException {
        m_sMessage = "\u6b63\u5728\u4e3a\u79fb\u52a8\u680f\u76ee\u3010" + channel.getName() + "\u3011\u914d\u7f6e\u6a21\u677f";
        int nSiteId = channel.getSiteId();
        IPublishElement publishElement = PublishElementFactory.makeElementFrom(channel);
        String sOutlineTemplateIds = this.getChannelOutLineTemplatesIds(nSiteId);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, sOutlineTemplateIds, false);
        int nDetailTemplateId = this.getDetailTemplateId(nSiteId);
        this.m_oEmployMgr.setDetailTemplate((IPublishFolder)publishElement, nDetailTemplateId, false);
    }

    private String getChannelOutLineTemplatesIds(int _siteId) throws WCMException {
        String sTemplateName;
        Template template;
        int i;
        Templates templates = this.getSiteAllTemplates(_siteId);
        StringBuffer outlineTemplateIds = new StringBuffer();
        for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            if (!m_sChnlOutlineTemplateNames[0].equals(sTemplateName)) continue;
            outlineTemplateIds.append(template.getId());
        }
        block1: for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            for (int k = 1; k < m_sChnlOutlineTemplateNames.length; ++k) {
                if (!m_sChnlOutlineTemplateNames[k].equals(sTemplateName)) continue;
                if (CMyString.isEmpty(outlineTemplateIds.toString())) {
                    outlineTemplateIds.append(template.getId());
                    continue block1;
                }
                outlineTemplateIds.append("," + template.getId());
                continue block1;
            }
        }
        return outlineTemplateIds.toString();
    }

    private int getDetailTemplateId(int _siteId) throws WCMException {
        Templates templates = this.getSiteAllTemplates(_siteId);
        int nTemplateId = 0;
        String[] detailTemplateNames = m_sDetailTemplateNames.split(",");
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            String sTemplateName = template.getName();
            if (this.m_bWJBhd) {
                if (sTemplateName.equals(detailTemplateNames[1])) {
                    nTemplateId = template.getId();
                }
            } else if (sTemplateName.equals(detailTemplateNames[0])) {
                nTemplateId = template.getId();
            }
            if (nTemplateId > 0) break;
        }
        return nTemplateId;
    }

    private void createDocuments(int srcChannel, int newChannel) throws WCMException {
        String SQL_QUERY_CHANNELS = "select WCMDocument.*, CHNLID from WCMChnlDoc, WCMDocument where ChnlId=? Order By CrTime ASC";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oMyDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(SQL_QUERY_CHANNELS);
            oPreStmt.setInt(1, srcChannel);
            oPreStmt.setMaxRows(DOCUMENT_CREATE_NUM);
            result = oPreStmt.executeQuery();
            Channel channel = Channel.findById(srcChannel);
            while (result.next()) {
                m_sMessage = "\u6b63\u5728\u521b\u5efa\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u7684\u6587\u6863\u3010" + result.getInt("DOCCHANNEL") + "\u3011";
                JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
                HashMap<String, Object> serviceMap = new HashMap<String, Object>();
                String sServiceId = "wcm6_document";
                String sMethodName = "save";
                serviceMap.put("OBJECTID", "0");
                serviceMap.put("DOCCHANNEL", String.valueOf(result.getInt("CHNLID")));
                serviceMap.put("DOCTITLE", result.getInt("DOCCHANNEL"));
                serviceMap.put("DOCCONTENT", result.getInt("DOCCONTENT"));
                serviceMap.put("DOCHTMLCONTENT", result.getInt("DOCHTMLCONTENT"));
                processor.excute(sServiceId, sMethodName, serviceMap);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oMyDBMgr.freeConnection(oConn);
            }
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

