/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mlf.log;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.mlf.log.ILogServer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LogServer
implements ILogServer {
    private static Logger logger = Logger.getLogger(LogServer.class);
    private static final String SPERATOR_FOR_LOG = " @ ";

    @Override
    public void operation(User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc, String _sMediaName) {
        this.log(2, _oOper, _dtOpr, _sOprKey, _sOprDesc, _sMediaName);
    }

    @Override
    public void security(User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc) {
        this.log(5, _oOper, _dtOpr, _sOprKey, _sOprDesc, "");
    }

    @Override
    public void debug(User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc) {
        this.log(1, _oOper, _dtOpr, _sOprKey, _sOprDesc, "");
    }

    @Override
    public void error(User _oOper, CMyDateTime _dtOpr, int _nErrorType, String _sErrorDesc, Exception _e) {
        String sMediaName = "";
        int nUseTime = -1;
        this.log(3, _oOper, _dtOpr, "[" + _nErrorType + "]" + _sErrorDesc, _sErrorDesc, sMediaName, nUseTime, _e);
    }

    @Override
    public void elapsed(User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc, int _nTime) {
        this.log(4, _oOper, _dtOpr, _sOprKey, _sOprDesc, "", _nTime);
    }

    public static String getCallMeInfo(int _nDepth) {
        int nDepth = _nDepth;
        StackTraceElement[] pStackTraceElements = new Throwable().getStackTrace();
        if (nDepth >= pStackTraceElements.length) {
            nDepth = pStackTraceElements.length - 1;
        }
        StackTraceElement oStackTraceElement = pStackTraceElements[nDepth];
        return oStackTraceElement.getClassName() + "." + oStackTraceElement.getMethodName() + "(" + oStackTraceElement.getFileName() + " " + oStackTraceElement.getLineNumber() + ")";
    }

    private void log(int _nLogType, User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc, String _sMediaName) {
        this.log(_nLogType, _oOper, _dtOpr, _sOprKey, _sOprDesc, _sMediaName, -1);
    }

    private void log(int _nLogType, User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc, String _sMediaName, int _nTime) {
        this.log(_nLogType, _oOper, _dtOpr, _sOprKey, _sOprDesc, _sMediaName, _nTime, null);
    }

    private void log(int _nLogType, User _oOper, CMyDateTime _dtOpr, String _sOprKey, String _sOprDesc, String _sMediaName, int _nTime, Exception _e) {
        StringBuffer sbLogInfo = new StringBuffer(256);
        sbLogInfo.append(_nLogType);
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(_oOper.getTrueName() + "(" + _oOper.getName() + "-" + _oOper.getId() + ")");
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(_dtOpr.toString("yyyy-MM-dd HH:mm:ss"));
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(_oOper.getAttributeValue("LoginIP"));
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(_sMediaName);
        sbLogInfo.append(SPERATOR_FOR_LOG);
        String sDispName = "";
        if (_sOprKey.contains("@")) {
            String[] operDesc = CMyString.split(_sOprKey, "@");
            sbLogInfo.append(operDesc[0] + "(" + operDesc[1] + ")");
        } else if (LogServer.getSubNumber(_sOprKey, "\\.") < 1) {
            sbLogInfo.append(_sOprKey);
        } else {
            sDispName = _sOprKey;
            sbLogInfo.append(sDispName + "(" + _sOprKey + ")");
        }
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(_sOprDesc);
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(_nTime >= 0 ? "\u6267\u884c\u8017\u65f6[" + _nTime + "]ms" : "");
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(LogServer.getCallMeInfo(3));
        sbLogInfo.append(SPERATOR_FOR_LOG);
        sbLogInfo.append(this.makeException(_e));
        sbLogInfo.append(SPERATOR_FOR_LOG);
        String sDept = _oOper.getAttributeValue("GroupPath");
        if (!CMyString.isEmpty(sDept)) {
            sDept = sDept.substring(0, sDept.length() - 2);
        }
        sbLogInfo.append(sDept);
        sbLogInfo.append(SPERATOR_FOR_LOG);
        logger.info((Object)sbLogInfo);
    }

    public String makeException(Exception _e) {
        if (_e == null) {
            return "";
        }
        String sResult = CMyException.getStackTraceText(_e);
        sResult = sResult.replaceAll("\n", "\\\\n");
        sResult = sResult.replaceAll("\r", "\\\\r");
        sResult = sResult.replaceAll("\t", "\\\\t");
        return sResult;
    }

    public static void my0() {
        for (int i = 0; i < 4; ++i) {
            System.out.println("=============" + i + "===========");
            System.out.println(LogServer.getCallMeInfo(i));
        }
    }

    public static void my1() {
        LogServer.my0();
    }

    public static void my2() {
        LogServer.my1();
    }

    public static void main(String[] args) {
        String sResult = "mytest \n dafdf \n dfdsafsd";
        System.err.println(sResult);
        sResult = sResult.replaceAll("\n", "\\\\n");
        sResult = sResult.replaceAll("\r", "\\\\r");
        sResult = sResult.replaceAll("\t", "\\\\t");
        System.err.println("==========================");
        System.err.println(sResult);
        LogServer.my2();
    }

    private static int getSubNumber(String des, String reg) {
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(des);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }
}

