/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.TypeInfo;
import com.trs.infra.util.upgrade.dbcompare.TypeInfoMap;

public class Column {
    public String name;
    public int type;
    public String typeName;
    public boolean nullAble;
    public String defaultValue;
    public int length;
    public int scale;
    public int order;
    public boolean useNull = true;

    public Column(String name, int type, String typeName) {
        this.name = name.toUpperCase();
        this.type = type;
        this.typeName = typeName.toLowerCase();
    }

    public int hashCode() {
        if (this.name == null) {
            return super.hashCode();
        }
        return this.name.hashCode();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null) {
            return false;
        }
        if (another.getClass() != Column.class) {
            return false;
        }
        Column column = (Column)another;
        boolean lengthDiff = this.length > column.length || this.scale != column.scale;
        return !lengthDiff;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append('\"');
        buff.append(this.name);
        buff.append('\"');
        buff.append(' ').append(this.typeName);
        TypeInfo typeInfo = TypeInfoMap.get(this.typeName);
        if (typeInfo == null) {
            buff.append(" (");
            buff.append(this.length);
            if (this.scale != 0) {
                buff.append(", ").append(this.scale);
            }
            buff.append(")");
        } else if (typeInfo.getCrtParamsCount() != 0) {
            buff.append(" (");
            buff.append(this.length);
            if (typeInfo.getCrtParamsCount() == 2) {
                buff.append(',').append(this.scale);
            }
            buff.append(')');
        }
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            buff.append(" default ");
            buff.append(this.defaultValue);
        }
        if (this.useNull) {
            if (!this.nullAble) {
                buff.append(" not");
            }
            buff.append(" null");
        }
        return buff.toString();
    }
}

