/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

public class FtpConfig {
    private String m_sProtocol;
    private boolean m_zAnonymous;
    private String m_sUserName;
    private String m_sPassWord;
    private String m_sHost;
    private int m_iPort;
    private String m_sRootPath;
    private boolean m_zPassive;
    private int m_iMaxClient;
    private long m_lMaxIdleMills = 300000L;

    public String getProtocol() {
        return this.m_sProtocol;
    }

    public void setProtocol(String protocol) {
        this.m_sProtocol = protocol.toUpperCase();
        if (this.m_iPort <= 0) {
            if ("FTP".equals(protocol)) {
                this.m_iPort = 21;
            } else if ("FTPS".equals(protocol)) {
                this.m_iPort = 990;
            } else if ("SFTP".equals(protocol)) {
                this.m_iPort = 22;
            } else if ("GFTP".equals(protocol)) {
                this.m_iPort = 2021;
            }
        }
    }

    public boolean getAnonymous() {
        return this.m_zAnonymous;
    }

    public void setAnonymous(boolean zAnonymous) {
        this.m_zAnonymous = zAnonymous;
    }

    public String getUserName() {
        if (this.m_zAnonymous) {
            return "anonymous";
        }
        return this.m_sUserName;
    }

    public void setUserName(String userName) {
        this.m_sUserName = userName;
    }

    public String getPassWord() {
        if (this.m_zAnonymous) {
            return "anonymous@anonymous.com";
        }
        return this.m_sPassWord;
    }

    public void setPassWord(String passWord) {
        this.m_sPassWord = passWord;
    }

    public String getHost() {
        return this.m_sHost;
    }

    public void setHost(String host) {
        this.m_sHost = host;
    }

    public int getPort() {
        return this.m_iPort;
    }

    public void setPort(int port) {
        if (port > 0) {
            this.m_iPort = port;
        }
    }

    public String getRootPath() {
        return this.m_sRootPath;
    }

    public void setRootPath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.m_sRootPath = path;
    }

    public boolean getPassive() {
        return this.m_zPassive;
    }

    public void setPassive(boolean passive) {
        this.m_zPassive = passive;
    }

    public int getMaxClient() {
        return this.m_iMaxClient;
    }

    public void setMaxClient(int maxClient) {
        this.m_iMaxClient = maxClient;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(this.m_sProtocol);
        sb.append("://");
        sb.append(this.m_sHost);
        sb.append(":");
        sb.append(this.m_iPort);
        if (this.m_sRootPath == null || this.m_sRootPath.length() <= 0) {
            sb.append('/');
        } else {
            if (this.m_sRootPath.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(this.m_sRootPath);
        }
        return sb.toString();
    }

    public void setMaxIdleTime(int maxTime) {
        this.m_lMaxIdleMills = (long)maxTime * 1000L;
    }

    public long getMaxIdleMills() {
        return this.m_lMaxIdleMills;
    }
}

