/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.html.HtmlElement;

public class HtmlElementFinder {
    private char[] srcBuffer = null;
    private int nCurrPos = 0;
    public StringBuffer conBuffer = null;

    public HtmlElementFinder() {
    }

    public HtmlElementFinder(String _src) {
        this.setHtmlSrc(_src);
    }

    public HtmlElementFinder(char[] _src) {
        this.setHtmlSrc(_src);
    }

    public void setPosition(int _nPos) {
        this.nCurrPos = _nPos;
    }

    public HtmlElementFinder setHtmlSrc(String _src) {
        if (_src == null) {
            _src = "";
        }
        return this.setHtmlSrc(_src.toCharArray());
    }

    public HtmlElementFinder setHtmlSrc(char[] _src) {
        this.srcBuffer = _src;
        this.conBuffer = new StringBuffer();
        return this;
    }

    public String getContent() {
        if (this.conBuffer == null) {
            return "";
        }
        return this.conBuffer.toString();
    }

    public HtmlElement findNextElement(String _sName) {
        return this.findNextElement(_sName, false);
    }

    public HtmlElement findNextElement(String _sName, boolean _bOnlySearchSelf, String _sTagsToSkip) {
        _sName = "<" + _sName.trim().toLowerCase();
        char[] TAGNAME = _sName.toCharArray();
        int nLen = this.srcBuffer.length;
        while (this.nCurrPos < nLen) {
            char aChar = this.srcBuffer[this.nCurrPos];
            if (aChar == '<') {
                int i;
                for (i = 1; i < TAGNAME.length && this.nCurrPos + i < nLen && Character.toLowerCase(this.srcBuffer[this.nCurrPos + i]) == TAGNAME[i]; ++i) {
                }
                if (i == TAGNAME.length && (i += this.nCurrPos) < nLen && (Character.isWhitespace(this.srcBuffer[i]) || this.srcBuffer[i] == '>')) {
                    HtmlElement element = new HtmlElement();
                    element.ONLY_SEARCH_SELF = _bOnlySearchSelf;
                    try {
                        int nNextPos = element.fromString(this.srcBuffer, this.nCurrPos, _sTagsToSkip);
                        if (nNextPos > 0) {
                            this.nCurrPos = nNextPos;
                            return element;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.conBuffer.append(aChar);
            ++this.nCurrPos;
        }
        return null;
    }

    public HtmlElement findNextElement(String _sName, boolean _bOnlySearchSelf) {
        return this.findNextElement(_sName, _bOnlySearchSelf, null);
    }

    public HtmlElementFinder putElement(HtmlElement _element) {
        if (_element != null) {
            this.conBuffer.append(_element.toString(true, false));
        }
        return this;
    }

    public HtmlElementFinder putHTML(String _sHTML) {
        if (_sHTML != null) {
            this.conBuffer.append(_sHTML);
        }
        return this;
    }

    public static void main(String[] args) {
        try {
            String sFileName = "c:\\test.html";
            String strSrc = CMyFile.readFile(sFileName);
            System.out.println("\n\n*****************  Result *********************");
            String[] arTagName = new String[7];
            arTagName[0] = "TABLE";
            String[] arTagSrcName = new String[]{"SRC", "BACKGROUND", "BACKGROUND", "BACKGROUND", "SRC", "HREF", "SRC"};
            String strTagSkip = "p,div,form";
            for (int i = 0; i < arTagName.length; ++i) {
                if (arTagName[i] == null) continue;
                HtmlElementFinder imgReader = new HtmlElementFinder();
                imgReader.setHtmlSrc(strSrc);
                HtmlElement element = imgReader.findNextElement(arTagName[i], false, strTagSkip);
                int nCount = 0;
                while (element != null) {
                    if (nCount <= 1) {
                        System.out.println("[FOUND]" + element.toString(true, false, strTagSkip));
                    }
                    String sHtml = "";
                    imgReader.putHTML(element.toString(true, false, strTagSkip) + sHtml);
                    ++nCount;
                    element = imgReader.findNextElement(arTagName[i], false, strTagSkip);
                }
                strSrc = imgReader.getContent();
                System.out.println(I18NMessage.get(HtmlElementFinder.class, "HtmlElementFinder.label1", "\u5904\u7406\u8282\u70b9[") + arTagName[i] + I18NMessage.get(HtmlElementFinder.class, "HtmlElementFinder.label2", "]\u53d1\u73b0[") + nCount + I18NMessage.get(HtmlElementFinder.class, "HtmlElementFinder.label3", "]\u4e2a"));
            }
            System.out.println("\n\n*****************  Result *********************");
            CMyFile.writeFile("d:\\result.html", strSrc);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

