/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.ftp;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.ftp.CMyFtp;
import com.trs.infra.util.ftp.FtpConnectionPool;
import com.trs.infra.util.ftp.IFtpMgr;

public class FtpMgr
implements IFtpMgr {
    private FtpConnectionPool m_ftpConnectionPool;
    private String m_sServerHost;
    private boolean m_bCheckWriteAuth = false;

    @Override
    public void init(String _sServer, String _sLoginUser, String _sPassword, String _sRootDir, boolean _bPassiveMode, int _nMaxConnections) throws CMyException {
        this.m_ftpConnectionPool = new FtpConnectionPool(_sServer, _sLoginUser, _sPassword, _sRootDir, _bPassiveMode, _nMaxConnections);
        if (this.isCheckWriteAuth()) {
            CMyFtp ftp = this.m_ftpConnectionPool.getConnection();
            try {
                if (!ftp.makeDirectory("_test_")) {
                    throw new CMyException(I18NMessage.get(FtpMgr.class, "FtpMgr.label1", "\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55\uff01"));
                }
                this.m_ftpConnectionPool.free(ftp);
            }
            catch (Exception e) {
                try {
                    this.m_ftpConnectionPool.clear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.m_sServerHost = _sServer;
    }

    @Override
    public String getServerHost() {
        return this.m_sServerHost;
    }

    public void clear() {
        this.m_ftpConnectionPool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upload(String _sLocalFtpFile, String _sRemoteFile) throws CMyException {
        CMyFtp ftpConnection = this.m_ftpConnectionPool.getConnection();
        try {
            boolean bl = ftpConnection.uploadFile(_sLocalFtpFile, _sRemoteFile);
            return bl;
        }
        finally {
            this.m_ftpConnectionPool.free(ftpConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePath(String _sRemotePath) throws Exception {
        CMyFtp ftpConnection = this.m_ftpConnectionPool.getConnection();
        try {
            boolean bl = ftpConnection.removeDirectory(_sRemotePath);
            return bl;
        }
        finally {
            this.m_ftpConnectionPool.free(ftpConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFile(String _sRemoteFile) throws Exception {
        CMyFtp ftpConnection = this.m_ftpConnectionPool.getConnection();
        try {
            boolean bl = ftpConnection.removeFile(_sRemoteFile, true);
            return bl;
        }
        finally {
            this.m_ftpConnectionPool.free(ftpConnection);
        }
    }

    public boolean isCheckWriteAuth() {
        return this.m_bCheckWriteAuth;
    }

    public void setCheckWriteAuth(boolean checkWriteAuth) {
        this.m_bCheckWriteAuth = checkWriteAuth;
    }
}

