/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.file;

import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class JavaScriptEscape {
    private static char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static String encoding = System.getProperty("file.encoding");
    private static FileStore dirTarget;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("JavaScriptEscape [-encoding <encoding>] [-d <out dir>] file ...");
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-encoding".equals(args[i])) {
                if (++i < args.length) {
                    encoding = args[i];
                    continue;
                }
                System.err.println("encoding parameter not present.");
                continue;
            }
            if ("-d".equals(args[i])) {
                if (++i < args.length) {
                    JavaScriptEscape.ensureTarget(args[i]);
                    continue;
                }
                System.err.println("target directory parameter not present.");
                continue;
            }
            FileService file = new FileService(args[i]);
            if (file.exists()) {
                JavaScriptEscape.escapePath(file);
                continue;
            }
            System.err.println('\'' + args[i] + "' not exists.");
        }
    }

    private static void ensureTarget(String file) {
        FileService path = new FileService(file);
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!path.exists()) {
            System.err.println("create directory '" + file + "' failed.");
            System.exit(1);
        }
        if (!path.isDirectory()) {
            System.err.println("'" + file + "' not directory.");
            System.exit(2);
        }
        dirTarget = path;
    }

    private static void escapePath(FileStore path) {
        if (path.isDirectory()) {
            FileStore[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                JavaScriptEscape.escapePath(files[i]);
            }
        } else {
            JavaScriptEscape.escapeFile(path);
        }
    }

    public static String char2hex(int j) {
        char[] buf = new char[6];
        for (int i = buf.length - 1; i >= 0; --i) {
            buf[i] = DIGITS[j & 0xF];
            j >>>= 4;
        }
        buf[0] = 92;
        buf[1] = 117;
        return new String(buf);
    }

    private static boolean isJavaScriptFile(FileStore file) {
        String name = file.getName();
        if (name.length() <= 3) {
            return false;
        }
        String ext = name.substring(name.length() - 3);
        return ext.equalsIgnoreCase(".JS");
    }

    private static void escapeFile(FileStore file) {
        if (!JavaScriptEscape.isJavaScriptFile(file)) {
            return;
        }
        JavaScriptEscape.log("From File:" + file.getAbsolutePath());
        try {
            int c = 0;
            StringBuffer sb = new StringBuffer((int)file.length() * 2);
            InputStream fis = file.getInputStream();
            InputStreamReader isr = new InputStreamReader(fis, encoding);
            BufferedReader reader = new BufferedReader(isr);
            while ((c = reader.read()) != -1) {
                if (c < 128) {
                    sb.append((char)c);
                    continue;
                }
                sb.append(JavaScriptEscape.char2hex(c));
            }
            reader.close();
            JavaScriptEscape.outResult(sb.toString(), file);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(3);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void outResult(String result, FileStore file) throws IOException {
        FileStore fileTarget = null;
        fileTarget = dirTarget == null ? file : new FileService(dirTarget, file.getName());
        JavaScriptEscape.log("  To File:" + fileTarget.getAbsolutePath());
        OutputStream fos = fileTarget.getOutputStream();
        fos.write(result.getBytes("ISO8859-1"));
        fos.close();
    }

    public static final void log(String s) {
        System.out.println(s);
    }
}

