/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.SQLServerDB;
import java.sql.ResultSet;
import java.sql.SQLException;

public class XuguDB
extends SQLServerDB {
    private static final int TYPES_NVARCHAR = -9;
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType INTEGER = new DataType("INTEGER", 4, 4);
    public static final DataType CLOB = new DataType("CLOB", -1, 16);
    static final DataType[] m_allDataTypes = new DataType[]{BIGINT, CHAR, DATETIME, FLOAT, INT, INTEGER, NUMERIC, REAL, SMALLINT, TINYINT, VARCHAR, CLOB, NVARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, VARCHAR, CLOB, DATETIME, FLOAT, INTEGER, NVARCHAR};

    public XuguDB() {
        this("XuguDB", "com.xugu.jdbc.Driver");
    }

    public XuguDB(String name, String driver) {
        super(name, driver);
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2005, "clob");
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        try {
            return p_rsData.getString(p_nFieldIndex);
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u8bfb\u53d6CLOB\u5185\u5bb9\u5931\u8d25", ex);
        }
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        try {
            return p_rsData.getString(p_sFieldName);
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u8bfb\u53d6CLOB\u5185\u5bb9\u5931\u8d25", ex);
        }
    }

    @Override
    public String sqlGetSysDate() {
        return "sysdate()";
    }

    @Override
    public String sqlGetNextId() {
        return null;
    }

    @Override
    public String sqlQueryTableInfos(String _sOwnerUser) {
        return null;
    }

    @Override
    public String sqlQueryTableInfo(String _sOwnerUser, String _sDBTableName) {
        return null;
    }

    @Override
    public String sqlConcatStr(String str1, String str2, String str3) {
        return this.sqlConcatStr(new String[]{str1, str2, str3});
    }

    @Override
    public String sqlConcatStr(String str1, String str2) {
        return this.sqlConcatStr(new String[]{str1, str2});
    }

    @Override
    public String sqlConcatStr(String[] ls) {
        StringBuffer sql = new StringBuffer(128);
        sql.append(ls[0]);
        int len = ls.length;
        for (int i = 1; i < len; ++i) {
            sql.append("||").append(ls[i]);
        }
        return sql.toString();
    }

    @Override
    public String sqlDate(String dateTime) {
        return this.sqlDateTime(dateTime, "YYYY-MM-DD HH24:MI:SS");
    }

    @Override
    public String sqlDateField(String dateField) {
        return dateField;
    }

    @Override
    public String sqlDateTime(String dateTime, String format) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("TO_DATE('");
        sql.append(dateTime);
        sql.append("','");
        sql.append(format);
        sql.append("')");
        return sql.toString();
    }

    @Override
    public String sqlFilterForClob(String fieldName, String value) {
        return "";
    }

    @Override
    public String sqlAddField(String tableName, String fieldName, String fieldType, int maxLength, boolean nullable, String defaultValue, int scale) {
        DataType dataType = this.getDataType(fieldType);
        if (dataType == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(tableName.toUpperCase());
        sql.append(" add ").append(fieldName.toUpperCase());
        int nMaxLength = maxLength;
        switch (dataType.getType()) {
            case 2: 
            case 4: {
                sql.append(" integer ");
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 6: {
                sql.append(" float ");
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                sql.append(" datetime ");
                break;
            }
            case -9: 
            case 12: {
                sql.append(" varchar ");
                break;
            }
        }
        if (dataType.isLengthDefinedByUser()) {
            sql.append('(').append(nMaxLength);
            if (scale > 0) {
                sql.append(',').append(scale);
            }
            sql.append(')');
        }
        return sql.toString();
    }

    @Override
    public String sqlRenameField(String tableName, String oldFieldName, String newFieldName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(tableName.toUpperCase());
        sql.append(" rename ");
        sql.append(oldFieldName.toUpperCase());
        sql.append(" to ");
        sql.append(newFieldName.toUpperCase());
        return sql.toString();
    }

    @Override
    public String sqlRenameTable(String oldTableName, String newTableName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(oldTableName.toUpperCase());
        sql.append(" rename to");
        sql.append(newTableName.toUpperCase());
        return sql.toString();
    }

    @Override
    public String sqlModifyField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _bNullable, int _nScale) throws WCMException {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(_sTableName);
        sql.append(" alter column ");
        sql.append(_sFieldName);
        sql.append(this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale));
        return sql.toString();
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("extract_day(");
        buff.append(_sFieldName);
        buff.append("-'");
        buff.append(_sDateTime);
        buff.append("')=0");
        return buff.toString();
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }
}

