/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.TypeNames;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;

public abstract class DBType {
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 2;
    private String sName;
    private String sDriverClass;
    private boolean bSupportStoredProc;
    private Hashtable hDataTypes;
    private final TypeNames typeNames = new TypeNames();
    public static final int MAX_PAGE_SIZE = 9999;
    public static final DataType OTHER = new DataType("", 1111);

    public DBType(String _sName, String _sDriverClass, boolean _bSupportStoredProc) {
        this.sName = _sName;
        this.sDriverClass = _sDriverClass;
        this.bSupportStoredProc = _bSupportStoredProc;
        DataType[] allDataTypes = this.getAllDataTypes();
        this.hDataTypes = new Hashtable(allDataTypes.length);
        for (int i = 0; i < allDataTypes.length; ++i) {
            this.hDataTypes.put(allDataTypes[i].getName(), allDataTypes[i]);
        }
        this.registerDBInfo();
    }

    protected void registerDBInfo() {
    }

    public String getName() {
        return this.sName;
    }

    public String getDriverClass() {
        return this.sDriverClass;
    }

    public DBType setDriverClass(String _sDriverClass) {
        this.sDriverClass = _sDriverClass;
        return this;
    }

    public boolean isSupportStoredProc() {
        return this.bSupportStoredProc;
    }

    public abstract String encodeStrToWrite(String var1);

    public abstract boolean canWriteTextDirectly();

    public abstract DataType[] getAllDataTypes();

    public abstract DataType[] getSupportedDataTypes();

    public DataType getDataType(String _name) {
        if (_name == null) {
            return null;
        }
        DataType dataType = (DataType)this.hDataTypes.get(_name.toUpperCase());
        return dataType == null ? OTHER : dataType;
    }

    protected void registerColumnType(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    public String getTypeName(int code) throws WCMException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new WCMException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getTypeName(int code, int length, int precision, int scale) throws WCMException {
        String result = this.typeNames.get(code, length, precision, scale);
        if (result == null) {
            throw new WCMException("No type mapping for java.sql.Types code: " + code + ", length: " + length);
        }
        return result;
    }

    public String getCastTypeName(int code) throws WCMException {
        return this.getTypeName(code, 255, 19, 2);
    }

    public String sqlCreateTable() {
        return "create table";
    }

    public abstract String sqlConcatStr(String var1, String var2);

    public abstract String sqlConcatStr(String var1, String var2, String var3);

    public abstract String sqlConcatStr(String[] var1);

    public String sqlEscapeString(String s) {
        if (s == null) {
            return "NULL";
        }
        int iIndex1 = 0;
        int iIndex2 = 0;
        StringBuffer sb = new StringBuffer(s.length() + 16);
        sb.append('\'');
        while ((iIndex2 = s.indexOf(39, iIndex1)) >= 0) {
            sb.append(s.substring(iIndex1, iIndex2 + 1)).append('\'');
            iIndex1 = iIndex2 + 1;
        }
        sb.append(s.substring(iIndex1)).append('\'');
        return sb.toString();
    }

    public abstract String sqlFilterForClob(String var1, String var2);

    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable) {
        return this.sqlAddField(_sTableName, _sFieldName, _sFieldType, _nMaxLength, _bNullable, null, 0);
    }

    public abstract String sqlAddField(String var1, String var2, String var3, int var4, boolean var5, String var6, int var7);

    public String sqlAddField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _bNullable, String _sDefaultValue, int _nScale) throws WCMException {
        String strSQL = "ALTER TABLE " + _sTableName + " ADD " + _sFieldName + " " + this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale);
        strSQL = strSQL + " NULL";
        return strSQL;
    }

    public String sqlModifyField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _bNullable, int _nScale) throws WCMException {
        String strSQL = "ALTER TABLE " + _sTableName + " " + this.keywordsModifyField() + " " + _sFieldName + " " + this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale);
        return strSQL;
    }

    protected String keywordsModifyField() throws WCMException {
        throw new WCMException(this.getClass().getName() + I18NMessage.get(DBType.class, "DBType.label1", "\u4e0d\u652f\u6301\u5217\u5c5e\u6027\u7684\u4fee\u6539!"));
    }

    public String sqlCreateTableWithPrimary(String _sTableName, String _sPrimaryFieldName) throws WCMException {
        return this.sqlCreateTable() + " " + _sTableName + "(\n     " + _sPrimaryFieldName + " " + this.getTypeName(4) + " Primary Key\n)";
    }

    public String sqlRenameTable(String _sOldTableName, String _sNewTableName) throws WCMException {
        throw new WCMException(I18NMessage.get(DBType.class, "DBType.label2", "\u5c06\u8868[") + _sOldTableName + I18NMessage.get(DBType.class, "DBType.label3", "]\u91cd\u547d\u540d\u4e3a[") + _sNewTableName + I18NMessage.get(DBType.class, "DBType.label4", "]\u5931\u8d25\uff01\n\u56e0\u4e3a") + this.getClass().getName() + I18NMessage.get(DBType.class, "DBType.label5", "\u6ca1\u6709\u5b9e\u73b0\u8868\u7684\u91cd\u547d\u540d\uff01"));
    }

    public String sqlRenameField(String _sTableName, String _sOldFieldName, String _sNewFieldName) throws WCMException {
        throw new WCMException(I18NMessage.get(DBType.class, "DBType.label2", "\u5c06\u8868[") + _sTableName + I18NMessage.get(DBType.class, "DBType.label6", "]\u7684\u5b57\u6bb5[") + _sOldFieldName + I18NMessage.get(DBType.class, "DBType.label3", "]\u91cd\u547d\u540d\u4e3a[") + _sNewFieldName + I18NMessage.get(DBType.class, "DBType.label4", "]\u5931\u8d25\uff01\n\u56e0\u4e3a") + this.getClass().getName() + I18NMessage.get(DBType.class, "DBType.label7", "\u6ca1\u6709\u5b9e\u73b0\u5b57\u6bb5\u7684\u91cd\u547d\u540d\uff01"));
    }

    public String sqlDropField(String _sTableName, String _sFieldNames) throws Exception {
        return "ALTER TABLE " + _sTableName + " DROP COLUMN " + _sFieldNames;
    }

    public String sqlDropTable(String _sTableName) throws Exception {
        return "Drop TABLE " + _sTableName;
    }

    public abstract String sqlGetSysDate();

    public abstract String sqlFilterOneDay(String var1, String var2, String var3);

    public abstract String sqlDateTime(String var1, String var2);

    public abstract String sqlDate(String var1);

    public abstract String sqlDateField(String var1);

    public abstract String initQuerySQL(String var1, int var2, int var3);

    public abstract String sqlQueryTableInfos(String var1);

    public abstract String sqlQueryTableInfo(String var1, String var2);

    public abstract String sqlGetNextId();

    public abstract String getClob(ResultSet var1, boolean var2, int var3) throws CMyException;

    public abstract String getClob(ResultSet var1, boolean var2, String var3) throws CMyException;

    public abstract boolean setClob(Connection var1, String var2, String var3, String var4, String var5, String var6) throws CMyException;

    public abstract boolean setClob(Connection var1, String var2, String var3, String var4, String[] var5) throws CMyException;

    public abstract int getType();

    public void setStringFieldValue(PreparedStatement _oPreStmt, int _nIndex, String _sValue) throws Exception {
        _oPreStmt.setString(_nIndex, _sValue);
    }

    public void setStringFieldValue(PreparedStatement _oPreStmt, int _nIndex, String _sValue, boolean _bNullable) throws Exception {
        this.setStringFieldValue(_oPreStmt, _nIndex, _sValue);
    }

    public abstract boolean canDropField();

    public boolean setClob(Connection p_oConn, String p_sTableName, String sIdFieldName, int nObjId, String p_sClobFieldName, String p_sValue) throws CMyException {
        return this.setClob(p_oConn, p_sTableName, sIdFieldName + "=" + nObjId, sIdFieldName, p_sClobFieldName, p_sValue);
    }

    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sIdFieldName, int nObjId, String[] p_asFieldsAndValues) throws CMyException {
        return this.setClob(p_oConn, p_sTableName, p_sIdFieldName + "=" + nObjId, p_sIdFieldName, p_asFieldsAndValues);
    }
}

