/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static final Logger LOG = Logger.getLogger(SQLUtil.class);

    public static final boolean isValidOrder(String tableName, String orderExpression) {
        if (CMyString.isEmpty(orderExpression)) {
            return false;
        }
        if (CMyString.isEmpty(tableName) && orderExpression.indexOf(46) == -1) {
            return false;
        }
        String expression = orderExpression.trim().toLowerCase();
        String[] fields = expression.split(",");
        DBManager dbman = DBManager.getDBManager();
        boolean valid = true;
        int len = fields.length;
        for (int i = 0; i < len && valid; ++i) {
            int whitespaceIndex;
            String field = fields[i].trim();
            int dotIndex = field.indexOf(46);
            String tab = tableName;
            if (dotIndex != -1) {
                tab = field.substring(0, dotIndex);
                field = field.substring(dotIndex + 1).trim();
            }
            if ((whitespaceIndex = field.lastIndexOf(32)) != -1) {
                String direction = field.substring(whitespaceIndex).trim();
                boolean bl = valid = "asc".equals(direction) || "desc".equals(direction);
                if (!valid) break;
                field = field.substring(0, whitespaceIndex).trim();
            }
            try {
                valid = dbman.getFieldInfo(tab, field) != null;
                continue;
            }
            catch (WCMException e) {
                LOG.error((Object)"Failed to test the field exists.", (Throwable)e);
                valid = false;
            }
        }
        return valid;
    }
}

