/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Reports {
    private List m_failedReport = new ArrayList();
    private List m_warnedReport = new ArrayList();
    private List m_sucessedReport = new ArrayList();
    private int[] m_ids;
    private String m_sTitle;
    private ArrayList m_arExtraData;

    public ArrayList getExtraData() {
        return this.m_arExtraData;
    }

    public void setExtraData(ArrayList arEextraData) {
        this.m_arExtraData = arEextraData;
    }

    public Reports(String _sTitle) {
        this.m_sTitle = _sTitle;
    }

    public void add(Reports _reports) {
        this.m_failedReport.addAll(_reports.m_failedReport);
        this.m_warnedReport.addAll(_reports.m_warnedReport);
        this.m_sucessedReport.addAll(_reports.m_sucessedReport);
    }

    public Report addFailedReport(String _sMessage, Throwable _cause) {
        Report report = this.createReport(_sMessage, _cause);
        report.setType(5);
        this.m_failedReport.add(report);
        return report;
    }

    public Report addWarnedReport(String _sMessage, Throwable _cause) {
        Report report = this.createReport(_sMessage, _cause);
        report.setType(4);
        this.m_warnedReport.add(report);
        return report;
    }

    public void addSucessedReport(String _sMessage) {
        this.m_sucessedReport.add(this.createReport(_sMessage, null));
    }

    public List getFailedReporter() {
        return this.m_failedReport;
    }

    public Report getFailedReporterAt(int _nIndex) {
        if (this.m_failedReport.size() <= _nIndex) {
            return null;
        }
        return (Report)this.m_failedReport.get(_nIndex);
    }

    public List getWarnedReporter() {
        return this.m_warnedReport;
    }

    public Report getWarnedReporterAt(int _nIndex) {
        return (Report)this.m_warnedReport.get(_nIndex);
    }

    public List getSucessedReporter() {
        return this.m_sucessedReport;
    }

    public Report getSucessedReporterAt(int _nIndex) {
        if (this.m_sucessedReport.size() <= _nIndex) {
            return null;
        }
        return (Report)this.m_sucessedReport.get(_nIndex);
    }

    public int getReportsNum() {
        return this.m_failedReport.size() + this.m_sucessedReport.size();
    }

    public String getTitle() {
        return this.m_sTitle;
    }

    public void setTitle(String _sTitle) {
        this.m_sTitle = _sTitle;
    }

    private Report createReport(String _sMsg, Throwable _throwable) {
        return new Report(_sMsg, _throwable);
    }

    public void merge(Reports _reports) {
        List sucessed = _reports.getSucessedReporter();
        this.m_sucessedReport.addAll(sucessed);
        List failed = _reports.getFailedReporter();
        this.m_failedReport.addAll(failed);
        List warned = _reports.getWarnedReporter();
        this.m_warnedReport.addAll(warned);
    }

    public String toString() {
        int i;
        String sResult = "[" + this.m_sTitle + "] Reports:";
        int nCount = this.m_sucessedReport.size();
        for (i = 0; i < nCount; ++i) {
            sResult = sResult + "\n" + this.getSucessedReporterAt(i);
        }
        nCount = this.m_warnedReport.size();
        for (i = 0; i < nCount; ++i) {
            sResult = sResult + "\n" + this.getWarnedReporterAt(i);
        }
        nCount = this.m_failedReport.size();
        for (i = 0; i < nCount; ++i) {
            sResult = sResult + "\n" + this.getFailedReporterAt(i);
        }
        return sResult;
    }

    public String toXML() {
        return this.toXML(false);
    }

    public String toXML(boolean _bReturnJSONXML) {
        int i;
        Element root = DocumentHelper.createElement((String)"REPORTS");
        root.addElement("IS" + (_bReturnJSONXML ? "_" : "-") + "SUCCESS").addText(this.m_failedReport.size() <= 0 ? "true" : "false");
        root.addElement("TITLE").addCDATA(this.m_sTitle);
        if (this.getResultIds() != null && this.getResultIds().length > 0) {
            Element element = root.addElement("ObjectIds");
            for (i = 0; i < this.getResultIds().length; ++i) {
                element.addElement("ObjectId").addText(String.valueOf(this.getResultIds()[i]));
            }
        }
        int nCount = this.m_sucessedReport.size();
        for (i = 0; i < nCount; ++i) {
            root.add(this.getSucessedReporterAt(i).toXMLElement(_bReturnJSONXML));
        }
        nCount = this.m_warnedReport.size();
        for (i = 0; i < nCount; ++i) {
            root.add(this.getWarnedReporterAt(i).toXMLElement(_bReturnJSONXML));
        }
        nCount = this.m_failedReport.size();
        for (i = 0; i < nCount; ++i) {
            root.add(this.getFailedReporterAt(i).toXMLElement(_bReturnJSONXML));
        }
        return root.asXML();
    }

    public String toJSONXML() {
        return this.toXML(true);
    }

    public void addReport(Report report) {
        switch (report.getType()) {
            case 3: {
                this.m_sucessedReport.add(report);
                break;
            }
            case 5: {
                this.m_failedReport.add(report);
                break;
            }
            case 4: {
                this.m_warnedReport.add(report);
                break;
            }
        }
    }

    public void setResultIds(int[] _ids) {
        this.m_ids = this.filterZero(_ids);
    }

    private int[] filterZero(int[] _ids) {
        int nZeroCount = 0;
        for (int i = 0; i < _ids.length; ++i) {
            if (_ids[i] != 0) continue;
            ++nZeroCount;
        }
        int[] nonZeroIds = new int[_ids.length - nZeroCount];
        Arrays.sort(_ids);
        for (int i = 0; i < nonZeroIds.length; ++i) {
            nonZeroIds[i] = _ids[i + nZeroCount];
        }
        return nonZeroIds;
    }

    public int[] getResultIds() {
        return this.m_ids != null ? this.m_ids : new int[]{};
    }
}

