/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.trs.cms.content.HTMLContent;
import com.trs.cms.content.ImgRec;
import com.trs.infra.I18NMessage;
import com.trs.infra.WCMServiceHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import java.io.File;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Vector;

public class OpenOfficeConverter {
    private static String OpenOffice_Host = "127.0.0.1";
    private static int OpenOffic_Port = 8100;

    public void convert(File inputFile, File outputFile) throws Exception {
        String sHost = ConfigServer.getServer().getSysConfigValue("OCR_OPENOFFICE_HOST", OpenOffice_Host);
        String sPort = ConfigServer.getServer().getSysConfigValue("OCR_OPENOFFICE_PORT", String.valueOf(OpenOffic_Port));
        SocketOpenOfficeConnection conn = new SocketOpenOfficeConnection(sHost, Integer.parseInt(sPort));
        conn.connect();
        OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter((OpenOfficeConnection)conn);
        converter.convert(inputFile, outputFile);
        conn.disconnect();
    }

    public String convert(String sFilePath, String sFileExt) throws Exception {
        File outputFile = null;
        try {
            if (sFileExt == null) {
                throw new Exception("\u9700\u8981\u8f6c\u5316\u7684\u76ee\u6807\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            FileService inputFile = new FileService(sFilePath);
            if (!inputFile.exists()) {
                throw new Exception("\u9700\u8981\u8f6c\u5316\u7684\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff01");
            }
            FilesMan fileMan = FilesMan.getFilesMan();
            String sTempFileName = fileMan.getNextFileName("ST", sFileExt, null, true);
            String sTempFilePath = sTempFileName.substring(0, sTempFileName.length() - sFileExt.length() - 1) + File.separatorChar;
            CMyFile.makeDir(sTempFilePath, true);
            sTempFileName = sTempFilePath + "document." + sFileExt;
            this.convert(new FileWrapper(inputFile), new FileWrapper(new FileService(sTempFileName)));
            HashMap<String, String> mSrcFile = this.getExtFile(sTempFilePath);
            String encoding = CharsetDetector.detect(sTempFileName);
            String string = OpenOfficeConverter.dowithHtmlContent(CMyFile.readFile(sTempFileName, encoding), mSrcFile);
            return string;
        }
        catch (UnsupportedClassVersionError e) {
            throw new WCMException("\u60a8\u7684JDK\u7248\u672c\u8fc7\u4f4e\uff0c\u4f7f\u7528OpenOffice\u670d\u52a1\u9700\u8981\u5347\u7ea7JDK\u7248\u672c\u52301.5\u53ca\u4ee5\u4e0a\u7248\u672c\uff01", e);
        }
        catch (Exception ex) {
            if (ex instanceof ConnectException) {
                throw new ConnectException("\u8fde\u63a5OpenOffice\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5OpenOffice\u662f\u5426\u5df2\u5b89\u88c5\u6216\u8005\u662f\u5426\u5df2\u7ecf\u542f\u52a8\u8be5\u670d\u52a1\uff01");
            }
            int slashIndex = sFilePath.lastIndexOf(File.separator);
            String fileName = slashIndex < 0 ? sFilePath : sFilePath.substring(slashIndex + 1);
            throw new WCMException("\u5728\u8f6c\u5316\u6587\u4ef6[" + fileName + "]\u5230\u683c\u5f0f[" + sFileExt + "]\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff01", ex);
        }
        finally {
            try {
                if (outputFile != null) {
                    outputFile.delete();
                }
            }
            catch (Exception ex) {
                throw new WCMException("\u4eceOpenOffice\u4e2d\u521b\u5efa\u6587\u6863\uff0c\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u51fa\u73b0\u9519\u8bef\uff01", ex);
            }
        }
    }

    private static String dowithHtmlContent(String _sHTMLContent, HashMap _hmOutFile) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String[] arTagName = HTMLContent.getTagNames();
        String[] arTagSrcName = HTMLContent.getTagSrcs();
        if (arTagName == null) {
            return _sHTMLContent;
        }
        int nTagSize = arTagName.length > arTagSrcName.length ? arTagName.length : arTagSrcName.length;
        HtmlElementFinder imgFinder = null;
        HtmlElement element = null;
        Vector<ImgRec> vImgRecs = new Vector<ImgRec>();
        ImgRec imgRec = null;
        try {
            for (int nTagIndex = 0; nTagIndex < nTagSize; ++nTagIndex) {
                String currTagName = arTagName[nTagIndex];
                String currTagSrcName = arTagSrcName[nTagIndex];
                imgFinder = new HtmlElementFinder(_sHTMLContent);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String sIgnore = element.getAttributeValue("IGNORE");
                    String sImgSrc = element.getAttributeValue(currTagSrcName);
                    if (sIgnore != null && sIgnore.equals("1") || sImgSrc == null || (sImgSrc = sImgSrc.trim()).length() == 0) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    String sFileName = null;
                    imgRec = HTMLContent.getRepeatedImg(sImgSrc, vImgRecs);
                    if (imgRec != null) {
                        element.setAttribute(currTagSrcName, imgRec.pubSrc);
                        element.setAttribute("UploadPic", imgRec.oldSrc);
                        imgFinder.putElement(element);
                        continue;
                    }
                    String sImgFileName = CMyFile.extractFileName(sImgSrc);
                    String sSrcFile = (String)_hmOutFile.get(sImgFileName.toLowerCase());
                    if (sSrcFile == null) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    sFileName = filesMan.copyFile(sSrcFile, "U0", false);
                    imgRec = new ImgRec();
                    imgRec.src = sImgSrc;
                    imgRec.oldSrc = sFileName;
                    imgRec.pubSrc = WCMServiceHelper.getReadImgURL(sFileName, 600);
                    vImgRecs.add(imgRec);
                    element.setAttribute(currTagSrcName, imgRec.pubSrc);
                    element.setAttribute("UploadPic", imgRec.oldSrc);
                    imgFinder.putElement(element);
                }
                _sHTMLContent = imgFinder.getContent();
            }
            return _sHTMLContent;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label2", "\u4fdd\u5b58HTML\u5185\u5bb9\u5931\u8d25!"), ex);
        }
    }

    private HashMap<String, String> getExtFile(String sFilePath) throws CMyException {
        FileWrapper oPath = new FileWrapper(new FileService(sFilePath));
        File[] pFiles = oPath.listFiles();
        HashMap<String, String> hAppendixFiles = new HashMap<String, String>(pFiles.length);
        for (File file : pFiles) {
            if (file.isDirectory()) continue;
            hAppendixFiles.put(file.getName().toLowerCase(), file.getAbsolutePath());
        }
        return hAppendixFiles;
    }

    public String convert2Html(String sFilePath) throws Exception {
        return this.convert(sFilePath, "html");
    }

    public static void main(String[] args) throws Exception {
        OpenOfficeConverter converter = new OpenOfficeConverter();
        System.out.println(converter.convert2Html("D:\\test.doc"));
    }
}

