/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyJAXPXMLParser;
import com.trs.infra.util.CMyXMLElement;
import com.trs.infra.util.CMyXMLHandler;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMyXMLParser {
    private static final String SYSTEM_ID = "http://www.trs.com.cn";

    private static InputSource getInputSource(InputStream _is, String _sEncoding) {
        InputSource inputSource = new InputSource(_is);
        inputSource.setSystemId(SYSTEM_ID);
        String sEncoding = "";
        sEncoding = _sEncoding == null || _sEncoding.trim().length() <= 0 ? "utf-8" : _sEncoding;
        inputSource.setEncoding(sEncoding);
        return inputSource;
    }

    private static void parseXMLFile(InputSource is, DefaultHandler handler, boolean validating) throws Exception {
        try {
            CMyJAXPXMLParser.parseXMLFile(is, handler, validating);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new SAXException("test", e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException:" + e.getMessage());
            throw new Exception(e);
        }
        catch (IOException e) {
            System.out.println("IOException:" + e.getMessage());
            throw new Exception(e);
        }
    }

    private static InputStream getInputStream(String _sValue, String _sEncoding) throws Exception {
        String sEncoding = "";
        sEncoding = _sEncoding == null || _sEncoding.trim().length() <= 0 ? "utf-8" : _sEncoding;
        try {
            byte[] bytes = _sValue.getBytes(sEncoding);
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception ex) {
            throw new Exception("Failed to convert string into utf-8 stream.", ex);
        }
    }

    public static CMyXMLElement strToElement(String _sContent) throws Exception {
        return CMyXMLParser.strToElement(_sContent, null);
    }

    public static CMyXMLElement strToElement(String _sContent, Class _class) throws Exception {
        return CMyXMLParser.strToElement(_sContent, _class, "");
    }

    public static CMyXMLElement strToElement(String _sContent, Class _class, String _sEncoding) throws Exception {
        if (_sContent == null || _sContent.trim().length() <= 0) {
            return null;
        }
        InputStream is = CMyXMLParser.getInputStream(_sContent, _sEncoding);
        return CMyXMLParser.streamToElement(is, _class, _sEncoding);
    }

    public static CMyXMLElement fileToElement(String _sResourceFileName) throws WCMException {
        return CMyXMLParser.fileToElement(_sResourceFileName, null);
    }

    public static CMyXMLElement fileToElement(String _sResourceFileName, Class _class) throws WCMException {
        return CMyXMLParser.filtToElement(_sResourceFileName, _class, "");
    }

    public static CMyXMLElement filtToElement(String _sResourceFileName, Class _class, String _sEncoding) throws WCMException {
        if (_sResourceFileName == null || _sResourceFileName.trim().length() <= 0) {
            return null;
        }
        InputStream is = null;
        try {
            is = new FileService(CMyFile.mapResouceFullPath(_sResourceFileName)).getInputStream();
        }
        catch (Exception e) {
            throw new WCMException(53, I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label1", "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6[") + _sResourceFileName + I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label2", "]\u5931\u8d25\uff01"), e);
        }
        try {
            return CMyXMLParser.streamToElement(is, _class, _sEncoding);
        }
        catch (Exception e) {
            throw new WCMException(150, I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label3", "\u89e3\u6790\u914d\u7f6e\u6587\u4ef6[") + _sResourceFileName + I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label2", "]\u5931\u8d25\uff01"), e);
        }
    }

    public static CMyXMLElement streamToElement(InputStream _isContent, Class _class, String _sEncoding) throws Exception {
        if (_isContent == null) {
            return null;
        }
        CMyXMLHandler myHandler = null;
        myHandler = _class == null ? new CMyXMLHandler() : new CMyXMLHandler(_class);
        InputSource inputSource = CMyXMLParser.getInputSource(_isContent, _sEncoding);
        CMyXMLParser.parseXMLFile(inputSource, myHandler, false);
        return myHandler.getRootConfig();
    }
}

