/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.infra.util.key.MacAddressHelper;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class MyDate
implements License {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static int m_nMaxSiteNum = -1;

    @Override
    public int getMaxSiteNum() {
        if (m_nMaxSiteNum < 0) {
            this.validate();
        }
        return m_nMaxSiteNum;
    }

    @Override
    public int getMaxUserNum() {
        return 0;
    }

    @Override
    public int getPluginCode() {
        return 0;
    }

    @Override
    public String validate() {
        try {
            String sKeyInfo = MyDate.getProductKey();
            if (!MyDate.validateHostMachine(sKeyInfo)) {
                return I18NMessage.get(MyDate.class, "MyDate.label1", "\u673a\u5668\u7801\u4e0d\u4e00\u81f4\uff01\u5f53\u524d\u6ce8\u518c\u7801\u53ea\u80fd\u5728[") + sKeyInfo.substring(0, 12) + I18NMessage.get(MyDate.class, "MyDate.label2", "]\u4e0b\u4f7f\u7528\uff0c\u60a8\u7684\u673a\u5668\u7801\u662f\u3010") + MacAddressHelper.getMyMacAsLong() + "\u3011";
            }
            String sResult = MyDate.validateExpiration(sKeyInfo);
            if (sResult != null) {
                return sResult;
            }
            String temp = sKeyInfo.substring(12, 14);
            int nMaxSiteNum = CKeyUtil.getKeyNum(temp);
            if (nMaxSiteNum == 99) {
                return I18NMessage.get(MyDate.class, "MyDate.label3", "Platform\u7684License");
            }
            m_nMaxSiteNum = nMaxSiteNum;
            return null;
        }
        catch (Throwable e) {
            return "Validate Exception\uff01Date";
        }
    }

    private static String getProductKey() {
        String sKey = MyDate.loadLicenseFile();
        sKey = LicenseUtil.decodeRadix64(sKey);
        return CKeyUtil.DecodeKey(sKey);
    }

    private static String validateExpiration(String _sKeyInfo) {
        String temp = _sKeyInfo.substring(16, _sKeyInfo.length());
        temp = temp.substring(0, 4) + '-' + temp.substring(4, 6) + '-' + temp.substring(6, temp.length());
        CMyDateTime expiration = new CMyDateTime();
        try {
            expiration.setDateWithString(temp, 0);
            if (expiration.dateDiff(3, CMyDateTime.now()) < 0L) {
                String tip = I18NMessage.get(MyDate.class, "MyDate.label5", "\u7cfb\u7edf\u542f\u52a8\u9519\u8bef\uff0c\u7f16\u53f7\u4e3a21039\uff0c\u8bf7\u5c06\u9519\u8bef\u7f16\u53f7\u544a\u8bc9TRS\u76f8\u5173\u9500\u552e\uff0c\u4ed6\u4eec\u5c06\u4e3a\u60a8\u8054\u7cfb\u4eba\u5458\u8fdb\u884c\u670d\u52a1\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRSWCM!");
                return tip;
            }
        }
        catch (CMyException e) {
            return I18NMessage.get(MyDate.class, "MyDate.label6", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!");
        }
        return null;
    }

    private static boolean validateHostMachine(String sKeyInfo) {
        String temp = sKeyInfo.substring(0, 12);
        while (temp.charAt(0) == '0' && temp.length() > 0) {
            temp = temp.substring(1);
        }
        long lMacAddress = Long.parseLong(temp);
        return MacAddressHelper.isValidMac(lMacAddress);
    }

    private static String loadLicenseFile() {
        String sLicenseContent = "";
        Class<MyDate> clazz = MyDate.class;
        String filename = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            sLicenseContent = CMyFile.readFile(filename).trim();
        }
        catch (CMyException e) {
            int nErrNumber = e.getErrNo();
            if (55 == nErrNumber) {
                throw new LicenseException(I18NMessage.get(MyDate.class, "MyDate.label7", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(MyDate.class, "MyDate.label8", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String decodeContent = LicenseUtil.decodeRadix64(sLicenseContent);
        return decodeContent;
    }
}

