/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBConnectionConfigs;
import java.util.HashMap;
import java.util.Map;
import org.aton.container.IClearable;

public class DBConnectionMapper
implements IClearable {
    private Map m_hmDBConnectionConfig = new HashMap(8);
    private String m_sDefaultConnection;
    private boolean m_bLoaded;

    public static DBConnectionMapper getInstance() {
        return (DBConnectionMapper)DreamFactory.createObjectById("DBConnectionMapper");
    }

    private synchronized void loadConnectionConfigColl() {
        if (this.m_bLoaded) {
            return;
        }
        DBConnectionConfigs dbConfigs = (DBConnectionConfigs)XMLConfigServer.getInstance().getConfigObjects(DBConnectionConfigs.class).get(0);
        for (int nConfigIndex = 0; nConfigIndex < dbConfigs.size(); ++nConfigIndex) {
            this.m_hmDBConnectionConfig.put(dbConfigs.get(nConfigIndex).getName(), dbConfigs.get(nConfigIndex));
        }
        this.m_sDefaultConnection = dbConfigs.getDefaultConnection();
        if (!this.m_hmDBConnectionConfig.containsKey(this.m_sDefaultConnection)) {
            throw new RuntimeException(I18NMessage.get(DBConnectionMapper.class, "DBConnectionMapper.label1", "\u9ed8\u8ba4\u7684\u6570\u636e\u5e93\u8fde\u63a5\u5c5e\u6027[") + this.m_sDefaultConnection + I18NMessage.get(DBConnectionMapper.class, "DBConnectionMapper.label2", "]\u5e76\u6ca1\u6709\u8bbe\u7f6e!"));
        }
        this.m_bLoaded = true;
    }

    public DBConnectionConfig getDBConnectionConfigByName(String _dbConnName) {
        if (!this.m_bLoaded) {
            this.loadConnectionConfigColl();
        }
        return (DBConnectionConfig)this.m_hmDBConnectionConfig.get(_dbConnName);
    }

    public DBConnectionConfig getDefaultDBConnectionConfig() {
        if (!this.m_bLoaded) {
            this.loadConnectionConfigColl();
        }
        return (DBConnectionConfig)this.m_hmDBConnectionConfig.get(this.m_sDefaultConnection);
    }

    public void clear() {
        if (this.m_hmDBConnectionConfig != null) {
            this.m_hmDBConnectionConfig.clear();
        }
        this.m_bLoaded = false;
    }
}

