/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.db.QueryFilter;
import com.trs.infra.persistent.InjectSQLHelper;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WCMFilter
implements Cloneable {
    Logger logger = Logger.getLogger(WCMFilter.class);
    private static final String REG_REMOVE_INJECT_SQL = "(?i)([;'\n\r\\-]|[\\s\\/]delete[\\s\\/]|[\\s\\/]update[\\s\\/]|[\\s\\/]insert[\\s\\/]).*";
    private static final String REG_REMOVE_INJECT_WHERE = "(?i)([;\n\r]|[\\s\\/]delete[\\s\\/]|[\\s\\/]update[\\s\\/]|[\\s\\/]insert[\\s\\/]).*";
    protected String from = "";
    protected String where = "";
    protected String order = "";
    protected String select = "";
    protected String group = "";
    protected String orderSelect = "";
    protected int maxRowNumber = NOTLIMITED_OPEN_OPEN_RECORD_COUNT;
    protected int m_nPageSize = 20;
    protected String m_SQL = null;
    protected String m_SQLCountQuery = null;
    public static int DEFAULT_OPEN_RECORD_COUNT = 1000;
    public static int NOTLIMITED_OPEN_OPEN_RECORD_COUNT = 0;
    private List m_listSearchValues = null;
    private String[] m_pSelectFields;
    private boolean m_bForceFirstLoadIds = false;
    protected int m_nCurrPage = -1;
    private boolean m_bContainsPager = true;
    private boolean m_bLoadAll = false;
    private String extSelect;

    public WCMFilter() {
    }

    public WCMFilter(WCMFilter _filter) {
        this.copy(_filter);
    }

    public WCMFilter(String _from, String _where, String _order) {
        this(_from, _where, _order, "");
    }

    public WCMFilter(String _from, String _where, String _order, String _select) {
        this.from = _from;
        this.where = _where;
        this.order = _order;
        this.select = _select;
    }

    public WCMFilter(String _from, String _where, String _order, String _select, String _orderSelect) {
        this.from = _from;
        this.where = _where;
        this.order = _order;
        this.select = _select;
        this.orderSelect = _orderSelect;
    }

    public WCMFilter(String _from, String _where, String _order, String _select, int _nMaxSize) {
        this.from = _from;
        this.where = _where;
        this.order = _order;
        this.select = _select;
        this.maxRowNumber = _nMaxSize;
    }

    public WCMFilter(QueryFilter _queryFilter) {
        if (_queryFilter == null) {
            return;
        }
        this.from = _queryFilter.getFrom();
        this.where = _queryFilter.getWhere();
        this.order = _queryFilter.getOrder();
        this.select = _queryFilter.getSelect();
        this.m_listSearchValues = _queryFilter.getSearchValues();
    }

    public void clear() {
        this.from = "";
        this.where = "";
        this.order = "";
        this.select = "";
        this.maxRowNumber = 0;
        this.group = "";
        this.m_SQL = null;
        if (this.m_listSearchValues != null) {
            this.m_listSearchValues.clear();
            this.m_listSearchValues = null;
        }
    }

    public void copy(WCMFilter _filterSrc) {
        if (_filterSrc == null) {
            this.clear();
        } else {
            this.from = _filterSrc.getFrom();
            this.where = _filterSrc.getWhere();
            this.order = _filterSrc.getOrder();
            this.group = _filterSrc.getGroup();
            this.select = _filterSrc.getSelect();
            this.orderSelect = _filterSrc.getOderSelect();
            this.maxRowNumber = _filterSrc.getMaxRowNumber();
            this.m_listSearchValues = _filterSrc.m_listSearchValues;
            this.m_bForceFirstLoadIds = _filterSrc.m_bForceFirstLoadIds;
            this.m_nPageSize = _filterSrc.m_nPageSize;
            this.m_nCurrPage = _filterSrc.m_nCurrPage;
            this.m_SQL = null;
        }
    }

    public Object clone() {
        return new WCMFilter(this);
    }

    public String getFrom() {
        return this.from == null ? "" : this.from;
    }

    public void setFrom(String _from) {
        this.from = _from;
        this.m_SQL = null;
    }

    public String getWhere() {
        return this.where == null ? "" : this.where;
    }

    public void setWhere(String _where) {
        this.where = _where;
        this.m_SQL = null;
    }

    public String getOrder() {
        return this.order == null ? "" : this.order;
    }

    public void setOrder(String _order) {
        this.order = _order;
        this.m_SQL = null;
    }

    public String getSelect() {
        return this.select == null ? "" : this.select;
    }

    public void setSelect(String _select) {
        this.select = _select;
        this.m_SQL = null;
    }

    public String getOderSelect() {
        return this.orderSelect == null ? "" : this.orderSelect;
    }

    public void setOrderSelect(String _orderSelect) {
        this.orderSelect = _orderSelect;
    }

    public void setGroup(String _group) {
        this.group = _group;
    }

    public String getGroup() {
        return this.group == null ? "" : this.group;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void setMaxRowNumber(int _maxRowNumber) {
        this.maxRowNumber = _maxRowNumber;
    }

    public WCMFilter mergeWith(WCMFilter _filter) {
        if (_filter == null) {
            return this;
        }
        StringTokenizer stFrom = null;
        String sTableName = "";
        String sFilterCon = _filter.getSelect();
        if (sFilterCon.length() > 0) {
            this.select = this.select == null || this.select.length() == 0 ? sFilterCon : sFilterCon + "," + this.select;
        }
        if ((sFilterCon = _filter.getExtSelect()).length() > 0) {
            this.extSelect = this.extSelect == null || this.extSelect.length() == 0 ? sFilterCon : sFilterCon + "," + this.extSelect;
        }
        if ((sFilterCon = _filter.getFrom()).length() > 0) {
            stFrom = new StringTokenizer(sFilterCon.toUpperCase(), ",");
            while (stFrom.hasMoreElements()) {
                sTableName = (String)stFrom.nextElement();
                if (this.from.toUpperCase().indexOf(sTableName.toUpperCase().trim()) >= 0) continue;
                if (this.from.length() > 0) {
                    this.from = this.from + ",";
                }
                this.from = this.from + sTableName;
            }
        }
        if ((sFilterCon = _filter.getWhere()).length() > 0) {
            this.where = this.where != null && this.where.length() > 0 ? "(" + this.where + ") and (" + sFilterCon + ")" : sFilterCon;
        }
        if ((sFilterCon = _filter.getOrder()).length() > 0) {
            this.order = sFilterCon;
        }
        if ((sFilterCon = _filter.getGroup()).length() > 0) {
            this.group = sFilterCon;
        }
        if (_filter.getMaxRowNumber() > 0) {
            this.maxRowNumber = _filter.getMaxRowNumber();
        }
        this.m_nPageSize = _filter.m_nPageSize;
        if (_filter.m_nCurrPage > -1) {
            this.m_nCurrPage = _filter.m_nCurrPage;
        }
        if (_filter.getSearchValues() != null) {
            if (this.m_listSearchValues != null) {
                this.m_listSearchValues.addAll(_filter.getSearchValues());
            } else {
                this.m_listSearchValues = _filter.getSearchValues();
            }
        }
        this.m_bContainsPager = _filter.m_bContainsPager;
        this.m_bLoadAll = _filter.m_bLoadAll;
        this.m_SQL = null;
        return this;
    }

    private final void validInjectSQL() {
        if (InjectSQLHelper.containsInjectSelectSQL(this.select)) {
            this.logger.error((Object)("Inject select[" + this.select + "]\nFilterInfo:" + this), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid select! Inject?!");
        }
        if (InjectSQLHelper.containsInjectFromSQL(this.from)) {
            this.logger.error((Object)("Inject from[" + this.from + "]\nFilterInfo:" + this), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid from! Inject?!");
        }
        if (InjectSQLHelper.containsInjectWhereSQL(this.where)) {
            this.logger.error((Object)("Inject where[" + this.where + "]\nFilterInfo:" + this), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid where! Inject?!");
        }
        if (InjectSQLHelper.containsInjectGroupBySQL(this.group)) {
            this.logger.error((Object)("Inject Group[" + this.group + "]\nFilterInfo:" + this), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid group! Inject?!");
        }
        if (InjectSQLHelper.containsInjectOrderSQL(this.order)) {
            this.logger.error((Object)("Inject order[" + this.order + "]\nFilterInfo:" + this), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid order! Inject?!");
        }
    }

    public String toSQL() {
        return this.toSQL(true);
    }

    private String toSQL(boolean _bCheckInject) {
        String temp;
        if (this.m_SQL != null) {
            return this.m_SQL;
        }
        if (_bCheckInject) {
            this.validInjectSQL();
        }
        this.m_SQL = "select " + CMyString.showNull(this.select, "*") + " from " + this.from;
        if (!CMyString.isEmpty(this.where)) {
            temp = "";
            try {
                temp = this.where.replaceAll(REG_REMOVE_INJECT_WHERE, "");
            }
            catch (Throwable e) {
                this.logger.error((Object)"\u8fc7\u6ee4where\u6761\u4ef6\u4e2d\u7684\u7279\u6b8a\u5b57\u7b26\u51fa\u9519", e);
            }
            if (!CMyString.isEmpty(temp)) {
                this.m_SQL = this.m_SQL + " where " + temp;
            }
        }
        if (this.group != null && this.group.length() > 0) {
            this.m_SQL = this.m_SQL + " group by " + this.group;
        }
        if (!CMyString.isEmpty(this.order) && !CMyString.isEmpty(temp = this.order.replaceAll(REG_REMOVE_INJECT_SQL, ""))) {
            this.m_SQL = this.m_SQL + " order by " + temp;
        }
        return this.m_SQL;
    }

    public String toCountSQL() {
        String temp;
        if (this.m_SQLCountQuery != null) {
            return this.m_SQLCountQuery;
        }
        this.validInjectSQL();
        this.m_SQLCountQuery = "select count(*) from " + this.from;
        if (!CMyString.isEmpty(this.where) && !CMyString.isEmpty(temp = this.where.replaceAll(REG_REMOVE_INJECT_WHERE, ""))) {
            this.m_SQLCountQuery = this.m_SQLCountQuery + " where " + temp;
        }
        if (this.group != null && this.group.length() > 0) {
            this.m_SQLCountQuery = this.m_SQLCountQuery + " group by " + this.group;
        }
        InjectSQLHelper.validSQL(this.m_SQLCountQuery, this);
        return this.m_SQLCountQuery;
    }

    public String toString() {
        String sSQL = this.toSQL(false);
        if (this.m_listSearchValues == null) {
            return sSQL;
        }
        StringBuffer sbParamerts = new StringBuffer(sSQL.length() + 5 + this.m_listSearchValues.size() * 12);
        sbParamerts.append(sSQL);
        int nSize = this.m_listSearchValues.size();
        for (int i = 0; i < nSize; ++i) {
            sbParamerts.append('\n');
            sbParamerts.append("Param#");
            sbParamerts.append(i + 1);
            sbParamerts.append(":");
            sbParamerts.append(this.m_listSearchValues.get(i));
        }
        return sbParamerts.toString();
    }

    public String toCountQueryInfo() {
        String sSQL = this.toCountSQL();
        if (this.m_listSearchValues == null) {
            return sSQL;
        }
        StringBuffer sbParamerts = new StringBuffer(sSQL.length() + 5 + this.m_listSearchValues.size() * 12);
        sbParamerts.append(sSQL);
        int nSize = this.m_listSearchValues.size();
        for (int i = 0; i < nSize; ++i) {
            sbParamerts.append('\n');
            sbParamerts.append("Param#");
            sbParamerts.append(i + 1);
            sbParamerts.append(":");
            sbParamerts.append(this.m_listSearchValues.get(i));
        }
        return sbParamerts.toString();
    }

    public boolean isToGetAll() {
        return this.where == null || this.where.trim().length() == 0;
    }

    public String findSelectField(String _fieldName) {
        int index;
        if (this.select == null || this.select.length() == 0) {
            return null;
        }
        String sToLook = this.select.toUpperCase();
        char[] buff = sToLook.toCharArray();
        String sField = _fieldName.toUpperCase();
        int nFieldLen = _fieldName.length();
        boolean bFound = false;
        int nPos = 0;
        do {
            if ((nPos = sToLook.indexOf(sField, nPos)) < 0) {
                return null;
            }
            if (nPos > 0 && buff[nPos - 1] != ' ' && buff[nPos - 1] != ',' && buff[nPos - 1] != '.') {
                nPos += nFieldLen;
                continue;
            }
            index = nPos + nFieldLen;
            if (index < buff.length) {
                if (buff[index] != ' ' && buff[index] != ',') {
                    nPos = index + 1;
                    continue;
                }
                while (++index < buff.length && buff[index] == ' ') {
                }
                if (buff[index] == 'A') {
                    nPos = index + 2;
                    continue;
                }
            }
            bFound = true;
            break;
        } while (!bFound);
        for (index = nPos - 1; index >= 0; --index) {
            if (buff[index] != ',') continue;
            ++index;
            break;
        }
        if (index < 0) {
            index = 0;
        }
        return this.select.substring(index, nPos + nFieldLen).trim();
    }

    public static void main(String[] args) {
        WCMFilter filter = new WCMFilter("", "", "", "Document.DocId");
        String[] arrSelect = new String[]{"WCMDocument.DocId", "WCMDocument.DocId as DocId2", "WCMDocument.DocId as DocId2, WCMTest.TestId as DocId", "WCMDocument.MyDocId", "distinct WCMDocument.docid,WCMDocument.doctitle,WCMDocument.docstatus,WCMDocument.docchannel,WCMDocument.docauthor,WCMDocument.crtime,WCMDocument.cruser,WCMDocument.RightDefined,WCMDocument.DocType"};
        for (int i = 0; i < arrSelect.length; ++i) {
            filter.setSelect(arrSelect[i]);
            System.out.println("[" + i + "] " + filter.findSelectField("DocId"));
        }
        WCMFilter oldFilter = new WCMFilter("", "", "docid asc", "", 10);
        WCMFilter newFilter = new WCMFilter("", "", "chnlid desc", "*", 20);
        newFilter.mergeWith(oldFilter);
        System.out.println(newFilter.getOrder());
        System.out.println(newFilter.getMaxRowNumber());
        System.out.println(newFilter.getSelect());
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    public void setSearchValues(List searchValues) {
        this.m_listSearchValues = searchValues;
    }

    public void addSearchValues(int _nIndex, int _nSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, new Integer(_nSearchValue));
        } else {
            this.m_listSearchValues.set(_nIndex, new Integer(_nSearchValue));
        }
    }

    public void addSearchValues(int _nSearchValue) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _nSearchValue);
    }

    public void addSearchValues(long _lSearchValue) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValue(nIndex, new Long(_lSearchValue));
    }

    public void addSearchValues(int _nIndex, float _fSearchValue) {
        Float value = new Float(_fSearchValue);
        this.addSearchValue(_nIndex, value);
    }

    private void addSearchValue(int _nIndex, Object _value) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, _value);
        } else {
            this.m_listSearchValues.set(_nIndex, _value);
        }
    }

    public void addSearchValues(float _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public void addSearchValues(int _nIndex, double _dSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, new Double(_dSearchValue));
        } else {
            this.m_listSearchValues.set(_nIndex, new Double(_dSearchValue));
        }
    }

    public void addSearchValues(double _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public void addSearchValues(int _nIndex, String _sSearchValue) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, _sSearchValue);
        } else {
            this.m_listSearchValues.set(_nIndex, _sSearchValue);
        }
    }

    public void addSearchValues(String _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public void addSearchValues(int _nIndex, CMyDateTime _dtTime) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= _nIndex) {
            this.m_listSearchValues.add(_nIndex, _dtTime);
        } else {
            this.m_listSearchValues.set(_nIndex, _dtTime);
        }
    }

    public void addSearchValues(CMyDateTime _value) {
        int nIndex = 0;
        if (this.m_listSearchValues != null) {
            nIndex = this.m_listSearchValues.size();
        }
        this.addSearchValues(nIndex, _value);
    }

    public boolean isForceFirstLoadIds() {
        return this.m_bForceFirstLoadIds;
    }

    public void setForceFirstLoadIds(boolean forceFirstLoadIds) {
        this.m_bForceFirstLoadIds = forceFirstLoadIds;
    }

    public int getPageSize() {
        return this.m_nPageSize;
    }

    public void setPageSize(int pageSize) {
        this.m_nPageSize = pageSize;
    }

    public boolean containsSelectFields(String _sFieldName) {
        int nSelectFieldsCount;
        if (_sFieldName == null || (_sFieldName = _sFieldName.trim()).length() == 0) {
            return false;
        }
        if (this.m_pSelectFields == null) {
            this.makeSelectFields();
        }
        if ((nSelectFieldsCount = this.m_pSelectFields.length) == 0) {
            return true;
        }
        _sFieldName = _sFieldName.toUpperCase();
        for (int i = 0; i < nSelectFieldsCount; ++i) {
            if (!this.m_pSelectFields[i].equals(_sFieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFromMultiTable() {
        if (this.from == null) {
            return false;
        }
        return this.from.indexOf(44) > 0;
    }

    private void makeSelectFields() {
        this.m_pSelectFields = new String[0];
        if (this.select == null || this.select.length() == 0 || this.select.equals("*")) {
            return;
        }
        String[] pTempFields = this.select.split(",");
        for (int i = 0; i < pTempFields.length; ++i) {
            String sField = pTempFields[i].trim();
            int nPos = sField.indexOf(32);
            if (nPos > 0) {
                sField = sField.substring(nPos + 1);
            }
            if ((nPos = sField.indexOf(46)) > 0) {
                sField = sField.substring(nPos + 1);
            }
            pTempFields[i] = sField.toUpperCase();
        }
        this.m_pSelectFields = pTempFields;
    }

    public int getCurrPage() {
        return this.m_nCurrPage;
    }

    public void setCurrPage(int currPage) {
        this.m_nCurrPage = currPage;
    }

    public void setContainsPager(boolean _value) {
        if (_value && this.m_nCurrPage < 0) {
            this.m_nCurrPage = 1;
        }
        if (!_value) {
            this.m_nCurrPage = -1;
        }
        this.m_bContainsPager = _value;
    }

    public boolean isContainsPager() {
        return this.m_bContainsPager;
    }

    public void setLoadAll(boolean _value) {
        this.m_bLoadAll = _value;
    }

    public boolean isLoadAll() {
        return this.m_bLoadAll;
    }

    public String getExtSelect() {
        return this.extSelect == null ? "" : this.extSelect;
    }

    public void setExtSelect(String extSelect) {
        this.extSelect = extSelect;
    }
}

