/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.util.CMyString;
import java.util.Arrays;

public class IdFilterSqlUtil {
    private static final int PREFIX_LEN = 4;
    public static final int THRESHOLD = 500;

    public static final RangeSQL make(String fieldName, String values) {
        int[] ids = CMyString.splitToInt(values, ",");
        StringBuffer buff = new StringBuffer(512);
        if (ids.length <= 500) {
            buff.append(fieldName);
            buff.append(" in (").append(values).append(')');
            return new RangeSQL(buff.toString().intern());
        }
        Arrays.sort(ids);
        int[] range = new int[ids.length];
        int index = 0;
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            int current;
            int left = current = ids[i];
            while (i < len - 1 && (ids[i + 1] == current + 1 || ids[i + 1] == current)) {
                current = ids[++i];
            }
            if (left == current) {
                buff.append(" or ");
                buff.append(fieldName);
                buff.append("=?");
                range[index++] = left;
                continue;
            }
            buff.append(" or ");
            buff.append(fieldName);
            buff.append(">=? and ");
            buff.append(fieldName);
            buff.append("<=?");
            range[index++] = left;
            range[index++] = current;
        }
        int[] v = new int[index];
        System.arraycopy(range, 0, v, 0, index);
        return new RangeSQL("(" + buff.substring(4).intern() + ")", v);
    }

    public static String makeAsString(String fieldName, String values) {
        int[] ids = CMyString.splitToInt(values, ",");
        StringBuffer buff = new StringBuffer(512);
        if (ids.length <= 500) {
            buff.append(fieldName);
            buff.append(" in (").append(values).append(')');
            return buff.toString().intern();
        }
        Arrays.sort(ids);
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            int current;
            int left = current = ids[i];
            while (i < len - 1 && (ids[i + 1] == current + 1 || ids[i + 1] == current)) {
                current = ids[++i];
            }
            if (left == current) {
                buff.append(" or ");
                buff.append(fieldName);
                buff.append("=");
                buff.append(left);
                continue;
            }
            buff.append(" or ");
            buff.append(fieldName);
            buff.append(">=");
            buff.append(left);
            buff.append(" and ");
            buff.append(fieldName);
            buff.append("<=");
            buff.append(current);
        }
        return "(" + buff.substring(4).intern() + ")";
    }

    public static class RangeSQL {
        private String sql;
        private int[] values;

        RangeSQL(String sql) {
            this.sql = sql;
        }

        RangeSQL(String sql, int[] values) {
            this.sql = sql;
            this.values = values;
        }

        public final String getSql() {
            return this.sql;
        }

        public final int[] getValues() {
            return this.values;
        }
    }
}

