/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.domain.ConfigFilesFinder;
import com.trs.infra.config.domain.ConfigHelper;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.config.persistent.ExtensionConfigs;
import com.trs.infra.config.persistent.PluginConfig;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Unmarshaller;

public final class ConfigObjectLoader {
    private static Logger logger = Logger.getLogger(ConfigObjectLoader.class);
    private Map m_hmPluginConfigMap = null;
    private Map m_hmExtensionConfigByClassMap = null;
    private Map m_hmExtensionConfigByIdMap = null;
    private ConfigFilesFinder m_oConfigFileFinder = new ConfigFilesFinder(ConfigHelper.getDomainConfigPaths(), "config.xml");
    private boolean m_bLoaded = false;
    private static final String ENCODING_UTF8 = "UTF-8";

    public ConfigObjectLoader() {
        this.m_hmPluginConfigMap = new HashMap();
        this.m_hmExtensionConfigByClassMap = new HashMap();
        this.m_hmExtensionConfigByIdMap = new HashMap();
    }

    public synchronized void clear() {
        this.m_hmExtensionConfigByClassMap.clear();
        this.m_hmExtensionConfigByIdMap.clear();
        this.m_hmPluginConfigMap.clear();
        this.m_bLoaded = false;
    }

    public synchronized void load() {
        if (this.m_bLoaded) {
            return;
        }
        try {
            ConfigFiles cfgFiles = this.m_oConfigFileFinder.getConfigFiles();
            Mapping map = new Mapping();
            try {
                map.loadMapping(ConfigHelper.getMappingSource(cfgFiles));
            }
            catch (Exception ex) {
                throw new CMyException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label1", "\u88c5\u8f7dCastor\u7684mapping\u6587\u4ef6\u65f6\u51fa\u9519"), ex);
            }
            for (int nConfigFileIndex = 0; nConfigFileIndex < cfgFiles.size(); ++nConfigFileIndex) {
                try {
                    FileStore fPlugin = cfgFiles.get(nConfigFileIndex).getPlugin();
                    PluginConfig cfgObj = ConfigObjectLoader.loadUnmarshallerRoot(fPlugin, map);
                    this.m_hmPluginConfigMap.put(cfgObj.getHostFilePath(), cfgObj);
                    this.loadExtensionByClassMapFromPlugin(cfgObj);
                    this.loadExtensionByIdMapFromPlugin(cfgObj);
                    continue;
                }
                catch (MappingException ex) {
                    throw new CMyException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label2", "\u5206\u6790\u6620\u5c04\u6587\u4ef6\u5931\u8d25! (\u5f53\u524d\u5206\u6790\u7684\u914d\u7f6e\u6587\u4ef6[") + cfgFiles.get(nConfigFileIndex).getPlugin().getPath() + "])", ex);
                }
                catch (Exception ex) {
                    throw new CMyException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label3", "\u5206\u6790\u914d\u7f6e\u6587\u4ef6[config-file=") + cfgFiles.get(nConfigFileIndex).getPlugin().getPath() + I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label4", "]\u5931\u8d25\uff1a") + ex.getLocalizedMessage(), ex);
                }
            }
            this.m_bLoaded = true;
        }
        catch (CMyException e) {
            throw new RuntimeException("Load Config File error!" + CMyException.getStackTraceText(e));
        }
    }

    private void loadExtensionByClassMapFromPlugin(PluginConfig cfgObj) {
        ArrayList listExtentions = cfgObj.getExtensions();
        if (listExtentions.size() == 0) {
            return;
        }
        for (int j = 0; j < listExtentions.size(); ++j) {
            ExtensionConfigs ext = (ExtensionConfigs)listExtentions.get(j);
            String sClassName = ext.getClassName();
            if (this.m_hmExtensionConfigByClassMap.containsKey(sClassName)) {
                this.getConfigElementsByClass(sClassName).addAll(ext.getConfigElements());
                continue;
            }
            ArrayList listConfigElements = new ArrayList();
            listConfigElements.addAll(ext.getConfigElements());
            this.m_hmExtensionConfigByClassMap.put(ext.getClassName(), listConfigElements);
        }
    }

    private void loadExtensionByIdMapFromPlugin(PluginConfig _oPlugin) {
        ArrayList listExtensions = _oPlugin.getExtensions();
        HashMap<String, ExtensionConfigs> hmComparasion = new HashMap<String, ExtensionConfigs>();
        for (int j = 0; j < listExtensions.size(); ++j) {
            ExtensionConfigs oCurrExt = (ExtensionConfigs)listExtensions.get(j);
            String sCurrExtId = oCurrExt.getId();
            if (hmComparasion.containsKey(sCurrExtId)) {
                ExtensionConfigs oComparationExt = (ExtensionConfigs)hmComparasion.get(sCurrExtId);
                if (oCurrExt.getClassName() != null && oCurrExt.getClassName().compareTo(oComparationExt.getClassName()) != 0) {
                    throw new RuntimeException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label5", "\u5b9a\u4e49\u4e86\u4e00\u4e2a[id=") + oCurrExt.getId() + "]\u3001[element-class=" + oCurrExt.getClassName() + I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label6", "]\u914d\u7f6e\u9879\uff0c\u4f46\u8be5\u9879\u7684[id]\u5df2\u7ecf\u88ab\u53e6\u5916\u4e00\u4e2a[elemnt-class=") + oComparationExt.getClassName() + I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label7", "]\u7684\u914d\u7f6e\u6587\u4ef6\u5360\u7528!"));
                }
                ArrayList listConfigElements = (ArrayList)this.m_hmExtensionConfigByIdMap.get(sCurrExtId);
                listConfigElements.addAll(oCurrExt.getConfigElements());
                continue;
            }
            hmComparasion.put(sCurrExtId, oCurrExt);
            ArrayList listConfigElements = new ArrayList();
            listConfigElements.addAll(oCurrExt.getConfigElements());
            this.m_hmExtensionConfigByIdMap.put(sCurrExtId, listConfigElements);
        }
    }

    private ArrayList getConfigElementsByClass(String sClassName) {
        return (ArrayList)this.m_hmExtensionConfigByClassMap.get(sClassName);
    }

    public static PluginConfig loadUnmarshallerRoot(FileStore fCfgXml, Mapping mapping) throws Exception {
        String encoding = ConfigObjectLoader.getDeclaredFileEncoding(fCfgXml.getAbsolutePath());
        Unmarshaller unmarshaller = new Unmarshaller();
        unmarshaller.setMapping(mapping);
        try {
            return ConfigObjectLoader.unmarshall(unmarshaller, fCfgXml, encoding);
        }
        catch (Exception e) {
            return ConfigObjectLoader.unmarshall(unmarshaller, fCfgXml, ENCODING_UTF8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PluginConfig unmarshall(Unmarshaller unmarshaller, FileStore fCfgXml, String encoding) throws Exception {
        PluginConfig result;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(fCfgXml.getInputStream(), encoding);
            result = (PluginConfig)unmarshaller.unmarshal((Reader)reader);
            result.setHostFilePath(fCfgXml.getPath());
            logger.debug((Object)("==== plugin:" + fCfgXml.getAbsolutePath() + ", name:" + result.getName() + ", using encoding:" + encoding));
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDeclaredFileEncoding(String filePath) {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        String encoding = "GBK";
        if (!filePath.endsWith(".xml")) {
            return encoding;
        }
        try {
            fileReader = new FileReader(filePath);
            bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            if (line.startsWith("<?xml") && line.endsWith("?>") && line.toUpperCase().contains(ENCODING_UTF8)) {
                encoding = ENCODING_UTF8;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return encoding;
    }

    private Map getExtensionConfigByClassMap() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return this.m_hmExtensionConfigByClassMap;
    }

    private Map getExtensionConfigByIdMap() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return this.m_hmExtensionConfigByIdMap;
    }

    public List getExtensionalObjects(Class _cElementType) {
        return (ArrayList)this.getExtensionConfigByClassMap().get(_cElementType.getName());
    }

    public List getExtensionalObjects(String _sExtId) {
        return (ArrayList)this.getExtensionConfigByIdMap().get(_sExtId);
    }

    public Map getPluginMap() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return this.m_hmPluginConfigMap;
    }
}

