/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.common.WCMException;
import com.trs.infra.config.persistent.ConfigFile;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ConfigFilesFinder {
    private static Logger s_logger = Logger.getLogger(ConfigFilesFinder.class);
    private ConfigFiles m_oConfigFiles = null;
    private ArrayList m_pConfigFileRootPaths = new ArrayList();
    private String m_sConfigXmlFile;
    private HashMap m_mapAlreadyDoneWithFileNames = new HashMap();

    public ConfigFilesFinder(String _sConfigFileRootPath, String _sConfigXmlFile) {
        this.m_pConfigFileRootPaths.add(_sConfigFileRootPath);
        this.m_sConfigXmlFile = _sConfigXmlFile;
    }

    public ConfigFilesFinder(ArrayList _arConfigFileRootPaths, String _sConfigXmlFile) {
        this.m_pConfigFileRootPaths = _arConfigFileRootPaths;
        this.m_sConfigXmlFile = _sConfigXmlFile;
    }

    public ConfigFiles getConfigFiles() throws WCMException {
        if (this.m_oConfigFiles == null) {
            this.m_oConfigFiles = new ConfigFiles();
            for (int i = 0; i < this.m_pConfigFileRootPaths.size(); ++i) {
                String sConfigFileRootPath = (String)this.m_pConfigFileRootPaths.get(i);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("begin to load config files from[" + sConfigFileRootPath + "]..."));
                }
                FileService fRoot = new FileService(sConfigFileRootPath);
                this.lookupCfgFiles(fRoot);
            }
        } else if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"the files have been loaded.");
        }
        return this.m_oConfigFiles;
    }

    public ConfigFiles refresh() throws CMyException {
        this.m_oConfigFiles = null;
        return this.getConfigFiles();
    }

    private void lookupCfgFiles(FileStore _file) {
        if (_file.isFile()) {
            if (!_file.getName().equals(this.m_sConfigXmlFile)) {
                return;
            }
            String sMapping = CMyFile.extractFilePath(_file.getPath()) + "mapping.xml";
            FileService fMapping = CMyFile.fileExists(sMapping) ? new FileService(sMapping) : null;
            String sAbsolutFileName = _file.getAbsolutePath();
            String sConfigFileNameExcludeProjectPath = this.extractConfigFileNameExcludeProjectPath(sAbsolutFileName);
            ConfigFile configFile = (ConfigFile)this.m_mapAlreadyDoneWithFileNames.get(sConfigFileNameExcludeProjectPath);
            if (configFile != null) {
                if (configFile.getMapping() == null && fMapping != null) {
                    configFile.setMapping(fMapping);
                }
                return;
            }
            configFile = new ConfigFile(_file, fMapping);
            this.m_mapAlreadyDoneWithFileNames.put(sConfigFileNameExcludeProjectPath, configFile);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("load xml file[" + _file.getPath() + "]"));
            }
            this.m_oConfigFiles.add(configFile);
            return;
        }
        FileStore[] dirs = _file.listFiles();
        if (dirs == null) {
            s_logger.warn((Object)("May be a IOException,find an invalid dir:" + _file.getAbsolutePath()));
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            this.lookupCfgFiles(dirs[i]);
        }
    }

    private String extractConfigFileNameExcludeProjectPath(String _sAbsolutFileName) {
        String sConfigFilePathFlag = File.separatorChar + "trsconfig" + File.separatorChar;
        String sConfigFileNameExcludeProjectPath = _sAbsolutFileName;
        int nPos = _sAbsolutFileName.indexOf(sConfigFilePathFlag);
        if (nPos >= 0) {
            sConfigFileNameExcludeProjectPath = _sAbsolutFileName.substring(nPos);
        }
        return sConfigFileNameExcludeProjectPath;
    }

    private ConfigFile getConfigFile(File _fileConfig) {
        String sAbsolutFileName = _fileConfig.getAbsolutePath();
        String sConfigFileNameExcludeProjectPath = this.extractConfigFileNameExcludeProjectPath(sAbsolutFileName);
        ConfigFile confile = (ConfigFile)this.m_mapAlreadyDoneWithFileNames.get(sConfigFileNameExcludeProjectPath);
        if (confile != null) {
            System.out.println("sConfigFileNameExcludeProjectPath\uff1a" + sConfigFileNameExcludeProjectPath);
            System.out.println("sConfigFileNameExcludeProjectPath\uff1a" + this.m_mapAlreadyDoneWithFileNames.get(sConfigFileNameExcludeProjectPath));
            return confile;
        }
        this.m_mapAlreadyDoneWithFileNames.put(sConfigFileNameExcludeProjectPath, sAbsolutFileName);
        return null;
    }
}

