/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.cluster.FileMsgProcessor;
import com.trs.infra.BaseConfig;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLConfig
extends BaseConfig {
    private int nAttrNode;
    private String sFileName;
    private String sFilepath;
    private String sAttrName = "";
    private String sXPath;
    private static int SITE_DISTRIBUTION_MIN_LIMIT = 0;
    private static int SITE_DISTRIBUTION_MAX_LIMIT = 10;

    public XMLConfig(String _sConfig, String _sValue) {
        String[] info = _sConfig.split(":");
        this.sFilepath = info[1];
        this.sFileName = info[2];
        this.sXPath = info[3];
        this.nAttrNode = Integer.parseInt(info[4]);
        if (this.nAttrNode == 1) {
            this.sAttrName = info[5];
        }
        this.sValue = _sValue;
    }

    @Override
    public void save() throws Exception {
        Node node;
        List nodes;
        String sRootPath = ConfigConstants.getConfigRootPath();
        String sFile = CMyString.setStrEndWith(sRootPath + this.sFilepath, File.separatorChar) + this.sFileName;
        String sXml = CMyFile.readFile(sFile, "GB2312");
        Document doc = DocumentHelper.parseText((String)sXml);
        if (this.sXPath.equalsIgnoreCase("/plugin/extension/scheme")) {
            nodes = doc.selectNodes(this.sXPath);
            for (int i = 0; i < nodes.size(); ++i) {
                Element currEl = (Element)nodes.get(i);
                if (!currEl.attribute("event").getValue().equalsIgnoreCase("Publish.WhenTaskFailed")) continue;
                currEl.attribute("enabled").setValue(this.sValue);
            }
        } else if (this.sXPath.equalsIgnoreCase("/plugin/extension/scheme/notification/users")) {
            nodes = doc.selectNodes(this.sXPath);
            for (int i = 0; i < nodes.size(); ++i) {
                Element currEl = (Element)nodes.get(i);
                if (!currEl.getParent().getParent().attribute("event").getValue().equalsIgnoreCase("Publish.WhenTaskFailed")) continue;
                currEl.setText(this.sValue);
            }
        } else if (this.sXPath.equalsIgnoreCase("/plugin/extension/scheme/notification/groups")) {
            nodes = doc.selectNodes(this.sXPath);
            for (int i = 0; i < nodes.size(); ++i) {
                Element currEl = (Element)nodes.get(i);
                if (!currEl.getParent().getParent().attribute("event").getValue().equalsIgnoreCase("Publish.WhenTaskFailed")) continue;
                currEl.setText(this.sValue);
            }
        } else if (this.sXPath.equalsIgnoreCase("/plugin/extension/publish-server/publish-distribution/max-targets-each-folder")) {
            if (SITE_DISTRIBUTION_MIN_LIMIT <= Integer.parseInt(this.sValue) && Integer.parseInt(this.sValue) <= SITE_DISTRIBUTION_MAX_LIMIT) {
                node = doc.selectSingleNode(this.sXPath);
                Element el = (Element)node;
                if (this.nAttrNode == 0) {
                    node.setText(this.sValue);
                } else {
                    el.attribute(this.sAttrName).setValue(this.sValue);
                }
            }
        } else {
            node = doc.selectSingleNode(this.sXPath);
            Element el = (Element)node;
            if (this.sXPath.equalsIgnoreCase("/plugin/extension/smtp-servers/smtp-server") && "name".equalsIgnoreCase(this.sAttrName)) {
                Element parentNode;
                Element parentEl = parentNode = node.getParent();
                parentEl.attribute("default").setValue(this.sValue);
            }
            if (this.nAttrNode == 0) {
                node.setText(this.sValue);
            } else {
                el.attribute(this.sAttrName).setValue(this.sValue);
            }
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(new FileService(sFile).getOutputStream(), "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            doc.write(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (writer != null) {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileMsgProcessor.send(new FileService(sFile).getAbsolutePath());
    }

    public static void main(String[] args) throws CMyException, DocumentException, IOException {
        String sConfig = "xml:com.trs.components.common.publish:config.xml:/plugin/extension/publish-server/labor-resource/each-task-labors-max:0";
        String sValue = "11";
        try {
            new XMLConfig(sConfig, sValue).save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

