/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.BaseConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import java.io.File;

public class DBTableConfig
extends BaseConfig {
    private int nEncrypted;
    private int iType;
    private String sDesc;

    public DBTableConfig(String _sConfig, String _sValue) {
        String[] info = _sConfig.split(":");
        this.sKey = info[1];
        this.sDesc = info[2];
        this.iType = Integer.parseInt(info[3]);
        this.nEncrypted = Integer.parseInt(info[4]);
        this.sValue = _sValue;
    }

    @Override
    public void save() throws WCMException {
        ConfigServer oConfigServer = ConfigServer.getServer();
        Config oConfig = oConfigServer.getSysConfig(this.sKey);
        if (oConfig != null) {
            if (this.sKey.toUpperCase().equalsIgnoreCase("WCMDATA")) {
                String sWCMDATA = oConfigServer.getSysConfigValue(this.sKey, "");
                String[] pathArr = new String[]{"U0", "N0", "P0", "ST", "UT", "TM", "LP", "LV", "W0", "DS", "SF", "BT", "IV"};
                sWCMDATA = sWCMDATA.endsWith(File.separator) ? sWCMDATA : sWCMDATA + File.separator;
                this.sValue = this.sValue.endsWith(File.separator) ? this.sValue : this.sValue + File.separator;
                for (int i = 0; i < pathArr.length; ++i) {
                    String sOldValue;
                    Config currConfig = oConfigServer.getSysConfig(pathArr[i]);
                    if (currConfig == null || !(sOldValue = oConfigServer.getSysConfigValue(pathArr[i], "")).startsWith(sWCMDATA)) continue;
                    String sNewValue = this.sValue + sOldValue.substring(sWCMDATA.length());
                    oConfigServer.updateConfigValue(pathArr[i], sNewValue);
                }
            }
            oConfigServer.updateConfigValue(this.sKey, this.sValue);
            return;
        }
        Config currConfig = Config.createNewInstance();
        currConfig.setNextId();
        currConfig.setConfigKey(this.sKey);
        currConfig.setValue(this.sValue);
        currConfig.setDesc(this.sDesc);
        currConfig.setType(this.iType);
        currConfig.setProperty("encrypted", this.nEncrypted);
        currConfig.save();
    }

    public static void main(String[] args) throws WCMException {
        String sConfig = "db:WCMDATA:WCMDATA\u6839\u76ee\u5f55\u914d\u7f6e:2:0";
        String sValue = "d:\\WCMDATA";
        new DBTableConfig(sConfig, sValue).save();
        System.out.println("\u4fdd\u5b58\u6210\u529f\u4e86....");
    }
}

