/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cache;

import com.trs.infra.cache.Cache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SimpleCache
implements Cache {
    private static Logger logger = Logger.getLogger(SimpleCache.class);
    private static final String STATUS_SUCCESS = "1";
    private static final String STATUS_ERROR = "-1";
    private Map cache = new HashMap();

    @Override
    public Object get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public String set(Object key, Object value) {
        if (key == null) {
            return STATUS_ERROR;
        }
        this.cache.put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("key:" + key + ";\nvlaue:" + value));
        }
        return STATUS_SUCCESS;
    }

    @Override
    public Boolean exists(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void clear(Object key) {
        this.cache.remove(key);
    }

    @Override
    public Long lpush(Object key, Object ... values) {
        LinkedList<Object> list = (LinkedList<Object>)this.cache.get(key);
        if (list == null) {
            list = new LinkedList<Object>();
            this.cache.put(key, list);
        }
        for (int i = 0; i < values.length; ++i) {
            list.addFirst(values[i]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("key:" + key + ";\nvlaue:" + values + ";\nresult:" + values.length));
        }
        return values.length;
    }

    @Override
    public Long rpush(Object key, Object value) {
        LinkedList<Object> list = (LinkedList<Object>)this.cache.get(key);
        if (list == null) {
            list = new LinkedList<Object>();
            this.cache.put(key, list);
        }
        list.addLast(value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("key:" + key + ";\nvlaue:" + value + ";\nresult:" + list.size()));
        }
        return list.size();
    }

    @Override
    public List<Object> lrange(Object key, long start, long end) {
        LinkedList list = (LinkedList)this.cache.get(key);
        if (list == null) {
            return new ArrayList<Object>();
        }
        if (start < 0L) {
            start = 0L;
        }
        if (end < 0L) {
            end = (long)list.size() + end;
        }
        if (end >= (long)list.size()) {
            end = list.size() - 1;
        }
        LinkedList<Object> resultList = new LinkedList<Object>();
        int i = (int)start;
        while ((long)i <= end) {
            resultList.addLast(list.get(i));
            ++i;
        }
        return resultList;
    }

    @Override
    public Long llen(Object key) {
        LinkedList list = (LinkedList)this.cache.get(key);
        if (list == null) {
            return 0L;
        }
        int count = list.size();
        return count;
    }

    @Override
    public Object lindex(Object key, long index) {
        LinkedList list = (LinkedList)this.cache.get(key);
        if (list == null) {
            return null;
        }
        if (index == -1L) {
            return list.getLast();
        }
        if (index < -1L || index >= (long)list.size()) {
            return null;
        }
        return list.get((int)index);
    }

    @Override
    public String lset(Object key, long index, Object value) {
        LinkedList list = (LinkedList)this.cache.get(key);
        if (list == null) {
            return STATUS_ERROR;
        }
        if (index < 0L || index >= (long)list.size()) {
            return STATUS_ERROR;
        }
        list.set((int)index, value);
        return STATUS_SUCCESS;
    }

    @Override
    public Object lpop(Object key) {
        LinkedList list = (LinkedList)this.cache.get(key);
        if (list == null) {
            return null;
        }
        Object obj = list.removeFirst();
        return obj;
    }

    @Override
    public Object rpop(Object key) {
        LinkedList list = (LinkedList)this.cache.get(key);
        if (list == null) {
            return null;
        }
        Object obj = list.removeLast();
        return obj;
    }

    @Override
    public Long lrem(Object key, long count, Object value) {
        LinkedList list;
        if (logger.isDebugEnabled()) {
            StringBuffer sbInfo = new StringBuffer();
            sbInfo.append("\nkey-type:").append(key.getClass());
            sbInfo.append("\nkey-value:").append(key);
            sbInfo.append("\ncount:").append(count);
            sbInfo.append("\nvalue-type:").append(value.getClass());
            sbInfo.append("\nvalue-value:").append(value);
            logger.debug((Object)sbInfo.toString());
        }
        if ((list = (LinkedList)this.cache.get(key)) == null) {
            return 0L;
        }
        if (count > 0L) {
            int i;
            int len;
            for (len = (int)count; len > 0 && (i = list.indexOf(value)) != -1; --len) {
                list.remove(i);
            }
            return count - (long)len;
        }
        if (count < 0L) {
            int i;
            int len;
            for (len = Math.abs((int)count); len > 0 && (i = list.lastIndexOf(value)) != -1; --len) {
                list.remove(i);
            }
            return count - (long)len;
        }
        int i = list.indexOf(value);
        long size = 0L;
        while (i != -1) {
            ++size;
            list.remove(i);
            i = list.indexOf(value);
        }
        return size;
    }

    @Override
    public Long hset(Object key, Object field, Object value) {
        long values = 0L;
        HashMap<Object, Object> map = (HashMap<Object, Object>)this.cache.get(key);
        if (map == null) {
            map = new HashMap<Object, Object>();
            this.cache.put(key, map);
            values = 1L;
        }
        if (!map.containsKey(field)) {
            values = 1L;
        }
        map.put(field, value);
        if (logger.isDebugEnabled()) {
            StringBuffer sbInfo = new StringBuffer();
            sbInfo.append("\nkey-type:").append(key.getClass());
            sbInfo.append("\nkey-value:").append(key);
            sbInfo.append("\nfield-type:").append(field.getClass());
            sbInfo.append("\nfield-value:").append(field);
            sbInfo.append("\nvalue-type:").append(value.getClass());
            sbInfo.append("\nvalue-value:").append(value);
            sbInfo.append("\nresult:").append(values);
            logger.debug((Object)sbInfo.toString());
        }
        return values;
    }

    @Override
    public Object hget(Object key, Object field) {
        Map map = (Map)this.cache.get(key);
        Object result = map == null ? null : (!map.containsKey(field) ? null : map.get(field));
        if (logger.isDebugEnabled()) {
            StringBuffer sbInfo = new StringBuffer();
            sbInfo.append("\nkey-type:").append(key.getClass());
            sbInfo.append("\nkey-value:").append(key);
            sbInfo.append("\nfield-type:").append(field.getClass());
            sbInfo.append("\nfield-value:").append(field);
            sbInfo.append("\nresult:").append((Object)result);
            logger.debug((Object)sbInfo.toString());
        }
        return result;
    }

    @Override
    public String hmset(Object key, Map<Object, Object> hash) {
        this.cache.put(key, hash);
        return STATUS_SUCCESS;
    }

    @Override
    public List<Object> hmget(Object key, Object ... fields) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (!this.exists(key).booleanValue()) {
            for (int i = 0; i < fields.length; ++i) {
                list.add(null);
            }
            return list;
        }
        Map map = (Map)this.cache.get(key);
        for (int i = 0; i < fields.length; ++i) {
            list.add(map.get(fields[i]));
        }
        return list;
    }

    @Override
    public Map hgetAll(Object key) {
        return (Map)this.cache.get(key);
    }

    @Override
    public Set<Object> hkeys(Object key) {
        Map values = (Map)this.cache.get(key);
        if (values == null) {
            return new HashSet<Object>();
        }
        return values.keySet();
    }

    @Override
    public Long hlen(Object key) {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        return ((Map)this.cache.get(key)).entrySet().size();
    }

    @Override
    public Boolean hexists(Object key, Object field) {
        if (!this.exists(key).booleanValue()) {
            return false;
        }
        Map map = (Map)this.cache.get(key);
        return map.containsKey(field);
    }

    @Override
    public Long hdel(Object key, Object ... fields) {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        long count = 0L;
        Map map = (Map)this.cache.get(key);
        for (int i = 0; i < fields.length; ++i) {
            Object val = map.remove(fields[i]);
            if (val == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setMaxSize(long maxSize) {
    }

    @Override
    public Long pexpire(Object key, long milliseconds) {
        return null;
    }

    public void dump() {
        StringBuffer sb = new StringBuffer();
        this.dump0(sb, null, this.cache);
        logger.info((Object)("cache:" + sb.toString()));
    }

    private void dump0(StringBuffer sb, Object key, Object cache) {
        if (key != null) {
            sb.append(key).append("(").append(key.getClass()).append(")").append(":");
        }
        if (cache instanceof Map) {
            Map mapCache = (Map)cache;
            sb.append(mapCache.getClass()).append("{");
            for (Map.Entry entry : mapCache.entrySet()) {
                Object newKey = entry.getKey();
                Object newValue = entry.getValue();
                this.dump0(sb, newKey, newValue);
                sb.append(",");
            }
            sb.append("}");
        } else if (cache instanceof List) {
            List listCache = (List)cache;
            sb.append(cache.getClass()).append("[");
            int length = listCache.size();
            for (int i = 0; i < length; ++i) {
                this.dump0(sb, null, listCache.get(i));
                if (i == length - 1) continue;
                sb.append(",");
            }
            sb.append(key).append("]");
        } else {
            sb.append(cache).append("(").append(cache.getClass()).append(")");
        }
    }
}

