/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cache;

import com.trs.infra.cache.CacheKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheLayer {
    private static final Logger logger = Logger.getLogger(CacheLayer.class);
    private static ThreadLocal<Map> cacheThreadLocal = new ThreadLocal<Map>(){

        @Override
        public Map initialValue() {
            return new HashMap();
        }
    };

    public static void set(CacheKey cacheKey, Object cacheValue) {
        HashMap<CacheKey, Object> cacheMap = (HashMap<CacheKey, Object>)cacheThreadLocal.get().get(cacheKey.getKey());
        if (cacheMap == null) {
            cacheMap = new HashMap<CacheKey, Object>();
            cacheThreadLocal.get().put(cacheKey.getKey(), cacheMap);
        }
        cacheMap.put(cacheKey, cacheValue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("set cacheKey:" + cacheKey + ";cacheValue:" + cacheValue));
        }
    }

    public static Object get(CacheKey cacheKey) {
        Map cacheMap = (Map)cacheThreadLocal.get().get(cacheKey.getKey());
        if (cacheMap == null) {
            return null;
        }
        Object cacheValue = cacheMap.get(cacheKey);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get cacheKey:" + cacheKey + ";cacheValue:" + cacheValue));
        }
        return cacheValue;
    }

    public static void delete(CacheKey cacheKey) {
        Map cacheMap = (Map)cacheThreadLocal.get().get(cacheKey.getKey());
        if (cacheMap == null) {
            return;
        }
        cacheMap.remove(cacheKey);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete cacheKey:" + cacheKey));
        }
    }

    public static void disable(Object key) {
        cacheThreadLocal.get().remove(key);
    }

    public static void clear() {
        cacheThreadLocal.remove();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"clear cache Layer");
        }
    }
}

