/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.testmove;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.exchange.ExchangeHelper;
import com.trs.exchange.MyDBManager;
import com.trs.exchange.testmove.CommonUtil;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TestExchange
extends CommonUtil {
    private static Logger logger = Logger.getLogger(TestExchange.class);
    public static int number = 1;

    public TestExchange(MyDBManager _dbMgr) {
        this.m_oDBMgr = _dbMgr;
        this.filesMan = FilesMan.getFilesMan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMyData(int tableType, String sql) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u8868[ID=" + tableType + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int falg = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                User user = User.createNewInstance();
                ExchangeHelper.readFromRs(user, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                String nickName = user.getNickName();
                if (nickName.contains("(") || nickName.contains(")")) {
                    user.setNickName(nickName.replace('(', '\uff08'));
                    user.setNickName(nickName.replace(')', '\uff09'));
                }
                user.setTrueName(nickName);
                user.setStatus(result.getInt("ENABLESTATE") == 2 ? 30 : -1);
                User beforeUser = User.findByName(user.getName());
                if (beforeUser == null) {
                    user.save();
                    WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
                    filter.addSearchValues(result.getString("PK_ORG"));
                    Groups groups = Groups.openWCMObjs(null, filter);
                    if (groups.isEmpty()) continue;
                    GroupUser gu = GroupUser.createNewInstance();
                    gu.setUserId(user.getId());
                    gu.setGroupId(((Group)groups.getAt(0)).getId());
                    gu.setIsAdministrator(0);
                    gu.save();
                }
                ++falg;
            }
        }
        catch (Exception ex) {
            block9: {
                try {
                    if (falg > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[rownum=" + falg + "]", ex);
                        break block9;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + falg + "]!"));
        this.m_oDLogger.recordEndGroup(falg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMyData(int tableType, String sql, String fath) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u8868[ID=" + tableType + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int nSrcId = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            System.out.println(sql);
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            int falg = 0;
            while (result.next()) {
                Group group = Group.createNewInstance();
                nSrcId = result.getInt("rownum");
                this.m_oDLogger.recordStartData(nSrcId);
                ExchangeHelper.readFromRs(group, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                group.setProperty("TABLETYPE", tableType - 1);
                if (fath.equals("PK_FATHERGROUP")) {
                    this.saveGroup(result, fath, group);
                }
                if (!fath.equals("PK_FATHERORG")) continue;
                this.saveOther(result, fath, group, falg);
            }
        }
        catch (Exception ex) {
            block8: {
                try {
                    if (nSrcId > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[\u6570\u636eID=" + nSrcId + "]", ex);
                        break block8;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + nSrcId + "]!"));
        this.m_oDLogger.recordEndGroup(nSrcId);
    }

    public void saveGroup(ResultSet result, String fath, Group group) throws WCMException, SQLException {
        if (result.getString(fath).equalsIgnoreCase("~")) {
            group.setParent(0);
            group.save();
        } else {
            String father = result.getString(fath);
            WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
            filter.addSearchValues(father);
            Groups groups = Groups.openWCMObjs(null, filter);
            if (groups.isEmpty()) {
                return;
            }
            group.setParent(((Group)groups.getAt(0)).getId());
            group.save();
            group.setGroupOrder(group.getId());
            group.update();
        }
    }

    public void saveOther(ResultSet result, String fath, Group group, int falg) throws SQLException, WCMException {
        String hfath = fath;
        if (result.getString(fath).equalsIgnoreCase("~")) {
            hfath = "PK_ORG";
        }
        String father = result.getString(hfath);
        WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
        filter.addSearchValues(father);
        Groups groups = Groups.openWCMObjs(null, filter);
        if (groups.isEmpty()) {
            logger.info((Object)("*************************rownum\u4e3a" + result.getInt("rownum") + "\u7684\u8fd9\u6761\u6570\u636e\u627e\u4e0d\u5230\u7236\u8282\u70b9******************"));
            return;
        }
        Group pGroup = (Group)groups.getAt(0);
        group.setParent(pGroup.getId());
        WCMFilter filter_1 = new WCMFilter("WCMGROUP", " gname=? and PARENTID=?", "");
        filter_1.addSearchValues(CMyString.filterForSQL(group.getName()));
        filter_1.addSearchValues(pGroup.getId());
        Groups groups_1 = Groups.openWCMObjs(null, filter_1);
        if (!groups_1.isEmpty()) {
            Group deleGroup = (Group)groups_1.getAt(0);
            deleGroup.setProperty("SOURCEID", group.getProperty("SOURCEID"));
            deleGroup.update();
        } else if (falg != 0) {
            group.setGroupOrder(++falg);
            group.save();
        } else {
            group.save();
            falg = group.getId();
            group.setGroupOrder(falg);
            group.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOralceNew(int tableType, String sql) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u8868[ID=" + tableType + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int falg = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            while (result.next()) {
            }
        }
        catch (Exception ex) {
            block7: {
                try {
                    if (falg > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[rownum=" + falg + "]", ex);
                        break block7;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + falg + "]!"));
        this.m_oDLogger.recordEndGroup(falg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSqlServer(int tableType, String sql) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u8868[ID=" + tableType + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int falg = 0;
        User user = ContextHelper.getLoginUser();
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            ArrayList<Group> list = new ArrayList<Group>();
            while (result.next()) {
                System.out.println(result.getInt("GroupOrder"));
                Group group = Group.createNewInstance();
                int groupid = result.getInt("groupid");
                ExchangeHelper.readFromRs(group, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                int parentId = result.getInt("parentid");
                String gName = result.getString("GNAME");
                if (parentId == 0) {
                    group.setProperty("sourceid", String.valueOf(groupid));
                    group.save(user);
                    ++falg;
                    continue;
                }
                WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
                filter.addSearchValues(parentId);
                Groups groups = Groups.openWCMObjs(null, filter);
                if (groups.isEmpty()) {
                    group.setId(groupid);
                    list.add(group);
                    ++falg;
                    continue;
                }
                group.setParent((Group)groups.getAt(0));
                group.setProperty("sourceid", String.valueOf(groupid));
                group.save(user);
                this.m_oDLogger.recordStartData(falg);
                ++falg;
            }
            this.digui(list);
        }
        catch (Exception ex) {
            block9: {
                try {
                    if (falg > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[rownum=" + falg + "]", ex);
                        break block9;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + falg + "]!"));
        this.m_oDLogger.recordEndGroup(falg);
    }

    public void digui(List<Group> list) throws WCMException {
        if (list.size() > 0) {
            Iterator<Group> iterator = list.iterator();
            while (iterator.hasNext()) {
                Group group = iterator.next();
                WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
                filter.addSearchValues(group.getParentId());
                Groups groups = Groups.openWCMObjs(null, filter);
                if (groups.isEmpty()) continue;
                group.setParent((Group)groups.getAt(0));
                group.setProperty("sourceid", String.valueOf(group.getId()));
                group.save();
                iterator.remove();
            }
        }
        if (list.size() > 0) {
            this.digui(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSqlServerUser(int tableType, String sql, int num, int count) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u8868[ID=" + tableType + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int falg = 1;
        int userId = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                if (falg <= (num - 1) * count) {
                    ++falg;
                    continue;
                }
                if (falg > num * count) break;
                User user = User.createNewInstance();
                String userGuid = result.getString("UserGUID");
                int departID = result.getInt("DepartID");
                this.m_oDLogger.recordStartData(falg);
                ExchangeHelper.readFromRs(user, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                user.setProperty("REGTIME", result.getString("REGTIME").substring(0, 10));
                WCMFilter findUser = new WCMFilter("WCMUSER", "USERNAME=?", "");
                findUser.addSearchValues(user.getName());
                Users u = Users.openWCMObjs(null, findUser);
                if (!u.isEmpty()) {
                    if (userId > 0) {
                        GroupUser gu = GroupUser.createNewInstance();
                        WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
                        filter.addSearchValues(departID);
                        Groups groups = Groups.openWCMObjs(null, filter);
                        if (groups.isEmpty()) {
                            ++falg;
                            continue;
                        }
                        Group pp = (Group)groups.getAt(0);
                        gu.setUserId(userId);
                        gu.setGroupId(pp.getId());
                        gu.setIsAdministrator(0);
                        gu.save();
                    }
                    ++falg;
                    continue;
                }
                WCMFilter filter = new WCMFilter("WCMGROUP", "SOURCEID=?", "");
                filter.addSearchValues(departID);
                Groups groups = Groups.openWCMObjs(null, filter);
                if (groups.isEmpty()) {
                    ++falg;
                    continue;
                }
                String nickName = user.getNickName();
                if (nickName.contains("(") || nickName.contains(")")) {
                    String k = nickName.replace('(', '\uff08').replace(')', '\uff09');
                    user.setNickName(k);
                }
                user.setStatus(result.getInt("Active") == 1 ? 30 : -1);
                user.setProperty("REGTIME", result.getString("REGTIME").substring(0, 10));
                user.save();
                userId = user.getId();
                GroupUser gu = GroupUser.createNewInstance();
                gu.setUserId(user.getId());
                gu.setGroupId(((Group)groups.getAt(0)).getId());
                gu.setIsAdministrator(0);
                gu.save();
                ++falg;
            }
        }
        catch (Exception ex) {
            block13: {
                try {
                    if (falg > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[rownum=" + falg + "]", ex);
                        break block13;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + falg + "]!"));
        this.m_oDLogger.recordEndGroup(falg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessSynGroup(int tableType, String sql) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            // empty if block
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int falg = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            HashMap<Integer, Integer> mapNewGroup = new HashMap<Integer, Integer>();
            int index = 0;
            while (result.next()) {
                Group group;
                ++index;
                int sourceId = result.getInt("sourceid");
                int parentId = result.getInt("parentid");
                String sDepName = result.getString("GNAME");
                String sDepDesc = result.getString("GDESC");
                WCMFilter filter = new WCMFilter("WCMGROUP", "sourceid=?", "");
                filter.addSearchValues(sourceId);
                Groups groups = Groups.openWCMObjs(null, filter);
                if (groups == null || groups.size() == 0) {
                    group = Group.createNewInstance();
                    ExchangeHelper.readFromRs(group, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                    group.setParent(0);
                    group.save();
                    System.out.println(index + "\u3010\u65b0\u589e\u3011\u90e8\u95e8\uff1a " + sDepName);
                    mapNewGroup.put(group.getId(), parentId);
                    continue;
                }
                group = (Group)groups.getAt(0);
                group.setName(sDepName);
                group.setDesc(sDepDesc);
                group.save();
                filter = new WCMFilter("WCMGROUP", "sourceid=?", "");
                filter.addSearchValues(parentId);
                groups = Groups.openWCMObjs(null, filter);
                if (groups == null || groups.size() == 0) {
                    System.out.println(index + "\u3010\u5f02\u5e38\u3011\u672a\u627e\u5230\u90e8\u95e8\uff1a " + sDepName + " \u7684\u4e0a\u7ea7\u90e8\u95e8");
                    continue;
                }
                Group parentGroup = (Group)groups.getAt(0);
                group.setParent(parentGroup);
                group.save();
                System.out.println(index + "\u3010\u4fee\u6539\u3011\u90e8\u95e8\uff1a " + sDepName);
            }
            for (Map.Entry groupIdInfo : mapNewGroup.entrySet()) {
                int groupId = (Integer)groupIdInfo.getKey();
                int sourceParentId = (Integer)groupIdInfo.getValue();
                Group currentGroup = Group.findById(groupId);
                WCMFilter filter = new WCMFilter("WCMGROUP", "sourceid=?", "");
                filter.addSearchValues(sourceParentId);
                Groups groups = Groups.openWCMObjs(null, filter);
                if (groups == null || groups.size() <= 0) continue;
                Group prentGroup = (Group)groups.getAt(0);
                currentGroup.setParent(prentGroup);
                currentGroup.save();
            }
        }
        catch (Exception ex) {
            block10: {
                try {
                    if (falg > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[rownum=" + falg + "]", ex);
                        break block10;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + falg + "]!"));
        this.m_oDLogger.recordEndGroup(falg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSqlServerNew(int tableType, String sql) throws Exception {
        this.initLogger(tableType);
        int nLasMigrationId = this.m_oDLogger.readLastInfo();
        if (nLasMigrationId == -1) {
            logger.warn((Object)("\u8868[ID=" + tableType + "]\u5df2\u7ecf\u8fc1\u79fb\u5b8c\uff0c\u91cd\u590d\u6267\u884c\uff01"));
            return;
        }
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        int falg = 0;
        try {
            oConn = this.m_oDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(sql);
            result = oPreStmt.executeQuery();
            ArrayList<Group> list = new ArrayList<Group>();
            while (result.next()) {
                Group group = Group.createNewInstance();
                this.m_oDLogger.recordStartData(falg);
                ExchangeHelper.readFromRs(group, result, result.getMetaData(), this.m_oDBMgr.getDbType());
                list.add(group);
                ++falg;
            }
            this.duguiNew(list, "0,0");
        }
        catch (Exception ex) {
            block7: {
                try {
                    if (falg > 0) {
                        this.error("\u5904\u7406\u8fd9\u6761\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff01[rownum=" + falg + "]", ex);
                        break block7;
                    }
                    this.error("\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u95ee\u9898\uff1f[SQL=" + sql + "]", ex);
                }
                catch (Throwable throwable) {
                    CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
                    throw throwable;
                }
            }
            CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        }
        CommonUtil.finallyClose(result, oPreStmt, oConn, this.m_oDBMgr);
        logger.info((Object)("End Data Migration to [" + falg + "]!"));
        this.m_oDLogger.recordEndGroup(falg);
    }

    public void duguiNew(List<Group> list, String parentss) throws WCMException {
        if (list.size() > 0) {
            String[] parents = parentss.split(";");
            parentss = "";
            if (parents.length > 0) {
                for (String parent : parents) {
                    parentss = parentss + this.insert(list, parent);
                }
                if (!parentss.equals("")) {
                    parentss.substring(0, parentss.lastIndexOf(";"));
                }
            }
        }
        if (list.size() > 0) {
            this.duguiNew(list, parentss);
        }
    }

    public String insert(List<Group> list, String parent) throws WCMException {
        String parentss = "";
        Iterator<Group> iterator = list.iterator();
        String sourceid = parent.split(",")[0];
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (group.getParentId() != Integer.parseInt(sourceid)) continue;
            group.setParent(Integer.parseInt(parent.split(",")[1]));
            group.setId(number++);
            group.save();
            parentss = parentss + group.getPropertyAsString("sourceid") + "," + group.getId() + ";";
            iterator.remove();
        }
        return parentss;
    }
}

