/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.filter;

import com.trs.bbs.plad.upload.RFC1867FormPart;
import com.trs.bbs.plad.upload.RFC1867InputStream;
import com.trs.bbs.plad.upload.RFC1867ServletRequest;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.infra.util.image.CMyImage;
import com.trs.infra.util.store.FileService;
import com.trs.presentation.locale.LocaleServer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AppendixImportor
extends HttpServlet {
    private static final String APP_WECHAT_IP = "APP_WECHAT_IP";
    private static final String PARAM_NAME_ENCODE = "RandomInfo";
    public static final String KEY_PRIVATE_PLATFORM_LOGIN = ConfigConstants.DIR_APPROOT + "public_platform_log.key";
    private static HashMap paramNameMap = new HashMap();
    private static final Logger LOG = Logger.getLogger(AppendixImportor.class);
    private static final long serialVersionUID = 1L;

    private void initParamesMap() {
        paramNameMap.put("DOC_APPENDIX_FILE_SIZE_LIMIT", "filesize");
        paramNameMap.put("DOC_APPENDIX_IMAGE_SIZE_LIMIT", "imagesize");
        paramNameMap.put("DOC_APPENDIX_VIDEO_SIZE_LIMIT", "appendixvideosize");
        paramNameMap.put("DOC_APPENDIX_AUDIO_SIZE_LIMIT", "appendixaudiosize");
        paramNameMap.put("DOCUMENT_IMAGE_SIZE_LIMIT", "imageindocsize");
        paramNameMap.put("DOCUMENT_FLASH_SIZE_LIMIT", "flashsize");
        paramNameMap.put("DOCUMENT_VIDEO_SIZE_LIMIT", "videosize");
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.accessAble(request)) {
            response.setStatus(401);
            return;
        }
        String result = this.saveAppendix(request);
        if (!CMyString.isEmpty(result)) {
            result = CMyFile.extractFileName(result);
        }
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
    }

    public String save(HttpServletRequest request) {
        try {
            String sType = request.getParameter("Type");
            int nChannelId = 0;
            String sysConfigImageSize = null;
            boolean bWebSiteConfig = true;
            if (!CMyString.isEmpty(sType)) {
                String sWebSiteAttName;
                if (paramNameMap.size() == 0) {
                    this.initParamesMap();
                }
                if (!CMyString.isEmpty(sWebSiteAttName = (String)paramNameMap.get(sType.toUpperCase()))) {
                    Channel oChannel;
                    WebSite oWebSite;
                    String sChannelId = request.getParameter("channelId");
                    if (!CMyString.isEmpty(sChannelId)) {
                        nChannelId = Integer.parseInt(sChannelId);
                    }
                    if (nChannelId > 0 && (oWebSite = (oChannel = Channel.findById(nChannelId)).getSite()) != null) {
                        sysConfigImageSize = oWebSite.getAttributeValue(sWebSiteAttName);
                    }
                }
                if (CMyString.isEmpty(sysConfigImageSize)) {
                    sysConfigImageSize = ConfigServer.getServer().getSysConfigValue(sType.toUpperCase(), "0");
                    bWebSiteConfig = false;
                }
            }
            RFC1867InputStream.POST_ENCODING = "utf-8";
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sUploadTempPath = aFilesMan.getPathConfigValue("ST", 0);
            RFC1867ServletRequest oUploadHelper = new RFC1867ServletRequest(request, sUploadTempPath);
            String sTempFile = "";
            String sSaveFile = "";
            String sFileName = "";
            String sFileType = "";
            RFC1867FormPart oFileHelper = oUploadHelper.getFormPart("Filedata");
            if (oFileHelper != null && oFileHelper.getSize() > 0L) {
                String[] result;
                boolean isAllow;
                long nRestrictSize = 0L;
                if (!CMyString.isEmpty(sysConfigImageSize) && (nRestrictSize = Long.parseLong(sysConfigImageSize)) > 0L && oFileHelper.getSize() > nRestrictSize * 1000L) {
                    String sErrorMsg = "";
                    Float fImageSizeToM = Float.valueOf(Float.parseFloat(sysConfigImageSize));
                    fImageSizeToM = Float.valueOf(fImageSizeToM.floatValue() / 1024.0f);
                    fImageSizeToM = Float.valueOf((float)Math.round(fImageSizeToM.floatValue() * 100.0f) / 100.0f);
                    sErrorMsg = bWebSiteConfig ? CMyString.format(LocaleServer.getString("import_appendix.jsp.label.runtimeexception1", "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u5f53\u524d\u7ad9\u70b9\u914d\u7f6e\u7684\u6700\u5927\u503c {0}M\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\uff01"), new String[]{"" + fImageSizeToM}) : CMyString.format(LocaleServer.getString("import_appendix.jsp.label.runtimeexception1", "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u503c {0}M\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\uff01"), new String[]{"" + fImageSizeToM});
                    throw new Exception(sErrorMsg);
                }
                if (this.isForbidFileExt(oFileHelper.getFileName())) {
                    String sErrorMsg = CMyString.format(LocaleServer.getString("file_upload_dowith.jsp.forbid_upload_filetype", "\u7cfb\u7edf\u7981\u6b62\u4e0a\u4f20{0}\u683c\u5f0f\u7684\u6587\u4ef6\uff01"), new String[]{CMyFile.extractFileExt(oFileHelper.getFileName()).toUpperCase()});
                    throw new Exception(sErrorMsg);
                }
                sFileName = oFileHelper.getFileName();
                sFileType = oFileHelper.getFileType();
                sTempFile = aFilesMan.getNextFilePathName("UT", sFileType);
                oFileHelper.writeTo(new FileService(sTempFile).getOutputStream());
                sSaveFile = aFilesMan.getNextFilePathName("U0", sFileType);
                if (",jpg,gif,png,bmp,".indexOf("," + sFileType + ",") > -1 && !(isAllow = "true".equals((result = this.allowImageScale(sTempFile))[0]))) {
                    String sErrorMsg = result[1];
                    throw new Exception(sErrorMsg);
                }
                CMyFile.copyFile(sTempFile, sSaveFile);
            }
            return sSaveFile;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String saveAppendix(HttpServletRequest request) {
        String sEncodeInfo = request.getParameter(PARAM_NAME_ENCODE);
        return this.checkEncodeInfo(KEY_PRIVATE_PLATFORM_LOGIN, sEncodeInfo, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkEncodeInfo(String sPublicKey, String sEncodeInfo, HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sPublicKey:" + sPublicKey));
        }
        String sParam = "";
        String result = "";
        try {
            byte[] buff = sEncodeInfo.getBytes();
            CMySign verify = CMySign.getVerify(sPublicKey);
            buff = verify.decodeRadix64(buff);
            ByteArrayInputStream baoins = new ByteArrayInputStream(buff);
            DataInputStream dataInputStream = new DataInputStream(baoins);
            int userId = dataInputStream.readInt();
            User user = User.findById(userId);
            ContextHelper.initContext(user);
            int nSignLen = dataInputStream.readInt();
            if (!verify.verify(buff, nSignLen)) {
                LOG.error((Object)"Invalid random info: Signature doesn't matched.");
                String string = "";
                return string;
            }
            result = this.save(request);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to check login.", (Throwable)ex);
            String string = "";
            return string;
        }
        finally {
            ContextHelper.clear();
        }
        return result;
    }

    public boolean isForbidFileExt(String fileName) throws WCMException {
        String strExt = CMyFile.extractFileExt(fileName).toUpperCase();
        if (CMyString.isEmpty(strExt)) {
            return false;
        }
        String strSuffixConfig = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG");
        if (CMyString.isEmpty(strSuffixConfig)) {
            return true;
        }
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(strSuffixConfig)) {
            String strAllowExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strAllowExt)) {
                return true;
            }
            strAllowExt = strAllowExt.toUpperCase().trim();
            return ("," + strAllowExt + ",").indexOf("," + strExt + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(strSuffixConfig)) {
            String strForbidExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strForbidExt)) {
                return false;
            }
            strForbidExt = strForbidExt.toUpperCase().trim();
            return ("," + strForbidExt + ",").indexOf("," + strExt + ",") > 0;
        }
        return true;
    }

    public String[] allowImageScale(String sTempFile) {
        try {
            boolean bIsConsiderRate;
            double nSetRate;
            int[] imgSize = CMyImage.getImageSize(sTempFile);
            String sImageScale = ConfigServer.getServer().getSysConfigValue("UPLOAD_IMAGE_LIMTED_SCALE", "0,0,0,0");
            String sDoScaleValidErroMessage = "";
            int nImageWidth = imgSize[0];
            int nImageHeight = imgSize[1];
            boolean bVaildScale = false;
            boolean bVaildRate = false;
            int nSetWidth = Integer.parseInt(sImageScale.split(",")[0]);
            int nSetHeight = Integer.parseInt(sImageScale.split(",")[1]);
            if (nSetWidth > 0 || nSetHeight > 0) {
                bVaildScale = true;
            }
            if ((nSetRate = Double.parseDouble(sImageScale.split(",")[2])) > 0.0) {
                bVaildRate = true;
            }
            boolean bl = bIsConsiderRate = Integer.parseInt(sImageScale.split(",")[3]) > 0;
            if (bVaildRate) {
                if (bIsConsiderRate) {
                    double nImageRate;
                    System.out.println("\u56fe\u7247\u5bbd\u5ea6\uff1a " + nImageWidth + ";\t\u56fe\u7247\u9ad8\u5ea6\uff1a " + nImageHeight);
                    double d = nImageRate = nImageWidth > nImageHeight ? (double)nImageWidth / (double)nImageHeight : (double)nImageHeight / (double)nImageWidth;
                    if (nSetRate < 1.0) {
                        nSetRate = 1.0 / nSetRate;
                    }
                    sDoScaleValidErroMessage = nSetWidth > nSetHeight ? "\u56fe\u7247\u592a\u5bbd\u4e86!\n\n\u4e0d\u7b26\u5408\u7cfb\u7edf\u81ea\u52a8\u914d\u7f6e\u7684(\u6a2a\u5e45)\u6bd4\u4f8b\uff1a[ \u5bbd/\u9ad8 = " + nSetRate + "]" : "\u56fe\u7247\u592a\u9ad8\u4e86!\n\n\u4e0d\u7b26\u5408\u7cfb\u7edf\u81ea\u52a8\u914d\u7f6e\u7684(\u7ad6\u5e45)\u6bd4\u4f8b\uff1a[ \u9ad8/\u5bbd = " + nSetRate + "]";
                    System.out.println("[\u81ea\u52a8]\u56fe\u7247\u6bd4\u4f8b\uff1a " + nImageRate + ";\t\u8bbe\u7f6e\u6bd4\u4f8b\uff1a " + nSetRate);
                    if (nImageRate > nSetRate) {
                        return new String[]{"false", sDoScaleValidErroMessage};
                    }
                } else {
                    double nImageDefaultRate = (double)nImageWidth / (double)nImageHeight;
                    System.out.println("[\u9ed8\u8ba4]\u56fe\u7247\u6bd4\u4f8b\uff1a " + nImageDefaultRate + ";\n\u8bbe\u7f6e\u6bd4\u4f8b\uff1a " + nSetRate);
                    if (nImageDefaultRate > nSetRate) {
                        sDoScaleValidErroMessage = "\u56fe\u7247\u4e0d\u7b26\u5408\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e\u7684\u5bbd\u9ad8\u6bd4\uff1a[ \u5bbd/\u9ad8 = " + nSetRate + "]";
                        return new String[]{"false", sDoScaleValidErroMessage};
                    }
                }
            }
            if ((nImageHeight > nSetHeight || nImageWidth > nSetWidth) && bVaildScale) {
                sDoScaleValidErroMessage = "\u4e0a\u4f20\u56fe\u7247\u5c3a\u5bf8\u89c4\u683c\u8d85\u8fc7\u9650\u5236\uff0c\u652f\u6301\u89c4\u683c\u4e3a[" + nSetWidth + "x" + nSetHeight + "]";
                return new String[]{"false", sDoScaleValidErroMessage};
            }
            return new String[]{"true", ""};
        }
        catch (Exception ex) {
            return new String[]{"true", ""};
        }
    }

    public static Map<String, String> string2Map(String properties) {
        return AppendixImportor.string2Map(properties, "&", "=");
    }

    public static Map<String, String> string2Map(String properties, String outerSplitter, String innerSplitter) {
        if (CMyString.isEmpty(properties)) {
            return null;
        }
        Hashtable<String, String> outProperties = new Hashtable<String, String>();
        StringTokenizer tokenizerOuter = new StringTokenizer(properties, outerSplitter);
        while (tokenizerOuter.hasMoreTokens()) {
            String currProperty = tokenizerOuter.nextToken();
            int index = currProperty.indexOf(innerSplitter);
            if (index == -1) continue;
            String value = currProperty.substring(index + 1, currProperty.length());
            outProperties.put(currProperty.substring(0, index), value);
        }
        return outProperties;
    }

    private boolean accessAble(HttpServletRequest request) {
        String ip = RemoteAddrUtil.getRemoteAddr(request);
        try {
            String sAllowIP = ConfigServer.getServer().getSysConfigValue(APP_WECHAT_IP, "");
            LOG.debug((Object)("APP_WECHAT_IP:" + sAllowIP));
            LOG.debug((Object)("ip->" + ip));
            String[] pAllowIP = sAllowIP.split(",");
            return CMyString.isAllowIP(pAllowIP, ip);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to check the wechat ip.", (Throwable)e);
            return false;
        }
    }
}

