/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WeChatMgr
implements IWeChatMgr {
    private static Logger log = Logger.getLogger(WeChatMgr.class);
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private String mWXAccountChannelTemplate;
    private static final String WX_MANAGER_ROLE_NAME = "\u5fae\u4fe1\u7cfb\u7edf\u7ba1\u7406\u5458";
    private String mThirdAppAuthTemplate;
    private static Map mMetaViewCache = new HashMap();
    private static Map mTemplateCache = new HashMap();
    private RoleMgr oRoleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
    private Role oWXManagerRole;

    @Override
    public void setMetaView(Channel oChannel, String sMetaViewKey) throws WCMException {
        MetaViewField oTitleViewField;
        User oUser = ContextHelper.getLoginUser();
        if (oUser == null) {
            oUser = User.getSystem();
        }
        IMetaViewEmployerMgr oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        if (CMyString.isEmpty(sMetaViewKey)) {
            oMetaViewEmployerMgr.clearEmployer(oUser, oChannel);
            return;
        }
        MetaView oMetaView = this.getMetaView(sMetaViewKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4e3a\u5bf9\u8c61[" + oChannel + "]\u8bbe\u7f6e\u89c6\u56fe[" + oMetaView + "]"));
        }
        oMetaViewEmployerMgr.setEmployer(oUser, oChannel, oMetaView);
        String sMetaSynField = "doccontent=\u5728\u53e6\u5916\u7684\u8868\u4e2d";
        MetaViewField oKeyWordViewField = this.m_oDataDefCacheMgr.getMetaViewField(oMetaView.getId(), "keyword");
        if (oKeyWordViewField != null) {
            sMetaSynField = sMetaSynField + "&dockeywords=${keyword}";
        }
        sMetaSynField = (oTitleViewField = this.m_oDataDefCacheMgr.getMetaViewField(oMetaView.getId(), "title")) != null ? sMetaSynField + "&doctitle=${title}" : sMetaSynField + "&doctitle=\u89c6\u56fe[" + oMetaView.getDesc() + "]\u6570\u636e";
        MetaViewField oMatchTypeViewField = this.m_oDataDefCacheMgr.getMetaViewField(oMetaView.getId(), "matchtype");
        if (oMatchTypeViewField != null) {
            sMetaSynField = sMetaSynField + "&docpeople=${matchtype}";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u680f\u76ee" + oChannel + "\u8bbe\u7f6e\u7684\u540c\u6b65\u89c4\u5219:" + sMetaSynField));
        }
        oChannel.setMetaSynFields(sMetaSynField);
        oChannel.save(oUser);
    }

    @Override
    public void setTemplate(Channel oChannel, String sTemplateKey) throws WCMException {
        Template oTemplate = this.getTemplate(sTemplateKey);
        if (oTemplate == null) {
            JSPRequestProcessor processsor = new JSPRequestProcessor();
            int nWXSiteId = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", ""));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("HostType", 103);
            param.put("HostId", nWXSiteId);
            URL oUrl = this.getClass().getResource("/wechat/template.zip");
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sSaveFile = aFilesMan.getNextFilePathName("U0", "zip");
            FileService file = new FileService(sSaveFile);
            try {
                CMyFile.copyFile(oUrl.getFile(), sSaveFile);
            }
            catch (CMyException e1) {
                throw new WCMException("\u6a21\u7248\u6587\u4ef6\u62f7\u8d1d\u51fa\u9519\uff01", e1);
            }
            param.put("IMPORTFILE", file.getName());
            param.put("SrcFileName", "template.zip");
            processsor.excute("wcm6_template", "importTemplates", param);
        }
        if ((oTemplate = this.getTemplate(sTemplateKey)) == null) {
            throw new WCMException("\u5728\u5fae\u4fe1\u7ad9\u70b9\u4e0a\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u540d\u79f0[" + sTemplateKey + "]\u7684\u6a21\u677f");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4e3a\u5bf9\u8c61[" + oChannel + "]\u8bbe\u7f6e\u6a21\u677f[" + oTemplate + "]"));
        }
        TemplateEmployMgr oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        IPublishFolder oPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(oChannel);
        switch (oTemplate.getType()) {
            case 2: {
                oEmployMgr.setDetailTemplate(oPublishFolder, oTemplate.getId(), false);
                break;
            }
            case 1: {
                oEmployMgr.setDefaultOutline(oPublishFolder, oTemplate.getId());
                break;
            }
        }
    }

    @Override
    public MetaView getMetaView(String sMetaViewName) throws WCMException {
        MetaView oResult = (MetaView)mMetaViewCache.get(sMetaViewName);
        if (!log.isDebugEnabled() && oResult != null) {
            return oResult;
        }
        MetaViews oMetaViews = MetaViews.createNewInstance(User.getSystem());
        WCMFilter oFilter = new WCMFilter("", "VIEWDESC=?", "");
        oFilter.addSearchValues(sMetaViewName);
        oMetaViews.open(oFilter);
        if (!oMetaViews.isEmpty()) {
            oResult = (MetaView)oMetaViews.getAt(0);
            mMetaViewCache.put(sMetaViewName, oResult);
        }
        return oResult;
    }

    @Override
    public Template getTemplate(String sTemplateName) throws WCMException {
        Template oResult = (Template)mTemplateCache.get(sTemplateName);
        if (!log.isDebugEnabled() && oResult != null) {
            return oResult;
        }
        Templates oTemplates = Templates.createNewInstance(User.getSystem());
        WCMFilter oFilter = new WCMFilter("", "TEMPNAME=? and ROOTID=?", "");
        oFilter.addSearchValues(sTemplateName);
        oFilter.addSearchValues(this.getWXSite().getId());
        oTemplates.open(oFilter);
        if (!oTemplates.isEmpty()) {
            oResult = (Template)oTemplates.getAt(0);
            mTemplateCache.put(sTemplateName, oResult);
        }
        return oResult;
    }

    @Override
    public WebSite getWXSite() throws WCMException {
        String sWXSiteId = "";
        try {
            sWXSiteId = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "0");
        }
        catch (WCMException e) {
            log.error((Object)"\u83b7\u53d6\u5fae\u4fe1\u7ad9\u70b9id\u7cfb\u7edf\u914d\u7f6e\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return WebSite.findById(Integer.parseInt(sWXSiteId));
    }

    @Override
    public boolean isWXSite(WebSite oWebSite) {
        if (oWebSite == null) {
            return false;
        }
        String sWXSiteId = "";
        try {
            sWXSiteId = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "0");
        }
        catch (WCMException e) {
            log.error((Object)"\u83b7\u53d6\u5fae\u4fe1\u7ad9\u70b9id\u7cfb\u7edf\u914d\u7f6e\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return sWXSiteId.equalsIgnoreCase(String.valueOf(oWebSite.getId()));
    }

    @Override
    public boolean isWXAccountChannel(Channel oChannel) throws WCMException {
        return oChannel != null && "1".equals(oChannel.getAttributeValue("ISWXCHNL"));
    }

    @Override
    public boolean isWXCustomMenu(Channel oChannel) throws WCMException {
        if (oChannel == null || !this.isWXSite(oChannel.getSite())) {
            return false;
        }
        String sWXChnlDesc = "";
        try {
            sWXChnlDesc = ConfigServer.getServer().getSysConfigValue("WX_MENU_CHANNEL_DESC", "\u81ea\u5b9a\u4e49\u83dc\u5355");
        }
        catch (WCMException e) {
            log.error((Object)"\u83b7\u53d6\u5fae\u4fe1\u81ea\u5b9a\u4e49\u83dc\u5355\u7cfb\u7edf\u914d\u7f6e\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return sWXChnlDesc.equals(oChannel.getDesc());
    }

    @Override
    public boolean isWXHudong(Channel oChannel) throws WCMException {
        if (oChannel == null || !this.isWXSite(oChannel.getSite())) {
            return false;
        }
        String sWXChnlDesc = "";
        try {
            sWXChnlDesc = ConfigServer.getServer().getSysConfigValue("WX_MENU_CHANNEL_DESC", "\u56de\u590d\u8bbe\u7f6e");
        }
        catch (WCMException e) {
            log.error((Object)"\u83b7\u53d6\u5fae\u4fe1\u81ea\u5b9a\u4e49\u83dc\u5355\u7cfb\u7edf\u914d\u7f6e\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return sWXChnlDesc.equals(oChannel.getDesc());
    }

    @Override
    public boolean isWXCustomSubMenu(Channel oChannel) throws WCMException {
        if (oChannel == null || !this.isWXSite(oChannel.getSite())) {
            return false;
        }
        for (Channel oTmpChannel = oChannel.getParent(); oTmpChannel != null; oTmpChannel = oTmpChannel.getParent()) {
            if (!this.isWXCustomMenu(oTmpChannel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Channel getChannelByDescInWXAccountChannelTree(Channel oWXAccountChannel, String sChnlDesc) throws WCMException {
        if (oWXAccountChannel == null) {
            return null;
        }
        if (oWXAccountChannel.getDesc().equals(sChnlDesc)) {
            return oWXAccountChannel;
        }
        List<Channel> oChildren = oWXAccountChannel.getChildren(User.getSystem());
        int length = oChildren.size();
        for (int i = 0; i < length; ++i) {
            Channel oResult = this.getChannelByDescInWXAccountChannelTree(oChildren.get(i), sChnlDesc);
            if (oResult == null) continue;
            return oResult;
        }
        return null;
    }

    private String getWXAccountChannelTemplate() {
        URL oURL;
        if ((log.isDebugEnabled() || this.mWXAccountChannelTemplate == null) && (oURL = this.getClass().getResource("/wechat/WX-Account-Channel-Template.xml")) != null) {
            try {
                this.mWXAccountChannelTemplate = CMyFile.readFile(oURL.getPath(), "utf-8");
            }
            catch (CMyException e) {
                log.error((Object)("\u52a0\u8f7d\u516c\u4f17\u53f7\u914d\u7f6e\u6a21\u677f\u6587\u4ef6[" + oURL.getPath() + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            }
        }
        return this.mWXAccountChannelTemplate;
    }

    private String getThirdAppAuthTemplate() {
        URL oURL;
        if ((this.mThirdAppAuthTemplate == null || log.isDebugEnabled()) && (oURL = this.getClass().getResource("/wechat/WX-ThirdApp-Auth-Detail-Template.xml")) != null) {
            try {
                this.mThirdAppAuthTemplate = CMyFile.readFile(oURL.getPath(), "utf-8");
            }
            catch (CMyException e) {
                log.error((Object)("\u52a0\u8f7d\u516c\u4f17\u53f7\u914d\u7f6e\u6a21\u677f\u6587\u4ef6[" + oURL.getPath() + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            }
        }
        return this.mThirdAppAuthTemplate;
    }

    private String getWXAccountStorePath() throws WCMException {
        String sPath = ConfigServer.getServer().getSysConfigValue("WX_ACCOUNT_STORE_PATH", "");
        if (!CMyFile.fileExists(sPath = sPath.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
            throw new WCMException("\u516c\u4f17\u53f7\u4fe1\u606f\u5b58\u653e\u6839\u8def\u5f84\u4e0d\u5b58\u5728[" + sPath + "]");
        }
        if (!CMyFile.fileExists((sPath = CMyString.setStrEndWith(sPath, File.separatorChar)) + "wx.txt")) {
            throw new WCMException("\u516c\u4f17\u53f7\u76ee\u5f55[" + sPath + "]\u4e0d\u662f\u5408\u6cd5\u76ee\u5f55,\u9700\u8981\u6709\u4e00\u4e2a\u8868\u793a\u6587\u4ef6wx.txt");
        }
        return sPath;
    }

    @Override
    public void unPublishWXAccount(Channel oChannel) throws WCMException {
        if (!this.isWXAccountChannel(oChannel)) {
            throw new WCMException("\u975e\u5fae\u4fe1\u516c\u4f17\u53f7\u680f\u76ee\uff0c\u4e0d\u80fd\u8fdb\u884c\u64a4\u9500\u516c\u4f17\u53f7\u4fe1\u606f\u7684\u64cd\u4f5c");
        }
        String sAccountId = this.getWXID(oChannel);
        String sPath = this.getWXAccountStorePath();
        sPath = CMyString.setStrEndWith(sPath, File.separatorChar) + sAccountId;
        CMyFile.deleteDir(sPath);
    }

    @Override
    public void publishWXAccount(Channel oChannel) throws WCMException {
        TagDocument tagDoc;
        if (!this.isWXAccountChannel(oChannel)) {
            throw new WCMException("\u975e\u5fae\u4fe1\u516c\u4f17\u53f7\u680f\u76ee\uff0c\u4e0d\u80fd\u8fdb\u884c\u53d1\u5e03\u516c\u4f17\u53f7\u4fe1\u606f\u7684\u64cd\u4f5c");
        }
        String sTemplate = this.getWXAccountChannelTemplate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u516c\u4f17\u53f7\u6a21\u677f\u5185\u5bb9\u4e3a:\n" + sTemplate));
        }
        try {
            tagDoc = TagDocumentReader.read(sTemplate);
        }
        catch (Exception e) {
            throw new WCMException("\u89e3\u6790\u6a21\u677f\u6587\u4ef6[" + sTemplate + "]\u5931\u8d25\uff01", e);
        }
        if (tagDoc == null) {
            throw new WCMException("\u89e3\u6790\u6a21\u677f\u6587\u4ef6[" + sTemplate + "]\u5931\u8d25\uff01");
        }
        PublishTaskContext taskContext = new PublishTaskContext(null, null);
        IPublishElement pagePublishElement = PublishElementFactory.makeElementFrom(oChannel);
        PublishPageContext oPageContext = new PublishPageContext(pagePublishElement, taskContext);
        PublishTagContext tagContext = new PublishTagContext(oPageContext);
        String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
        String sResult = results[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n\u516c\u4f17\u53f7\u6a21\u677f\u53d1\u5e03\u540e\u7684\u5185\u5bb9\u4e3a:\n" + sResult));
        }
        String sAccountId = this.getWXID(oChannel);
        String sPath = this.getWXAccountStorePath();
        sPath = CMyString.setStrEndWith(sPath, File.separatorChar) + sAccountId + File.separatorChar + sAccountId + ".xml";
        try {
            CMyFile.writeFile(sPath, sResult, "utf-8");
            log.debug((Object)("\n\u516c\u4f17\u53f7\u4fe1\u606f\u5199\u5165\u6587\u4ef6:\n" + sPath));
        }
        catch (CMyException e) {
            throw new WCMException("\u5199\u6587\u4ef6[" + sPath + "]\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public boolean isThirdApp(MetaViewData viewData) throws WCMException {
        Channel oChannel = viewData.getChannel();
        if (oChannel == null) {
            return false;
        }
        WebSite site = oChannel.getSite();
        if (!this.isWXSite(site)) {
            return false;
        }
        Channel oParentChannel = oChannel.getParent();
        if (oParentChannel == null) {
            return false;
        }
        return "\u5fae\u5e94\u7528\u4e2d\u5fc3".equalsIgnoreCase(oParentChannel.getDesc()) || "\u6211\u7684\u5fae\u5e94\u7528".equalsIgnoreCase(oChannel.getDesc());
    }

    @Override
    public void publishThirdAppAuth(MetaViewData oViewData) throws WCMException {
        TagDocument tagDoc;
        Channel oChannel = oViewData.getChannel();
        if (!"\u6211\u7684\u5fae\u5e94\u7528".equals(oChannel.getDesc())) {
            return;
        }
        String sWXId = this.getWXID(oChannel);
        if (CMyString.isEmpty(sWXId)) {
            return;
        }
        String sTemplate = this.getThirdAppAuthTemplate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7b2c\u4e09\u65b9\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f\u6a21\u677f\u5185\u5bb9\u4e3a:\n" + sTemplate));
        }
        try {
            tagDoc = TagDocumentReader.read(sTemplate);
        }
        catch (Exception e) {
            throw new WCMException("\u89e3\u6790\u6a21\u677f\u6587\u4ef6[" + sTemplate + "]\u5931\u8d25\uff01", e);
        }
        if (tagDoc == null) {
            throw new WCMException("\u89e3\u6790\u6a21\u677f\u6587\u4ef6[" + sTemplate + "]\u5931\u8d25\uff01");
        }
        PublishTaskContext taskContext = new PublishTaskContext(null, null);
        IPublishElement pagePublishElement = PublishElementFactory.makeElementFrom(oViewData);
        PublishPageContext oPageContext = new PublishPageContext(pagePublishElement, taskContext);
        PublishTagContext tagContext = new PublishTagContext(oPageContext);
        String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
        String sResult = results[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n\u7b2c\u4e09\u65b9\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f\u6a21\u677f\u53d1\u5e03\u540e\u7684\u5185\u5bb9\u4e3a:\n" + sResult));
        }
        String sThirdAppId = String.valueOf(oViewData.getId());
        String sPath = this.getWXAccountStorePath();
        sPath = CMyString.setStrEndWith(sPath, File.separatorChar) + sWXId + File.separator + "wx-auth-" + sThirdAppId + ".xml";
        try {
            CMyFile.writeFile(sPath, sResult, "utf-8");
            log.debug((Object)("\n\u7b2c\u4e09\u65b9\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f\u5199\u5165\u6587\u4ef6:\n" + sPath));
        }
        catch (CMyException e) {
            throw new WCMException("\u5199\u6587\u4ef6[" + sPath + "]\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public Channel getWXAccountChannel(String wxID) throws WCMException {
        WebSite wxsite = this.getWXSite();
        Channel channel = Channel.findByName(wxsite.getSiteId(), wxID);
        return channel;
    }

    @Override
    public Channel getWXAccountChannel(Channel oChannel) throws WCMException {
        Channel oTmpChnl;
        for (oTmpChnl = oChannel; oTmpChnl != null; oTmpChnl = oTmpChnl.getParent()) {
            if (!this.isWXAccountChannel(oTmpChnl)) continue;
            return oTmpChnl;
        }
        return oTmpChnl;
    }

    @Override
    public String getWXID(Channel oChannel) throws WCMException {
        Channel oWXChannel = this.getWXAccountChannel(oChannel);
        if (oWXChannel != null) {
            return oWXChannel.getName();
        }
        return null;
    }

    @Override
    public Channels getAllWXAccountCHannels(WebSite wxSite) throws WCMException {
        if (!this.isWXSite(wxSite)) {
            throw new WCMException(wxSite.toString() + "\u4e0d\u662f\u5fae\u4fe1\u7ad9\u70b9");
        }
        WCMFilter oWxAccountChnlsFilter = new WCMFilter("", "attribute like ? ", "");
        oWxAccountChnlsFilter.addSearchValues("%ISWXCHNL=1%");
        Channels oWxAccoutChnls = new ChannelMgr().getChannels(wxSite.getId(), oWxAccountChnlsFilter);
        return oWxAccoutChnls;
    }

    @Override
    public Object isExitWXWebSite() {
        try {
            String wxSiteId = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "");
            if (CMyString.isEmpty(wxSiteId)) {
                return null;
            }
            WebSite webSite = WebSite.findById(Integer.parseInt(wxSiteId.trim()));
            return webSite;
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int importWXWebSite() throws WCMException {
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, String> param = new HashMap<String, String>();
        URL oUrl = this.getClass().getResource("/wechat/weixin_site.zip");
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String sSaveFile = aFilesMan.getNextFilePathName("U0", "zip");
        try {
            CMyFile.copyFile(oUrl.getFile(), sSaveFile);
        }
        catch (CMyException e1) {
            e1.printStackTrace();
        }
        String fileName = CMyFile.extractFileName(sSaveFile);
        param.put("IMPORTFILE", fileName);
        String result = (String)processsor.excute("wcm6_website", "importsites", param);
        int s = result.indexOf("<ObjectId>");
        int e = result.indexOf("</ObjectId>");
        String siteId = result.substring(s + 10, e);
        Config config = ConfigServer.getServer().getSysConfig("WX_SITE_ID");
        if (config == null) {
            config = new Config();
            config.setConfigKey("WX_SITE_ID");
        }
        config.setValue(siteId);
        config.save();
        return Integer.parseInt(siteId);
    }

    @Override
    public boolean isNewsChannel(Channel channel) throws WCMException {
        if (channel == null || !this.isWXSite(channel.getSite())) {
            return false;
        }
        String sWXChnlDesc = "";
        try {
            sWXChnlDesc = ConfigServer.getServer().getSysConfigValue("WX_NEWS_CHANNEL_DESC", "\u56fe\u6587\u6587\u6863");
        }
        catch (WCMException e) {
            log.error((Object)"\u83b7\u53d6\u5fae\u4fe1\u81ea\u5b9a\u4e49\u83dc\u5355\u7cfb\u7edf\u914d\u7f6e\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return sWXChnlDesc.equals(channel.getDesc());
    }

    @Override
    public boolean isWXManager(User user) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        if (this.oWXManagerRole == null) {
            this.oWXManagerRole = this.oRoleMgr.findRoleByName(WX_MANAGER_ROLE_NAME);
            if (this.oWXManagerRole == null) {
                log.error((Object)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7279\u5b9a\u89d2\u8272[\u5fae\u4fe1\u7ba1\u7406\u4eba\u5458]");
                return false;
            }
        }
        return user.getRoles().indexOf(this.oWXManagerRole) >= 0;
    }
}

