/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version.parser;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.version.ObjectVersionMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.CDBText;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ObjectForElementConverter {
    private static Logger s_logger = Logger.getLogger((String)ObjectForElementConverter.class.getName());
    private static final String PATTERN_CDATA = "(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*";

    public static void parseCMSObjToElement(Element _rootElement, CMSObj _CMSObj2, String[] _sExcludeFields) throws WCMException {
        Hashtable<String, Object> m_hProperties = _CMSObj2.getAllProperty();
        if (_sExcludeFields != null) {
            for (int i = 0; i < _sExcludeFields.length; ++i) {
                if (_sExcludeFields[i] == null) continue;
                m_hProperties.remove(_sExcludeFields[i].trim().toUpperCase());
            }
        }
        Enumeration<String> enKeys = m_hProperties.keys();
        String sKey = null;
        Object objValue = null;
        while (enKeys.hasMoreElements()) {
            sKey = enKeys.nextElement();
            objValue = m_hProperties.get(sKey);
            if (objValue == null || objValue instanceof NullValue) continue;
            ObjectForElementConverter.parseObjPropertyToElement(sKey, objValue, _rootElement);
        }
    }

    public static void parseNULLObjPropertyToElement(Element _rootElement, String _sIDFieldName) {
        Element eleItem = _rootElement.addElement(_sIDFieldName);
        eleItem.setText("0");
        eleItem.addAttribute("TYPE", Integer.class.getName());
    }

    private static void parseObjPropertyToElement(String _sKey, Object _objValue, Element _rootElement) {
        Element eleItem = null;
        if (_objValue instanceof String) {
            String strValue = (String)_objValue;
            eleItem = _rootElement.addElement(_sKey);
            if (strValue.matches(PATTERN_CDATA)) {
                eleItem.setText(strValue);
            } else {
                eleItem.addCDATA(strValue);
            }
            eleItem.addAttribute("TYPE", _objValue.getClass().getName());
        } else if (_objValue instanceof CDBText) {
            String textValue = ((CDBText)_objValue).getText();
            if (textValue == null) {
                return;
            }
            eleItem = _rootElement.addElement(_sKey);
            if (textValue.matches(PATTERN_CDATA)) {
                eleItem.setText(textValue);
            } else {
                eleItem.addCDATA(textValue);
            }
            eleItem.addAttribute("TYPE", _objValue.getClass().getName());
        } else if (_objValue instanceof CMyDateTime) {
            CMyDateTime dtTemp = (CMyDateTime)_objValue;
            if (!dtTemp.isNull()) {
                eleItem = _rootElement.addElement(_sKey);
                eleItem.setText(dtTemp.toString());
                eleItem.addAttribute("TYPE", _objValue.getClass().getName());
            }
        } else {
            eleItem = _rootElement.addElement(_sKey);
            eleItem.setText(_objValue.toString());
            eleItem.addAttribute("TYPE", _objValue.getClass().getName());
        }
    }

    public static void parseElementToCMSObj(Element _oEleItem, CMSObj _CMSObj2) throws WCMException {
        if (!_oEleItem.attributeValue("TYPE").equals(_CMSObj2.getClass().getName())) {
            throw new WCMException(2, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label10", "xml\u6570\u636e\u4e0e\u8981\u8f6c\u6362\u7684\u5bf9\u8c61\u4e0d\u7b26"));
        }
        Iterator it = _oEleItem.elementIterator();
        while (it.hasNext()) {
            Element eleItem = (Element)it.next();
            String sKey = eleItem.getName();
            if (sKey.equals("RELATION-OBJECTS")) continue;
            ObjectForElementConverter.parseElementToObjProperty(eleItem, _CMSObj2);
        }
    }

    private static void parseElementToObjProperty(Element _oEleItem, CMSObj _CMSObj2) throws WCMException {
        String sKey = _oEleItem.getName();
        String sType = _oEleItem.attributeValue("TYPE");
        String sValue = _oEleItem.getText();
        boolean bFlag = false;
        if (sType.equals(String.class.getName())) {
            if (_CMSObj2.setProperty(sKey, sValue)) {
                bFlag = true;
            }
        } else if (sType.equals(CDBText.class.getName())) {
            if (_CMSObj2.setTextProperty(sKey, sValue)) {
                bFlag = true;
            }
        } else if (sType.equals(CMyDateTime.class.getName())) {
            CMyDateTime dtTemp = new CMyDateTime();
            try {
                dtTemp.setDateTimeWithString(sValue);
            }
            catch (CMyException e) {
                throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.lable12", "\u7248\u672c\u6062\u590d\u65f6\u5bf9\u8c61\u5b57\u6bb5" + sKey + "\u89e3\u6790\u51fa\u9519"));
            }
            if (_CMSObj2.setProperty(sKey, dtTemp)) {
                bFlag = true;
            }
        } else if (sType.equals(Long.class.getName())) {
            if (_CMSObj2.setProperty(sKey, Long.parseLong(sValue))) {
                bFlag = true;
            }
        } else if (sType.equals(Integer.class.getName())) {
            if (_CMSObj2.setProperty(sKey, Integer.parseInt(sValue))) {
                bFlag = true;
            }
        } else if (_CMSObj2.setProperty(sKey, sValue)) {
            bFlag = true;
        }
        if (!bFlag) {
            throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.lable12", "\u7248\u672c\u6062\u590d\u65f6\u5bf9\u8c61\u5b57\u6bb5" + sKey + "\u89e3\u6790\u51fa\u9519"));
        }
    }

    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

