/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.components.wcm.stat.domain.ChartConstants;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import java.util.List;
import java.util.Vector;

public class ChartStyle {
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 250;
    public static final int DEFAULT_CATEGORY = 0;
    private static final String DEFAULT_CHARTMIMETYPE = "PNG";
    private String m_sChartTitle;
    private int m_nChartCategory;
    private int m_nChartWidth;
    private int m_nChartHeight;
    private String m_sChartFileExt;
    private boolean m_bShowLegend;
    private String m_sXDesc = null;
    private String m_sYDesc = null;
    private String m_sSubtitle = null;
    private static ChartStyle s_oDefaultStyle = null;

    public static ChartStyle getDefaultStyle() {
        if (s_oDefaultStyle == null) {
            s_oDefaultStyle = new ChartStyle();
        }
        return s_oDefaultStyle;
    }

    public static ChartStyle makeChartStyle(String _sTitle, int _nWidth, int _nHeight, String _sChartImgTyp, boolean _bShowLegend) {
        ChartStyle result = new ChartStyle();
        try {
            result.setChartTitle(_sTitle);
            String sMimeType = _sChartImgTyp;
            if (CMyString.isEmpty(sMimeType)) {
                sMimeType = DEFAULT_CHARTMIMETYPE;
            }
            result.setChartFileExt(ChartConstants.getSpecFileExt(sMimeType.toUpperCase()));
            result.setChartWidth(_nWidth);
            result.setChartHeight(_nHeight);
            result.setShowLegend(_bShowLegend);
        }
        catch (Exception ex) {
            throw new RuntimeException(I18NMessage.get(ChartStyle.class, "ChartStyle.label1", "\u8bbe\u7f6e\u56fe\u6807\u6837\u5f0f\u51fa\u9519!"), ex);
        }
        return result;
    }

    public void setXYAxisDescs(String _sXDesc, String _sYDesc) {
        this.m_sXDesc = _sXDesc;
        this.m_sYDesc = _sYDesc;
    }

    public int getChartWidth() {
        return this.m_nChartWidth;
    }

    public int getChartHeight() {
        return this.m_nChartHeight;
    }

    public String getChartTitle() {
        return this.m_sChartTitle;
    }

    public void setChartHeight(int chartHeight) {
        this.m_nChartHeight = chartHeight;
    }

    public void setChartTitle(String chartTitle) {
        this.m_sChartTitle = chartTitle;
    }

    public void setChartWidth(int chartWidth) {
        this.m_nChartWidth = chartWidth;
    }

    public int getChartCategory() {
        return this.m_nChartCategory;
    }

    public void setChartCategory(int chartCategory) {
        this.m_nChartCategory = chartCategory;
    }

    public String getChartFileExt() {
        return this.m_sChartFileExt;
    }

    public void setChartFileExt(String chartFileExt) {
        this.m_sChartFileExt = chartFileExt;
    }

    public boolean isShowLegend() {
        return this.m_bShowLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.m_bShowLegend = showLegend;
    }

    public String getXDesc() {
        return this.m_sXDesc;
    }

    public void setXDesc(String desc) {
        this.m_sXDesc = desc;
    }

    public String getYDesc() {
        return this.m_sYDesc;
    }

    public void setYDesc(String desc) {
        this.m_sYDesc = desc;
    }

    public void setChartSubtitle(String _str) {
        this.m_sSubtitle = _str;
    }

    public List getChartSubtitle() {
        if (CMyString.isEmpty(this.m_sSubtitle)) {
            return null;
        }
        Vector<String> result = new Vector<String>(1);
        result.add(this.m_sSubtitle);
        return result;
    }
}

