/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMDocumentImagesGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.image.CMyImage;
import com.trs.infra.util.store.FileService;
import com.trs.wcm.publish.ImgFileParserHelper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class XWCMContImgTagParser
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(FlowConfigServer.class);
    private final String RETURN_HTML = "html";
    private final String RETURN_URL = "url";
    private final String RETURN_NAME = "name";
    private final String RETURN_DESC = "desc";
    private final String RETURN_WIDTH = "width";
    private final String RETURN_HEIGHT = "height";
    protected static TagBeanInfo m_sTagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_CONTIMG");
            tbi.setDesc("TRS_CONTIMG");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UPLOADONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("URLISABS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"html", "name", "url", "desc", "width", "height"});
            tbai.setDefaultValue("html");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ONLYFROM");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"content", "appendix"});
            tbai.setDefaultValue("content");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIRSTFROM");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"content", "appendix"});
            tbai.setDefaultValue("");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "JS", "XML", "JSON"});
            tbai.setDefaultValue("HTML");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MINWIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MINHEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            m_sTagBeanInfo = tbi;
        }
        return m_sTagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement upperHost = _context.getUpperHost();
        if (upperHost.isFolder()) {
            throw new WCMException("TRS_CONIMG\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u680f\u76ee[" + upperHost.getInfo() + "]\u4e0a\uff01");
        }
        CMSObj obj = this.findObject(_context);
        String sImageFileName = "";
        String sImageDesc = "";
        if (obj == null) {
            CMSObj hostObj = upperHost.getSubstance();
            if (!(hostObj instanceof Document)) {
                throw new WCMException("TRS_CONIMG\u7f6e\u6807\u76ee\u524d\u53ea\u80fd\u7528\u5230\u6587\u6863\u5bf9\u8c61\u6216\u8005\u96c6\u5408\u7f6e\u6807TRS_CONIMGS\u4e0a\uff01");
            }
            int nIndex = _context.getAttribute("INDEX", 1);
            if (nIndex < 1) {
                nIndex = 1;
            }
            obj = this.findDocumentImage(_context, (Document)hostObj, nIndex);
        }
        if (obj == null) {
            return null;
        }
        sImageFileName = (String)obj.getProperty("FileName");
        if (CMyString.isEmpty(sImageFileName)) {
            return null;
        }
        sImageDesc = (String)obj.getProperty("FileDesc");
        String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sImageFileName, 0) + sImageFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            return null;
        }
        logger.debug((Object)("sImageNamePath: " + sSrcFilePathName));
        int nWidth = _context.getAttribute("Width", 0);
        if (ConfigServer.getServer().getSysConfigValue("Image_Convert_Quality", "false").trim().equalsIgnoreCase("true")) {
            String sAbsoluteFieldName = ImgFileParserHelper.makeAbsoluteFilePathAndConvert(sImageFileName, _context);
            sImageFileName = CMyFile.extractFileName(sAbsoluteFieldName);
        } else {
            sImageFileName = FileHelper.makeNewZoomInFileName(sImageFileName, nWidth);
        }
        String sResult = "";
        if (!_context.getAttribute("UPLOADONLY", false)) {
            String sField = _context.getAttribute("Field");
            sResult = sField.equalsIgnoreCase("url") ? XWCMContImgTagParser.makeAppendixURL(_context, (IPublishContent)_context.getUpperHost(), sImageFileName) : (sField.equalsIgnoreCase("name") ? sImageFileName : (sField.equalsIgnoreCase("desc") ? sImageDesc : (sField.equalsIgnoreCase("width") ? this.getImageWidth(_context, sImageFileName) : (sField.equalsIgnoreCase("height") ? this.getImageHeight(_context, sImageFileName) : this.getHtmlResult(_context, sImageFileName)))));
        }
        if (!this.isExistFile(_context, sImageFileName)) {
            this.distributeImageFile(_context, _context.getUpperHost(), sImageFileName);
        }
        sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
        return new String[]{sResult};
    }

    private String getHtmlResult(PublishTagContext _context, String sImageFileName) throws WCMException {
        PublishPathCompass compass = new PublishPathCompass();
        String sRelatImageURL = HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(_context.getUpperHost()), _context.getPageHttpPath()) + sImageFileName;
        String sResult = "";
        String sFullPathFileName = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (filesMan.fileExists(sImageFileName)) {
            sFullPathFileName = filesMan.mapFilePath(sImageFileName, 0) + sImageFileName;
        }
        int nWidth = CMyImage.getImageSize(sFullPathFileName)[0];
        int nHeight = CMyImage.getImageSize(sFullPathFileName)[1];
        sResult = _context.getAttribute("WIDTH") != null && _context.getAttribute("HEIGHT") == null && sFullPathFileName != null && Integer.parseInt(_context.getAttribute("WIDTH")) <= nWidth && Integer.parseInt(_context.getAttribute("WIDTH")) > 0 ? this.renderImage(sRelatImageURL, _context.getAttribute("WIDTH"), String.valueOf(nHeight), _context.getAttribute("EXTRA")) : this.renderImage(sRelatImageURL, _context.getAttribute("WIDTH"), _context.getAttribute("HEIGHT"), _context.getAttribute("EXTRA"));
        if (_context.getAttribute("AUTOLINK", false)) {
            sResult = XWCMContImgTagParser.addAutoLink(sResult, _context);
        }
        return sResult;
    }

    protected CMSObj findObject(PublishTagContext _context) throws WCMException {
        Map hpApp = _context.getExtraAttributes();
        if (hpApp == null) {
            return null;
        }
        CMSObj object = (CMSObj)hpApp.get("IMAGE");
        return object;
    }

    public static String makeAppendixURL(PublishTagContext _context, IPublishContent _apdOwner, String _sFileName) throws WCMException {
        PublishPathCompass compass = _context.getPathCompass();
        String sImageHttpPath = compass.getAbsoluteHttpPath(_apdOwner);
        boolean bUrlIsAbs = _context.getAttribute("UrlIsAbs", false);
        if (bUrlIsAbs) {
            if (_context.isPreview()) {
                sImageHttpPath = compass.getPreviewHttpPath(_apdOwner);
            }
            return sImageHttpPath + _sFileName;
        }
        return HtmlUtil.calRelativePath(sImageHttpPath, _context.getPageHttpPath()) + _sFileName;
    }

    private DefaultObj findDocumentImage(PublishTagContext _context, Document _document, int _nIndex) throws WCMException {
        DefaultObjs images = WCMDocumentImagesGenerator.getDocumentImages(_context, _document, _nIndex);
        DefaultObj image = null;
        if (images.size() == 0) {
            return image;
        }
        if (images.size() >= _nIndex) {
            image = (DefaultObj)images.getAt(_nIndex - 1);
        } else if (images.size() < _nIndex) {
            image = (DefaultObj)images.getAt(0);
        }
        if (image == null) {
            return null;
        }
        return image;
    }

    private String renderImage(String sRelatImageURL, String _sWidth, String _sHeight, String _sExtra) {
        String sResult = "<IMG src=\"";
        sResult = sResult + sRelatImageURL + "\"";
        if (_sWidth != null) {
            sResult = sResult + " width=\"" + _sWidth + "\"";
        }
        if (_sHeight != null) {
            sResult = sResult + " height=\"" + _sHeight + "\"";
        }
        if (_sExtra != null) {
            sResult = sResult + " " + _sExtra;
        }
        sResult = sResult + " />";
        return sResult;
    }

    private boolean isExistFile(PublishTagContext _context, String _sImageName) throws WCMException {
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLocalPath = null;
        sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(_context.getUpperHost(), bPreview), File.separatorChar) + _sImageName;
        return CMyFile.fileExists(sLocalPath);
    }

    private void distributeImageFile(PublishTagContext _context, IPublishElement _upperHost, String _imageFile) throws WCMException {
        String sFileName = _imageFile;
        String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            _context.addWarning(_upperHost.getInfo() + "-\u56fe\u7247", _upperHost.getId(), "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(" + _upperHost.getInfo() + ")\u7684\u56fe\u7247[" + sFileName + "]");
            return;
        }
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(_upperHost, bPreview), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
        try {
            CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
        }
        catch (CMyException e) {
            e.printStackTrace();
            _context.addWarning(_upperHost.getInfo() + "-\u56fe\u7247", _upperHost.getId(), "\u62f7\u8d1d(" + _upperHost.getInfo() + ")\u7684\u56fe\u7247[" + sFileName + "]\u53d1\u751f\u5f02\u5e38:" + CMyException.getStackTraceText(e));
        }
        if (!bPreview) {
            _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _upperHost);
        }
    }

    protected static String addAutoLink(String _sValue, PublishTagContext _context) throws WCMException {
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = "";
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        String sUrl = XWCMContImgTagParser.getAutoLinkUrl(_context);
        if (!_context.getUpperHost().isLink()) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        return HtmlUtil.renderLink(sUrl, sTarget, sAltText, sExtra, _sValue, sLinkText);
    }

    protected static String getAutoLinkUrl(PublishTagContext _context) throws WCMException {
        IPublishElement element = _context.getUpperHost();
        if (element == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!");
        }
        if (!(element instanceof IPublishContent)) {
            throw new WCMException("\u5f53\u524dUpperHost[" + element.getInfo() + "]\u4e0d\u662fIPublishContent\u5bf9\u8c61");
        }
        IPublishContent content = (IPublishContent)element;
        PublishPathCompass compass = _context.getPathCompass();
        switch (content.getBodyType()) {
            case 40: {
                String sFileName = content.getFileName();
                return compass.getAbsoluteHttpPath(_context.getUpperHost()) + sFileName;
            }
            case 30: {
                return content.getLinkUrl();
            }
        }
        return compass.getHttpUrl((IPublishContent)_context.getUpperHost(), 0);
    }

    private String getImageWidth(PublishTagContext _context, String sImageFileName) throws WCMException {
        BufferedImage sourceImage = null;
        FileService imageFile = new FileService(FileHelper.makeAbsoluteFilePathOfImage(sImageFileName, 0));
        if (imageFile == null) {
            return null;
        }
        try {
            sourceImage = ImageIO.read(imageFile.getInputStream());
            return "" + sourceImage.getWidth();
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getImageHeight(PublishTagContext _context, String sImageFileName) throws WCMException {
        BufferedImage sourceImage = null;
        FileService imageFile = new FileService(FileHelper.makeAbsoluteFilePathOfImage(sImageFileName, 0));
        if (imageFile == null) {
            return null;
        }
        try {
            sourceImage = ImageIO.read(imageFile.getInputStream());
            return "" + sourceImage.getHeight();
        }
        catch (IOException e) {
            return null;
        }
    }
}

