/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.IPublishTaskDocumentsCacheMgr;
import com.trs.components.wcm.publish.tagparser.PublishTaskDocumentsCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4ObjsInChannelBase;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WCMTagParserDocuments
extends WCMTagParser4ObjsInChannelBase {
    private static Logger logger = Logger.getLogger(WCMTagParserDocuments.class);
    private static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    private static HashMap FIELDS_MAP;
    protected static TagBeanInfo s_TagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_DOCUMENTS");
            tbi.setDesc("TRS_DOCUMENTS");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDINDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHANNELTYPE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setEnumValue(new String[]{"0", "1", "2"});
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PAGESIZE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ORDER");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOMORE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("BEGINMORE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENDMORE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MORETEXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label1", "\u66f4\u591a\u5185\u5bb9"));
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MOREEXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MORETARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_self");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TRUNCATEDFLAG");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("...");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ALINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SELECT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EnableLimit");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    private static CMyDateTime getPublishStartDate(PublishTagContext _context, IPublishFolder _folder) throws Exception {
        boolean bEnableLimitPublishDate = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("ENABLE_LIMIT_PUBLISH_DATE", "false").trim());
        if (!bEnableLimitPublishDate) {
            return null;
        }
        bEnableLimitPublishDate = _context.getAttribute("EnableLimit", true);
        if (!bEnableLimitPublishDate) {
            return null;
        }
        CMSObj currSubstance = _folder.getSubstance();
        CMyDateTime dtStart = WCMTagParserDocuments.makePublishStartDate(currSubstance);
        if (dtStart != null) {
            return dtStart;
        }
        if (_folder.isRoot()) {
            return null;
        }
        Channel channel = (Channel)currSubstance;
        for (BaseChannel host = channel.getHost(); host != null; host = host.getHost()) {
            dtStart = WCMTagParserDocuments.makePublishStartDate(host);
            if (dtStart != null) {
                return dtStart;
            }
            if (!host.isSite()) continue;
            return null;
        }
        return null;
    }

    private static CMyDateTime makePublishStartDate(CMSObj currSubstance) throws CMyException {
        boolean bEnableLimitPublishDate = "1".equals(currSubstance.getAttributeValue("PublishLimit"));
        if (!bEnableLimitPublishDate) {
            return null;
        }
        String dateTime = currSubstance.getAttributeValue("PubStartDate");
        CMyDateTime dtStart = new CMyDateTime();
        String timeBegin = "$sysdate";
        if (dateTime.trim().toLowerCase().startsWith(timeBegin)) {
            int time = Integer.parseInt(dateTime.split("-")[1].trim());
            CMyDateTime dt = CMyDateTime.now();
            dtStart = dt.dateAdd(3, time * -1);
        } else {
            dtStart.setDateTimeWithString(dateTime);
        }
        return dtStart;
    }

    @Override
    protected IPublishElements getPublishedContentsInCurrentFolder(PublishTagContext _context, WCMFilter _filter) throws WCMException {
        try {
            String sKey;
            boolean isCanPublish;
            IPublishFolder folder = this.getCurrFolder(_context);
            if (folder == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Warn, current folder is null. Check the template and data plz.");
                }
                return null;
            }
            boolean isDocumentUpperHost = _context.getUpperHost() instanceof PublishContentDocumentImpl;
            boolean bl = isCanPublish = folder != null && folder.canDoDetailPageTask();
            if (!isDocumentUpperHost && !isCanPublish) {
                return null;
            }
            WCMFilter filter = this.makeFilterWithTimeLimit(_context, folder, _filter);
            PublishTaskContext taskContext = _context.getPageContext().getTaskContext();
            IPublishTaskDocumentsCacheMgr oPublishTaskDocumentsCacheMgr = (IPublishTaskDocumentsCacheMgr)taskContext.getCachObject(sKey = "IPublishTaskDocumentsCacheMgr");
            if (oPublishTaskDocumentsCacheMgr == null) {
                oPublishTaskDocumentsCacheMgr = new PublishTaskDocumentsCacheMgr();
                oPublishTaskDocumentsCacheMgr = (IPublishTaskDocumentsCacheMgr)taskContext.putInCache(sKey, oPublishTaskDocumentsCacheMgr);
            }
            return this.getPublishedContents(folder, filter, isDocumentUpperHost);
        }
        catch (WCMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label2", "\u83b7\u53d6[") + this.getCurrFolder(_context).getInfo() + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label3", "]\u7684\u6570\u636e\u5931\u8d25!"), e);
        }
    }

    private WCMFilter makeFilterWithTimeLimit(PublishTagContext _context, IPublishFolder _folder, WCMFilter _filter) throws Exception, WCMException {
        CMyDateTime dtStart = WCMTagParserDocuments.getPublishStartDate(_context, _folder);
        WCMFilter filter = null;
        if (dtStart != null) {
            String sDateFieldName = ConfigServer.getServer().getSysConfigValue("PUBLISH_DATE_FIELD", "CrTime");
            String sWhere = "WCMChnlDoc." + sDateFieldName + ">=" + DBManager.getDBManager().getDBType().sqlDate(dtStart.toString());
            filter = new WCMFilter("", sWhere, "");
            filter.mergeWith(_filter);
        } else {
            filter = _filter;
        }
        return filter;
    }

    @Override
    protected IPublishElements getAllContentsInCurrentFolder(PublishTagContext _tagContext, WCMFilter _filter) throws WCMException {
        try {
            IPublishFolder folder = this.getCurrFolder(_tagContext);
            if (folder == null) {
                return null;
            }
            WCMFilter filter = this.makeFilterWithTimeLimit(_tagContext, folder, _filter);
            if (!_tagContext.isPreview() && !folder.canDoDetailPageTask()) {
                return null;
            }
            return this.getPreviewContents(folder, filter);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label2", "\u83b7\u53d6[") + this.getCurrFolder(_tagContext).getInfo() + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label3", "]\u7684\u6570\u636e\u5931\u8d25!"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (sSelectFields == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_tagContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SelectFields:" + sSelectFields));
                    }
                    this.m_tagItem.setExtraAttribute("SELECT", sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = (String)FIELDS_DEFAULT_LIST.get(0);
        int nSize = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(sFieldName) >= 0) continue;
            String sMapField = (String)FIELDS_MAP.get(sFieldName);
            if (sMapField != null) {
                sFieldName = sMapField;
            }
            try {
                if (dbMgr.getFieldInfo("WCMDOCUMENT", sFieldName) == null) {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label4", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label5", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label6", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserDocuments.class, "WCMTagParserDocuments.label7", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        return sSelectFields;
    }

    private int[] getPreviewStatus(IPublishFolder _folder) throws WCMException {
        IPublishFolder root = _folder.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] pCanDoPubStatusIds = m_oCacheMgr.findStatusesCanDoIncreasePub(root.getType(), root.getId());
        String sStatusPreviewInOutline = ConfigServer.getServer().getSysConfigValue("StatusPreviewInOutline", "");
        if (!CMyString.isEmpty(sStatusPreviewInOutline)) {
            String[] sNewStatusIds = sStatusPreviewInOutline.split(",");
            int[] pNewStatusIds = new int[sNewStatusIds.length];
            for (int i = 0; i < sNewStatusIds.length; ++i) {
                try {
                    pNewStatusIds[i] = Integer.parseInt(sNewStatusIds[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    pNewStatusIds = null;
                    break;
                }
            }
            if (pNewStatusIds != null) {
                if (pCanDoPubStatusIds == null) {
                    pCanDoPubStatusIds = pNewStatusIds;
                } else {
                    int[] pTemp = new int[pCanDoPubStatusIds.length + pNewStatusIds.length];
                    System.arraycopy(pCanDoPubStatusIds, 0, pTemp, 0, pCanDoPubStatusIds.length);
                    System.arraycopy(pNewStatusIds, 0, pTemp, pCanDoPubStatusIds.length, pNewStatusIds.length);
                    pCanDoPubStatusIds = pTemp;
                }
            }
        }
        int[] pCanDoPubLogicIds = Status.getStatusCanDoPubInOutline();
        if (pCanDoPubStatusIds == null) {
            return pCanDoPubLogicIds;
        }
        int[] pStatusIds = new int[pCanDoPubStatusIds.length + pCanDoPubLogicIds.length];
        System.arraycopy(pCanDoPubStatusIds, 0, pStatusIds, 0, pCanDoPubStatusIds.length);
        System.arraycopy(pCanDoPubLogicIds, 0, pStatusIds, pCanDoPubStatusIds.length, pCanDoPubLogicIds.length);
        return pStatusIds;
    }

    private int[] getPublishStatus(IPublishFolder _folder, boolean isDocumentUpperHost) throws WCMException {
        if (isDocumentUpperHost) {
            IPublishFolder root = _folder.getRoot();
            IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
            int[] pCanDoPubStatusIds = m_oCacheMgr.findStatusesCanDoIncreasePub(root.getType(), root.getId());
            int[] pCanDoPubLogicIds = Status.getStatusCanDoPubInOutline();
            if (pCanDoPubStatusIds == null) {
                return pCanDoPubLogicIds;
            }
            int[] pStatusIds = new int[pCanDoPubStatusIds.length + pCanDoPubLogicIds.length];
            System.arraycopy(pCanDoPubStatusIds, 0, pStatusIds, 0, pCanDoPubStatusIds.length);
            System.arraycopy(pCanDoPubLogicIds, 0, pStatusIds, pCanDoPubStatusIds.length, pCanDoPubLogicIds.length);
            return pStatusIds;
        }
        return Status.getStatusCanDoPubInOutline();
    }

    private IPublishElements getPreviewContents(IPublishFolder _folder, WCMFilter _filter) throws WCMException {
        return this.getContents(_folder, this.getPreviewStatus(_folder), _filter);
    }

    private IPublishElements getPublishedContents(IPublishFolder _folder, WCMFilter _filter, boolean isDocumentUpperHost) throws WCMException {
        return this.getContents(_folder, this.getPublishStatus(_folder, false), _filter);
    }

    private IPublishElements getContents(IPublishFolder _folder, int[] _pStatuses, WCMFilter _filter) throws WCMException {
        if (_pStatuses == null || _pStatuses.length <= 0) {
            return null;
        }
        DebugTimer aTimer = new DebugTimer();
        aTimer.start();
        WCMFilter filter = new WCMFilter("", "", "");
        filter.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String sWhere = "WCMCHNLDOC.DOCSTATUS in(?";
        filter.addSearchValues(0, _pStatuses[0]);
        int nSize = _pStatuses.length;
        for (int i = 1; i < nSize; ++i) {
            sWhere = sWhere + ",?";
            filter.addSearchValues(i, _pStatuses[i]);
        }
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents: Where=" + sWhere));
        }
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        Channel oChannel = (Channel)_folder.getSubstance();
        Documents docs = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            docs = DocumentsGetHelper.getDocuments(oChannel, filter);
        } else {
            DocumentMgr mgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            docs = mgr.getDocuments(oChannel, filter);
        }
        aTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents use [" + aTimer.getTime() + "]ms\nSQL:" + docs.getFilter().toSQL()));
        }
        if (docs == null || docs.isEmpty()) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(docs);
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("DOCKEYWORDS");
        FIELDS_DEFAULT_LIST.add("DOCRELWORDS");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_DEFAULT_LIST.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST.add("DOCPUBTIME");
        FIELDS_DEFAULT_LIST.add("DOCSOURCENAME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_TagBeanInfo = null;
    }

    protected class TBI
    extends TagBeanInfo {
        protected TBI() {
        }

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            TagBeanInfoHelper.checkChannelName(_folder, _tagItem, _sbResult);
        }
    }
}

