/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserContentBase;
import com.trs.components.common.publish.parser.HTMLContentParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Source;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WCMTagParserDocument
extends TagParserContentBase {
    private static Logger s_logger = Logger.getLogger(WCMTagParserDocument.class);
    private static final int TITLE = 1;
    private static final int HTMLCONTENT = 2;
    private static final int PUBTIME = 3;
    private static final int SOURCE = 4;
    private static final int SECURITY = 5;
    private static final int DOCPUBHTMLCON = 6;
    private static final int CONTENT = 7;
    private static final int HOMENAME = 8;
    private static final int TRUEUSER = 9;
    private static final int DOCPEOPLE = 10;
    private static final int CRUSER = 11;
    private static final int HOME_SITE = 12;
    private static final int HOME_SITENAME = 13;
    private static final int DOCABSTRACT = 14;
    private static final int ENTITYURL = 15;
    private static final int DOC_FIRST_PUBTIME = 16;
    private static final int RECFILE_URL = 17;
    private static final int DOCFILESIZE = 18;
    private static final int DOCKEYWORDS = 19;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_DOCUMENT");
            tbi.setDesc("TRS_DOCUMENT");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("DOCTITLE");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATEFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("yyyy-MM-dd HH:mm:ss");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "JS", "XML", "INNERTEXT", "JSON"});
            tbai.setDefaultValue("HTML");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOCOLOR");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_self");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKALT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKALTTEXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKTEXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TRUNCATEDFLAG");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("...");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("VALUE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CLASSNAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NICKCRUSER");
            tbai.setDesc(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label1", "\u521b\u5efa\u8005\u7684\u6635\u79f0"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CRUSERID");
            tbai.setDesc("\u521b\u5efa\u8005\u7684ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CODEFILTERED");
            tbai.setDesc(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label2", "\u8fc7\u6ee4\u6807\u9898\u4e2d\u7684html\u4ee3\u7801"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WML");
            tbai.setDesc("WML");
            tbai.setDefaultValue("false");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PAGENUM");
            tbai.setDesc("PAGENUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXT");
            tbai.setDesc("EXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FILTEREDITORCSS");
            tbai.setDesc("FILTEREDITORCSS");
            tbai.setDefaultValue("false");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("pdfurlonly");
            tbai.setDesc("\u6587\u5e93\u6a21\u5f0f\u4e0b\u53ea\u53d6\u6e90\u6587\u4ef6");
            tbai.setDefaultValue("false");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENTERNUM");
            tbai.setDesc("ENTERNUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("cleanattrs4tags");
            tbai.setDesc("\u9700\u8981\u6e05\u7406html\u5c5e\u6027\u7684html\u6807\u8bb0\u5e8f\u5217");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("excludetags");
            tbai.setDesc("\u9700\u8981\u8fc7\u6ee4\u6389\u7684html\u6807\u8bb0\u5e8f\u5217");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("includetags");
            tbai.setDesc("\u9700\u8981\u4ec5\u4ec5\u4fdd\u7559\u7684html\u6807\u8bb0\u5e8f\u5217");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("Separator");
            tbai.setDesc("\u5173\u952e\u8bcd\u5206\u9694\u7b26\u53ef\u4ee5\u66ff\u6362\u4e3a\u6b64\u7b26\u53f7");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DOCCONTENT", 7);
        this.registerHostSpecialProperty("DOCTITLE", 1);
        this.registerHostSpecialProperty("DOCHTMLCON", 2);
        this.registerHostSpecialProperty("DOCHTMLCONTENT", 2);
        this.registerHostSpecialProperty("DOCPUBHTMLCON", 6);
        this.registerHostSpecialProperty("DOCPUBTIME", 3);
        this.registerHostSpecialProperty("DOCSOURCE", 4);
        this.registerHostSpecialProperty("DOCFROM", 4);
        this.registerHostSpecialProperty("DOCSECURITY", 5);
        this.registerHostSpecialProperty("HOMENAME", 8);
        this.registerHostSpecialProperty("TRUEUSER", 9);
        this.registerHostSpecialProperty("DOCPEOPLE", 10);
        this.registerHostSpecialProperty("CRUSER", 11);
        this.registerHostSpecialProperty("NICKCRUSER", 11);
        this.registerHostSpecialProperty("HOMESITE", 12);
        this.registerHostSpecialProperty("HOMESITENAME", 13);
        this.registerHostSpecialProperty("DOCABSTRACT", 14);
        this.registerHostSpecialProperty("ENTITYURL", 15);
        this.registerHostSpecialProperty("DOCFIRSTPUBTIME", 16);
        this.registerHostSpecialProperty("_RECFILEURL", 17);
        this.registerHostSpecialProperty("DOCFILESIZE", 18);
        this.registerHostSpecialProperty("DOCKEYWORDS", 19);
    }

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) throws WCMException {
        String[] results = null;
        try {
            if (!(this.m_host instanceof Document)) {
                StringBuffer sb = new StringBuffer(256);
                sb.append(this.m_tagItem.getDescWithPos()).append(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label3", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,"));
                sb.append(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label4", "\u53ef\u80fd\u76f4\u63a5\u7528\u5728\u4e86\u6982\u89c8\u9875\u9762\u4e2d\u6216\u8005\u5176\u5b83\u975eTRS_DOCUMENTS\u6982\u89c8\u7f6e\u6807\u4e2d\uff01[tag-host="));
                sb.append(this.m_host).append(']');
                _context.addWarning(sb.toString());
                return null;
            }
            Document doc = (Document)this.m_host;
            switch (_nPropertyId) {
                case 1: {
                    results = this.parseTitle(doc, _context);
                    break;
                }
                case 2: {
                    results = this.parseHtmlContent(doc, _context);
                    if (!_context.getAttribute("FILTEREDITORCSS", false)) break;
                    for (int i = 0; i < results.length; ++i) {
                        results[i] = results[i].replaceAll("<style.+?id=(['\"]?)_Custom_V6_Style_\\1[^>]*>[\\d\\D]*?</style>", "");
                    }
                    break;
                }
                case 3: {
                    results = this.parsePublishedTime(doc, _context);
                    break;
                }
                case 4: {
                    results = this.parseSource(doc, _context);
                    break;
                }
                case 5: {
                    Security aSecurity = doc.getSecurity();
                    if (aSecurity == null) break;
                    results = new String[]{aSecurity.getName()};
                    break;
                }
                case 6: {
                    results = doc.getType() == 20 ? this.parseHtmlContent(doc, _context) : this.parseHostNormalProperty("DOCPUBHTMLCON", _context);
                    if (!_context.getAttribute("FILTEREDITORCSS", false)) break;
                    for (int i = 0; i < results.length; ++i) {
                        results[i] = results[i].replaceAll("<style.+?id=(['\"]?)_Custom_V6_Style_\\1[^>]*>[\\d\\D]*?</style>", "");
                    }
                    break;
                }
                case 7: {
                    results = this.parseContent(doc, _context);
                    break;
                }
                case 8: {
                    results = this.parseHomeName(doc, _context);
                    break;
                }
                case 9: {
                    results = this.parseTrueUserName(doc);
                    break;
                }
                case 10: {
                    results = this.parseDocPeopleTitle(doc, _context);
                    break;
                }
                case 11: {
                    results = this.parseCrUser(doc, _context);
                    break;
                }
                case 12: 
                case 13: {
                    results = this.parseHomeSite(doc, _context, _nPropertyId);
                    break;
                }
                case 14: {
                    results = this.parseDocAbstract(doc, _context);
                    break;
                }
                case 15: {
                    results = this.parseDocEntityUrl(doc, _context);
                    break;
                }
                case 16: {
                    results = this.parseFirtPubTime(doc, _context);
                    break;
                }
                case 17: {
                    results = this.parseRecFileURL(doc, _context);
                    break;
                }
                case 18: {
                    if (doc.getType() == 40) {
                        String sFileName = doc.getPropertyAsString("DOCFILENAME");
                        FilesMan oFilesMan = FilesMan.getFilesMan();
                        String sAbsoluteFileName = oFilesMan.mapFilePath(sFileName, 0);
                        String sFileURL = CMyString.setStrEndWith(sAbsoluteFileName, '/') + sFileName;
                        s_logger.debug((Object)sFileURL);
                        FileService file = new FileService(sFileURL);
                        return new String[]{FileHelper.convertFileSize(file.length())};
                    }
                    results = new String[]{""};
                    break;
                }
                case 19: {
                    results = this.parseDocKeywords(doc, _context);
                    break;
                }
                default: {
                    throw new Exception(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label5", "\u6307\u5b9a\u7684\u5c5e\u6027") + _context.getAttribute("FIELD") + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label6", "\u6ca1\u6709\u6ce8\u518c!"));
                }
            }
            if (results == null) {
                return null;
            }
            return TagParseHelper.addSpanStyleIfNeeded(_context, results);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label7", "\u89e3\u6790") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label8", "\u7684[") + _context.getAttribute("FIELD") + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label9", "]\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff01"), ex);
        }
    }

    private String[] parseFirtPubTime(Document _doc, PublishTagContext _context) {
        CMyDateTime dtValue = _doc.getPropertyAsDateTime("DOCPUBTIME");
        if (dtValue == null || dtValue.isNull()) {
            dtValue = CMyDateTime.now();
        }
        try {
            return this.parseProperty(dtValue, _context);
        }
        catch (WCMException e) {
            return null;
        }
    }

    private String[] parseRecFileURL(Document _doc, PublishTagContext _context) throws WCMException {
        if (_doc.getType() != 40) {
            return new String[]{this.getAutoLinkUrl(_context)};
        }
        IPublishElement element = _context.getUpperHost();
        IPublishContent content = (IPublishContent)element;
        PublishPathCompass compass = _context.getPathCompass();
        String sFileName = content.getFileName();
        String sAbsURL = compass.getAbsoluteHttpPath(_context.getUpperHost()) + sFileName;
        if (!_context.getAttribute("UrlIsAbs", false)) {
            sAbsURL = HtmlUtil.calRelativePath(sAbsURL, _context.getPageHttpPath());
        }
        return new String[]{sAbsURL};
    }

    private String[] parseDocAbstract(Document doc, PublishTagContext _context) throws WCMException {
        int nMaxLength;
        String sAbstract = doc.getAbstract();
        if (CMyString.isEmpty(sAbstract)) {
            String sDefaultField = _context.getAttribute("DefaultField");
            if (CMyString.isEmpty(sDefaultField)) {
                return new String[]{""};
            }
            sAbstract = doc.getPropertyAsString(sDefaultField);
            if (CMyString.isEmpty(sAbstract)) {
                return new String[]{""};
            }
        }
        if ((nMaxLength = _context.getAttribute("NUM", 0)) > 0) {
            sAbstract = CMyString.stripHTMLTags(sAbstract);
        }
        sAbstract = sAbstract.replaceAll("&nbsp;", " ").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&amp;", "&").replaceAll("&ldquo;", "\u201c").replaceAll("&rdquo;", "\u201d").replaceAll("&hellip;", "\u2026").replaceAll("&mdash;", "\u2014").replaceAll("&lsquo;", "\u2018").replaceAll("&rsquo;", "\u2019");
        String sTruncatedFlag = _context.getAttribute("TRUNCATEDFLAG");
        if (sTruncatedFlag == null) {
            sTruncatedFlag = "...";
        }
        sAbstract = CMyString.truncateStr(sAbstract, nMaxLength, sTruncatedFlag);
        sAbstract = TagParseHelper.formatTextIfNeeded(_context, sAbstract);
        sAbstract = TagParseHelper.addSpanStyleIfNeeded(_context, sAbstract);
        return new String[]{sAbstract};
    }

    private String[] parseDocEntityUrl(Document doc, PublishTagContext _context) throws WCMException {
        IPublishElement publishElement = PublishElementFactory.lookupElement(605, doc.getId());
        PublishPathCompass compass = new PublishPathCompass();
        String sUrl = "";
        sUrl = _context.isPreview() ? compass.getPreviewHttpUrl((IPublishContent)publishElement, 0) : compass.getHttpUrl((IPublishContent)publishElement, 0);
        Document parentDocument = (Document)doc.clone();
        while (parentDocument.getOutUpId() > 0 && (parentDocument = Document.findById(parentDocument.getOutUpId())) != null) {
        }
        if (parentDocument != null) {
            IPublishElement parentpublishElement = PublishElementFactory.lookupElement(605, parentDocument.getId());
            PublishPathCompass parentcompass = new PublishPathCompass();
            String sParentUrl = "";
            sParentUrl = _context.isPreview() ? parentcompass.getPreviewHttpUrl((IPublishContent)parentpublishElement, 0) : parentcompass.getHttpUrl((IPublishContent)parentpublishElement, 0);
            if (sParentUrl.endsWith("html") || sParentUrl.endsWith("htm")) {
                return new String[]{sParentUrl};
            }
        }
        return new String[]{sUrl};
    }

    private String[] parseCrUser(Document doc, PublishTagContext _context) {
        User cruser = doc.getCrUser();
        if (cruser == null) {
            return null;
        }
        String result = null;
        if (_context.getAttribute("NICKCRUSER", true)) {
            result = cruser.getNickName();
        }
        if (_context.getAttribute("CRUSERID", false)) {
            result = String.valueOf(cruser.getId());
        }
        if (result == null) {
            result = cruser.getName();
        }
        return new String[]{result};
    }

    private String[] parseDocKeywords(Document doc, PublishTagContext _context) throws WCMException {
        String sResult = null;
        sResult = doc.getKeywords();
        if (sResult == null) {
            return null;
        }
        sResult = this.parseProperty(sResult, _context)[0];
        String sSeparator = _context.getAttribute("Separator");
        if (!CMyString.isEmpty(sSeparator)) {
            sResult = sResult.replaceAll(";", sSeparator);
        }
        return new String[]{sResult};
    }

    private String[] parseDocPeopleTitle(Document _doc, PublishTagContext _context) throws WCMException {
        String sTitle = _doc.getPeople();
        if (CMyString.isEmpty(sTitle)) {
            sTitle = _doc.getTitle();
        }
        try {
            String sColor;
            if (_context.getAttribute("CODEFILTERED", false)) {
                sTitle = CMyString.stripHTMLTags(sTitle);
            }
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sTitle);
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("AUTOCOLOR", true) && (sColor = _doc.getTitleColor()) != null && (sColor = sColor.trim()).length() > 0 && !sColor.equalsIgnoreCase("null")) {
                StringBuffer buff = new StringBuffer();
                buff.append("<font color=\"").append(sColor).append("\">");
                buff.append(sResult);
                buff.append("</font>");
                sResult = buff.toString();
                buff.setLength(0);
            }
            if (_context.getAttribute("AUTOLINK", true) && !_context.getPageElement().getSubstance().equals(_doc)) {
                sResult = this.addAutoLink(sResult, sTitle, _context);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label11", " \u7684\u6807\u9898\u5931\u8d25!"), ex);
        }
    }

    @Override
    protected String getDefaultField() {
        return "DOCTITLE";
    }

    private String[] parseTitle(Document _doc, PublishTagContext _context) throws WCMException {
        String sTitle = _doc.getTitle();
        try {
            String sColor;
            int nMaxLength;
            if (_context.getAttribute("CODEFILTERED", false)) {
                sTitle = CMyString.stripHTMLTags(sTitle);
            }
            if ((nMaxLength = _context.getAttribute("NUM", 0)) > 0) {
                sTitle = CMyString.innerText(sTitle);
            }
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sTitle);
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("AUTOCOLOR", true) && (sColor = _doc.getTitleColor()) != null && (sColor = sColor.trim()).length() > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append("<font color=\"").append(sColor).append("\">");
                buff.append(sResult);
                buff.append("</font>");
                sResult = buff.toString();
                buff.setLength(0);
            }
            if (_context.getAttribute("AUTOLINK", true) && !_context.getPageElement().getSubstance().equals(_doc)) {
                sResult = this.addAutoLink(sResult, sTitle, _context);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label11", " \u7684\u6807\u9898\u5931\u8d25!"), ex);
        }
    }

    private String[] parseContent(Document _doc, PublishTagContext _context) throws WCMException {
        if (_doc.getChannel().getType() == 13) {
            return null;
        }
        String sContent = _doc.getContent();
        if (_context.getAttribute("CODEFILTERED", false)) {
            sContent = CMyString.stripHTMLTags(sContent);
        }
        boolean bSetAutoformat = false;
        if (this.m_tagItem.getAttribute("AUTOFORMAT") == null) {
            this.m_tagItem.setAttribute("AUTOFORMAT", true);
            bSetAutoformat = true;
        }
        try {
            String[] pResult;
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sContent);
            if (_context.getAttribute("WML", false) && (pResult = this.makeWMLContent(_context, sResult)) != null) {
                String[] stringArray = pResult;
                return stringArray;
            }
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("AUTOLINK", false) && !_context.getPageElement().getSubstance().equals(_doc)) {
                sResult = this.addAutoLink(sResult, sContent, _context);
            }
            pResult = new String[]{sResult};
            return pResult;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label12", " \u7684\u6b63\u6587\u5931\u8d25!"), ex);
        }
        finally {
            if (bSetAutoformat) {
                this.m_tagItem.setAttribute("AUTOFORMAT", null);
            }
        }
    }

    private String[] makeWMLContent(PublishTagContext _context, String _sResult) throws WCMException {
        return this.makeWmlContent0(_context, _sResult);
    }

    private String[] makeWmlContent0(PublishTagContext _context, String _sResult) throws WCMException {
        int nMaxNum = _context.getAttribute("PAGENUM", 900);
        if (nMaxNum <= 0) {
            return null;
        }
        String sFileName = PublishPathCompass.makeDetailPageFileName((IPublishContent)_context.getPageElement());
        String sFileExt = _context.getPageContext().getTemplate().getOutputFileExt();
        ArrayList<String> list = new ArrayList<String>(5);
        StringBuffer buff = new StringBuffer(1024);
        int nEnLen = 1;
        int nChLen = 3;
        int nCurrLen = 0;
        int nPageIndex = 0;
        int nGet = 0;
        String temp = null;
        for (char ch : _sResult.toCharArray()) {
            int n = nCurrLen = ch <= '\u007f' ? nEnLen : nChLen;
            if ((nGet += nCurrLen) > nMaxNum) {
                temp = TagParseHelper.formatTextIfNeeded(_context, buff.toString());
                buff.setLength(0);
                buff.append(temp);
                buff.append("<br />");
                buff.append(WCMTagParserDocument.makeCurrNavContent(sFileName, sFileExt, nPageIndex, true));
                list.add(buff.toString());
                buff.setLength(0);
                ++nPageIndex;
                nGet = nCurrLen;
            }
            buff.append(ch);
        }
        int nImgCount = 0;
        try {
            temp = _context.getPageContext().getExtraAttribute("PAGVAR_WMLIMGCOUNT");
            nImgCount = Integer.parseInt(temp) - 1;
        }
        catch (Exception len) {
            // empty catch block
        }
        if (buff.length() > 0) {
            temp = TagParseHelper.formatTextIfNeeded(_context, buff.toString());
            buff.setLength(0);
            buff.append(temp);
            if (nPageIndex > 0 || nImgCount > nPageIndex) {
                buff.append("<br />");
                buff.append(WCMTagParserDocument.makeCurrNavContent(sFileName, sFileExt, nPageIndex, nImgCount > nPageIndex));
            }
            list.add(buff.toString());
            buff.setLength(0);
        }
        buff.setLength(0);
        nImgCount -= nPageIndex;
        while (--nImgCount >= 0) {
            buff.append("<br />");
            buff.append(WCMTagParserDocument.makeCurrNavContent(sFileName, sFileExt, ++nPageIndex, nImgCount > 0));
            list.add(buff.toString());
            buff.setLength(0);
        }
        String[] result = new String[list.size()];
        result = list.toArray(result);
        return result;
    }

    private static String makeCurrNavContent(String _sFileName, String _sFileExt, int _nIndex, boolean _bDisplayPre) {
        String sURL;
        StringBuffer sbNavContent = new StringBuffer();
        if (_nIndex > 0) {
            sURL = null;
            sURL = _nIndex == 1 ? _sFileName + "." + _sFileExt : _sFileName + "_" + (_nIndex - 1) + "." + _sFileExt;
            sbNavContent.append("<a href=\"" + sURL + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label13", "\">&lt;&lt;\u4e0a\u4e00\u9875</a>"));
            sbNavContent.append("&nbsp;&nbsp;");
        }
        if (_bDisplayPre) {
            sURL = _sFileName + "_" + (_nIndex + 1) + "." + _sFileExt;
            sbNavContent.append("<a href=\"" + sURL + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label14", "\">\u4e0b\u4e00\u9875&gt;&gt;</a>"));
        }
        return sbNavContent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] parseHtmlContent(Document _doc, PublishTagContext _context) throws WCMException {
        if (_doc.getChannel().getType() == 13) {
            return null;
        }
        if (_doc.getType() != 20) {
            boolean bSetAutoformat = false;
            try {
                if (this.m_tagItem.getAttribute("AUTOFORMAT") == null) {
                    this.m_tagItem.setAttribute("AUTOFORMAT", true);
                    bSetAutoformat = true;
                }
                if (_doc.getType() != 40) {
                    String[] stringArray = this.parseHostNormalProperty("DOCPUBHTMLCON", _context);
                    return stringArray;
                }
                String[] stringArray = new String[]{this.makeSWFViewHTML(_doc, _context)};
                return stringArray;
            }
            finally {
                if (bSetAutoformat) {
                    this.m_tagItem.setAttribute("AUTOFORMAT", null);
                }
            }
        }
        String sResult = null;
        try {
            String sIncludeTags;
            String sExcludeTags;
            String sCleanTagsAttrs;
            sResult = new HTMLContentParseHelper().makeHTMLContentParsed(_context, _doc.getPubHtmlContent());
            sResult = sResult.replaceAll("(?is)<TRS_COMMENT.*?>.*?</TRS_COMMENT>", "");
            if (sResult == null || sResult.length() == 0) {
                sResult = _doc.getContent();
            }
            if (!CMyString.isEmpty(sCleanTagsAttrs = _context.getAttribute("cleanattrs4tags"))) {
                sResult = CMyString.cleanAttributes4Tags(sResult, sCleanTagsAttrs);
            }
            if (!CMyString.isEmpty(sExcludeTags = _context.getAttribute("excludetags"))) {
                sResult = CMyString.excludeTags(sResult, sExcludeTags);
            }
            if (!CMyString.isEmpty(sIncludeTags = _context.getAttribute("includetags"))) {
                sResult = CMyString.includeTags(sResult, sIncludeTags);
            }
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(sResult);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label12", " \u7684\u6b63\u6587\u5931\u8d25!"), ex);
        }
    }

    private String makeSWFViewHTML(Document _doc, PublishTagContext _context) {
        String sFileName = _doc.getPropertyAsString("DOCFILENAME");
        int nPos = sFileName.lastIndexOf(46);
        String sFileExt = CMyFile.excludeFileExt(sFileName);
        if (!sFileExt.equals("swf") && nPos > 0) {
            String sSWFFileName = sFileName.substring(0, nPos + 1) + "swf";
            try {
                String sAbsoluteSWFFileName = FilesMan.getFilesMan().mapFilePath(sSWFFileName, 0) + sSWFFileName;
                if (!CMyFile.fileExists(sAbsoluteSWFFileName)) {
                    return "";
                }
                this.distributionDocFile(_doc, _context, sSWFFileName);
                this.distributionDocFile(_doc, _context, sFileName);
                if (_context.getAttribute("pdfurlonly", false)) {
                    String sUrl = _context.getPathCompass().getAbsoluteHttpPath(_context.getUpperHost());
                    sUrl = sUrl + sFileName;
                    if (!_context.getAttribute("UrlIsAbs", false)) {
                        sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
                    }
                    return sUrl;
                }
                String sViewHTML = CMyFile.readFile(CMyFile.mapResouceFullPath("swf_view.html"), "utf-8");
                sViewHTML = CMyString.replaceStr(sViewHTML, "SWF_FILENAME", sSWFFileName);
                return sViewHTML;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void distributionDocFile(Document _doc, PublishTagContext _context, String _sFileName) {
        try {
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            IPublishContent publishContent = (IPublishContent)_context.getUpperHost();
            String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(_sFileName, 0) + _sFileName;
            if (!CMyFile.fileExists(sSrcFilePathName)) {
                return;
            }
            String sLocalPath = compass.getLocalPath(publishContent, bPreview);
            PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
            CMyFile.copyFile(sSrcFilePathName, sLocalPath + _sFileName);
            if (!bPreview) {
                _context.getFileDistributeShip().distributeFile(sSrcFilePathName, publishContent, null, true);
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label15", "\u53d1\u5e03") + _doc + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label16", "\u7684\u5916\u90e8\u5931\u8d25\uff01")), (Throwable)ex);
        }
    }

    private String[] parsePublishedTime(Document _doc, PublishTagContext _context) throws WCMException {
        IPublishFolder folder = _context.getUpperHost().getFolder();
        if (folder == null || folder.getType() != 101) {
            throw new WCMException(10, "Parameter of channel folder required!");
        }
        try {
            CMyDateTime dtValue = _doc.getPropertyAsDateTime("DOCPUBTIME");
            if ((dtValue == null || dtValue.isNull()) && ((dtValue = this.loadPublishedTimeFromDB(_doc, folder)) == null || dtValue.isNull())) {
                dtValue = CMyDateTime.now();
            }
            return this.parseProperty(dtValue, _context);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label17", " \u7684\u53d1\u5e03\u65f6\u95f4\u5931\u8d25!"), ex);
        }
    }

    private CMyDateTime loadPublishedTimeFromDB(Document _doc, IPublishFolder _folder) throws WCMException {
        String SQL = "SELECT DOCPUBTIME FROM WCMCHNLDOC WHERE DOCID=? AND CHNLID=?";
        DBManager dbManager = null;
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        try {
            dbManager = DBManager.getDBManager();
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("SELECT DOCPUBTIME FROM WCMCHNLDOC WHERE DOCID=? AND CHNLID=?");
            oPreStmt.setInt(1, _doc.getId());
            oPreStmt.setInt(2, _folder.getId());
            oPreStmt.setMaxRows(1);
            rsData = oPreStmt.executeQuery();
            if (rsData == null || !rsData.next()) {
                CMyDateTime cMyDateTime = null;
                return cMyDateTime;
            }
            CMyDateTime dtValue = new CMyDateTime();
            dtValue.setDateTimeWithRs(rsData, 1);
            CMyDateTime cMyDateTime = dtValue;
            return cMyDateTime;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to load the doucment published time from database!", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null && dbManager != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    private String[] parseSource(Document _doc, PublishTagContext _context) throws WCMException {
        Source docSource = null;
        try {
            String sLink;
            docSource = _doc.getSource();
            if (docSource == null) {
                String sSourceName = _doc.getPropertyAsString("DOCSOURCENAME");
                if (!CMyString.isEmpty(sSourceName)) {
                    sSourceName = TagParseHelper.truncateTextIfNeeded(_context, sSourceName);
                    return new String[]{sSourceName};
                }
                int nSourceId = _doc.getSourceId();
                if (nSourceId > 0) {
                    return new String[]{"SRC-" + nSourceId};
                }
                return null;
            }
            String sFullValue = docSource.getName();
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sFullValue);
            if (_context.getAttribute("AUTOLINK", false) && (sLink = docSource.getLink()) != null && (sLink = sLink.trim()).length() > 0) {
                String sTarget = _context.getAttribute("TARGET");
                String sExtra = _context.getAttribute("EXTRA");
                sResult = HtmlUtil.renderLink(sLink, sTarget, sFullValue, sExtra, sResult, _context.getAttribute("LINKTEXT"));
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to parse the document source!", ex);
        }
    }

    private String[] parseHomeName(Document _doc, PublishTagContext _context) throws WCMException {
        Channel channel = _doc.getChannel();
        if (channel == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label18", "\u83b7\u53d6 ") + _doc + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label19", " \u7684\u6240\u5c5e\u9891\u9053\u5931\u8d25!"));
        }
        String sHomeName = (String)channel.getProperty("CHNLDESC");
        try {
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sHomeName);
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("AUTOLINK", true)) {
                String sURL = null;
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
                if (folder.isLink()) {
                    sURL = folder.getLinkUrl();
                } else {
                    sURL = _context.getPathCompass().getAbsoluteHttpPath(folder);
                    if (!_context.getAttribute("URLISABS", false)) {
                        sURL = HtmlUtil.calRelativePath(sURL, _context.getPageHttpPath());
                    }
                }
                sResult = TagParseHelper.addAutoLink(sURL, sResult, sHomeName, _context);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + _doc + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label20", " \u7684\u6240\u5c5e\u9891\u9053\u540d\u79f0\u5931\u8d25!"), ex);
        }
    }

    private String[] parseTrueUserName(Document _doc) throws WCMException {
        String result = null;
        try {
            User cruser = _doc.getCrUser();
            if (cruser != null) {
                result = cruser.getTrueName();
            }
            if (CMyString.isEmpty(result)) {
                result = _doc.getCrUserName();
            }
            return new String[]{result};
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + _doc + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label21", " \u7684\u521b\u5efa\u8005\u771f\u5b9e\u540d\u79f0\u5931\u8d25!"), e);
        }
    }

    public static int getBytesLength(String _string) {
        if (_string == null) {
            return 0;
        }
        char[] srcBuff = _string.toCharArray();
        int nGet = 0;
        for (int i = 0; i < srcBuff.length; ++i) {
            char aChar = srcBuff[i];
            nGet += aChar <= '\u007f' ? 1 : 2;
        }
        return nGet;
    }

    private String[] parseHomeSite(Document _doc, PublishTagContext _context, int propertyId) throws WCMException {
        Channel channel = _doc.getChannel();
        if (channel == null) {
            throw new WCMException("\u83b7\u53d6 " + _doc + " \u7684\u6240\u5c5e\u9891\u9053\u5931\u8d25!");
        }
        WebSite site = channel.getSite();
        String sHomeName = propertyId == 12 ? site.getDesc() : site.getName();
        try {
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sHomeName);
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("AUTOLINK", false)) {
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(site);
                String sURL = folder.getRootDomain();
                sResult = TagParseHelper.addAutoLink(sURL, sResult, sHomeName, _context);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException("\u89e3\u6790 " + _doc + " \u7684\u6240\u5c5e\u7ad9\u70b9\u5931\u8d25!", ex);
        }
    }
}

