/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WCMDocumentImagesGenerator {
    private static Logger logger = Logger.getLogger(WCMDocumentImagesGenerator.class);
    public static final String FROM_CONTENT = "content";
    public static final String FROM_APPENDIX = "appendix";
    public static final int MIN_WIDTH = 100;
    public static final int MIN_HEIGHT = 100;

    public static DefaultObjs getImagesFromHtmlContent(PublishTagContext _context, String sHtmlContent, int nNum) throws WCMException {
        String sContPicMinLimit = ConfigServer.getServer().getSysConfigValue("DOCCONTENTPIC_VALID_MIN_LIMIT", "600,400");
        int[] nContPicMinLimit = CMyString.splitToInt(sContPicMinLimit, ",");
        int nContPicMinWidth = _context.getAttribute("MinWidth", nContPicMinLimit[0]);
        int nContPicMinHeight = _context.getAttribute("MinHeight", nContPicMinLimit[1]);
        return WCMDocumentImagesGenerator.getImagesFromHtmlContent(sHtmlContent, nNum, nContPicMinWidth, nContPicMinHeight);
    }

    public static DefaultObjs getImagesFromHtmlContent(String sHtmlContent, int nNum) throws WCMException {
        String sContPicMinLimit = ConfigServer.getServer().getSysConfigValue("DOCCONTENTPIC_VALID_MIN_LIMIT", "600,400");
        int[] nContPicMinLimit = CMyString.splitToInt(sContPicMinLimit, ",");
        return WCMDocumentImagesGenerator.getImagesFromHtmlContent(sHtmlContent, nNum, nContPicMinLimit[0], nContPicMinLimit[1]);
    }

    public static DefaultObjs getImagesFromHtmlContent(String sHtmlContent, int nNum, int nMinWidth, int nMinHeight) throws WCMException {
        DefaultObjs images = new DefaultObjs(null);
        images.setPageSize(20);
        return WCMDocumentImagesGenerator.getContentImages(sHtmlContent, nNum, nMinWidth, nMinHeight, images);
    }

    public static DefaultObjs getDocumentImages(PublishTagContext _context, Document m_oDocument, int nNum) throws WCMException {
        String sFirstFrom = _context.getAttribute("FirstFrom");
        String sOnlyFrom = _context.getAttribute("OnlyFrom");
        DefaultObjs images = new DefaultObjs(null);
        images.setPageSize(20);
        String sAppPicMinLimit = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
        int[] nAppPicMinLimit = CMyString.splitToInt(sAppPicMinLimit, ",");
        String sContPicMinLimit = ConfigServer.getServer().getSysConfigValue("DOCCONTENTPIC_VALID_MIN_LIMIT", "600,400");
        int[] nContPicMinLimit = CMyString.splitToInt(sContPicMinLimit, ",");
        int nAppPicMinWidth = _context.getAttribute("MinWidth", nAppPicMinLimit[0]);
        int nAppPicMinHeight = _context.getAttribute("MinHeight", nAppPicMinLimit[1]);
        int nContPicMinWidth = _context.getAttribute("MinWidth", nContPicMinLimit[0]);
        int nContPicMinHeight = _context.getAttribute("MinHeight", nContPicMinLimit[1]);
        if (!CMyString.isEmpty(sOnlyFrom)) {
            if (FROM_APPENDIX.equalsIgnoreCase(sOnlyFrom)) {
                WCMDocumentImagesGenerator.getAppendixImages(m_oDocument, nNum, nAppPicMinWidth, nAppPicMinHeight, images);
            } else {
                WCMDocumentImagesGenerator.getContentImages(m_oDocument, nNum, nContPicMinWidth, nContPicMinHeight, images);
            }
        } else if (!CMyString.isEmpty(sFirstFrom) && FROM_CONTENT.equalsIgnoreCase(sFirstFrom)) {
            WCMDocumentImagesGenerator.getContentImages(m_oDocument, nNum, nContPicMinWidth, nContPicMinHeight, images);
            if (images.size() < nNum) {
                WCMDocumentImagesGenerator.getAppendixImages(m_oDocument, nNum, nAppPicMinWidth, nAppPicMinHeight, images);
            }
        } else {
            WCMDocumentImagesGenerator.getAppendixImages(m_oDocument, nNum, nAppPicMinWidth, nAppPicMinHeight, images);
            if (images.size() < nNum) {
                WCMDocumentImagesGenerator.getContentImages(m_oDocument, nNum, nContPicMinWidth, nContPicMinHeight, images);
            }
        }
        return images;
    }

    public static DefaultObjs getAppendixImages(Document _document, int _num, int _minWidth, int _minHeight, DefaultObjs _images) throws WCMException {
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes aApps = appendixMgr.getAppendixes(_document, 20);
        int currSize = _images.size();
        for (int i = 0; i < aApps.size() && currSize < _num; ++i) {
            Appendix appendix = (Appendix)aApps.getAt(i);
            String sName = appendix.getFile();
            if (!WCMDocumentImagesGenerator.isValid(sName, _minWidth, _minHeight)) continue;
            String sDesc = appendix.getDesc();
            WCMDocumentImagesGenerator.addImage(sName, sDesc, _images);
            currSize = _images.size();
        }
        return _images;
    }

    public static DefaultObjs getContentImages(Document _document, int _num, int _minWidth, int _minHeight, DefaultObjs _images) {
        String sHtmlContent = _document.getHtmlContent();
        return WCMDocumentImagesGenerator.getContentImages(sHtmlContent, _num, _minWidth, _minHeight, _images);
    }

    private static DefaultObjs getContentImages(String sHtmlContent, int _num, int _minWidth, int _minHeight, DefaultObjs _images) {
        if (CMyString.isEmpty(sHtmlContent)) {
            return _images;
        }
        String sReg = "(?is)<img\\b[^>]*\\bsrc=\"([^\"]+)?\"[^>]*?>";
        Pattern pattern = Pattern.compile(sReg);
        String sTitleReg = "(?is)<img\\b[^>]*\\btitle=\"([^\"]+)?\"[^>]*?>";
        Pattern titlePattern = Pattern.compile(sTitleReg);
        Matcher matcher = pattern.matcher(sHtmlContent);
        String sImageName = null;
        String sImageTitle = null;
        String sImageTag = null;
        int i = _images.size();
        while (matcher.find() && i < _num) {
            sImageName = matcher.group(1);
            if (sImageName == null || sImageName.trim().length() == 0) continue;
            int nPos = sImageName.lastIndexOf("/");
            if (nPos < 0) {
                nPos = sImageName.lastIndexOf("\\");
            }
            if (nPos >= 0) {
                sImageName = sImageName.substring(nPos + 1);
            }
            if (!WCMDocumentImagesGenerator.isValid(sImageName, _minWidth, _minHeight)) continue;
            sImageTag = matcher.group(0);
            Matcher titleMatcher = titlePattern.matcher(sImageTag);
            sImageTitle = "";
            if (titleMatcher.find()) {
                sImageTitle = titleMatcher.group(1);
            }
            WCMDocumentImagesGenerator.addImage(sImageName, sImageTitle, _images);
            ++i;
        }
        return _images;
    }

    private static void addImage(String sImageName, String sImageTitle, DefaultObjs _currimages) {
        block5: {
            DefaultObj obj = new DefaultObj();
            String sImageDesc = CMyString.showNull(sImageTitle, "");
            try {
                obj.setProperty("FileName", sImageName, false);
                obj.setProperty("FileDesc", sImageDesc, false);
            }
            catch (WCMException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\u8bbe\u7f6e\u6b63\u6587\u4e2d\u56fe\u7247\u7684\u6587\u4ef6\u540d\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                return;
            }
            obj.setId(_currimages.size() + 1);
            obj.setAddMode(false);
            try {
                _currimages.addElement(obj);
            }
            catch (WCMException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"\u8bbe\u7f6e\u6b63\u6587\u4e2d\u56fe\u7247\u7684\u6587\u4ef6\u540d\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private static boolean isValid(String sFileName, int _minWidth, int _minHeight) {
        String sSrcFilePathName;
        try {
            sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        }
        catch (WCMException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6839\u636e\u6587\u4ef6\u540d[" + sFileName + "]\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
            }
            return false;
        }
        return FileHelper.validImageFile(sSrcFilePathName, _minWidth, _minHeight);
    }
}

