/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TagParserURLContent
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(TagParserURLContent.class);

    @Override
    public TagBeanInfo getBeanInfo() {
        TagBeanAttrInfo tagbeanattrinfo = null;
        TagBeanInfo tagbeaninfo = new TagBeanInfo();
        tagbeaninfo.setName("TRS_URLCONTENT");
        tagbeaninfo.setDesc("TRS_URLCONTENT");
        tagbeaninfo.setType(TagBeanInfo.BodyType.IGNORE);
        tagbeanattrinfo = new TagBeanAttrInfo();
        tagbeanattrinfo.setName("URL");
        tagbeanattrinfo.setType(TagBeanAttrInfo.Type.STRING);
        tagbeaninfo.addAttrInfo(tagbeanattrinfo);
        tagbeanattrinfo = new TagBeanAttrInfo();
        tagbeanattrinfo.setName("TAG");
        tagbeanattrinfo.setType(TagBeanAttrInfo.Type.STRING);
        tagbeaninfo.addAttrInfo(tagbeanattrinfo);
        return tagbeaninfo;
    }

    @Override
    public String[] parse(PublishTagContext context) throws WCMException {
        String sFullUrl = context.getAttribute("url");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u83b7\u53d6\u5730url\u5c5e\u6027:" + sFullUrl));
        }
        IPublishFolder pageFolder = context.getPageFolder();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SITEID", String.valueOf(pageFolder.getRoot().getId()));
        map.put("CHANNELID", String.valueOf(pageFolder.getId()));
        sFullUrl = CMyString.parsePageVariables(sFullUrl, map);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SiteId:" + pageFolder.getRoot().getId() + ";ChannelId:" + pageFolder.getId()));
            logger.debug((Object)("\u89e3\u6790\u540e\u7684url\u5730\u5740:" + sFullUrl));
        }
        int nQueryStringIndex = sFullUrl.indexOf("?");
        String sUrl = sFullUrl;
        String sQueryString = "";
        if (nQueryStringIndex > 0) {
            sUrl = sFullUrl.substring(0, nQueryStringIndex);
            sQueryString = sFullUrl.substring(nQueryStringIndex + 1);
        }
        String sContent = "";
        try {
            String regex;
            Pattern pattern;
            Matcher m;
            sContent = CMy3WLib.doGet(sUrl, sQueryString).getBodyAsString();
            String sTag = context.getAttribute("tag");
            if (!CMyString.isEmpty(sTag) && (m = (pattern = Pattern.compile(regex = "(?is)<" + sTag + "(?: [^>]*>|>)(.*?)</" + sTag + ">")).matcher(sContent)).find()) {
                sContent = m.group(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6url\u5185\u5bb9\u5931\u8d25\uff01", (Throwable)e);
        }
        return new String[]{sContent};
    }
}

