/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.mobileportal;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.mobileportal.IMobilePortalServiceProvider;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class MobilePortalServiceProvider
implements IMobilePortalServiceProvider {
    private static Logger logger = Logger.getLogger(MobilePortalServiceProvider.class);
    private static boolean BPROCESSING = false;
    private String m_sDocSDate = "";
    private boolean m_bWJBhd = false;
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private int[] m_nStatusOfCanPub = new int[]{1, 2, 10, 16, 15, 18, 1027, 21, 22};
    private static Templates m_oTemplats = null;
    public static String[] m_sSiteOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u7ad9\u70b9\u9996\u9875", "\u7ad9\u70b9\u8f85\u52a9\u6a21\u677f"};
    public static String[] m_sChnlOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f"};
    public static String[] m_sPushMsgOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f", "\u6d88\u606f\u63a8\u9001\u6700\u65b0\u65f6\u95f4"};
    public static String m_sDetailTemplateNames = "\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u4e0d\u5e26\u683c\u5f0f,\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u5e26\u683c\u5f0f";
    public static String m_sPushMsgChnlName = "\u6d88\u606f\u63a8\u9001";
    public static String m_sPushMsgChnlPath = "notify";
    public static String m_sWBChnlName = "\u5b98\u65b9\u5fae\u535a";
    public static String m_sWBChnlPath = "WEIBO";
    public static String[] m_sDefaultLogo = new String[]{"home.png", "service.png", "hot.png"};
    public static String m_sTemplateFile = "TEMPLATE--MOBILEPORTAL";
    private static String m_sWJBTemplateFlag = "--iPad4wjb";
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
    private HashMap serviceMap = new HashMap();
    private static String m_sMessage = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createMobilePortal(MethodContext _context) throws CMyException {
        if (!PluginConfig.isStartMobilePortal()) {
            throw new WCMException("\u60a8\u6ca1\u6709\u8d2d\u4e70\u79fb\u52a8\u95e8\u6237\uff01");
        }
        final User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u7ad9\u70b9\uff01");
        }
        final int nSrcSiteId = _context.getValue("SrcSiteId", 0);
        if (nSrcSiteId <= 0) {
            throw new WCMException("\u4f20\u5165\u7684\u7ad9\u70b9ID\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        WebSite srcWebSite = WebSite.findById(nSrcSiteId);
        if (srcWebSite == null) {
            throw new WCMException("\u4f20\u5165\u7684\u7ad9\u70b9Id\u3010" + nSrcSiteId + "\u3011\u65e0\u6548.");
        }
        MobilePortalServiceProvider mobilePortalServiceProvider = this;
        synchronized (mobilePortalServiceProvider) {
            if (BPROCESSING) {
                return;
            }
            final MethodContext context = _context;
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ContextHelper.initContext(loginUser);
                    BPROCESSING = true;
                    try {
                        MobilePortalServiceProvider.this.setDocSynTime(context.getValue("DocSDate"));
                        int nNewSiteId = MobilePortalServiceProvider.this.createSite(nSrcSiteId);
                        String sTemplateType = context.getValue("TemplateFlag");
                        MobilePortalServiceProvider.this.m_bWJBhd = m_sWJBTemplateFlag.equals(sTemplateType);
                        MobilePortalServiceProvider.this.importTemplate(nNewSiteId, sTemplateType);
                        MobilePortalServiceProvider.this.configSiteTemplate(nNewSiteId);
                        String sDelChnlIds = context.getValue("DelChnlIds");
                        MobilePortalServiceProvider.this.makeMobileChnls(nSrcSiteId, nNewSiteId, sDelChnlIds);
                        boolean bCreateOfficialWB = context.getValue("CreateOfficialWB", true);
                        boolean bCreatePushMsg = context.getValue("CreatePushMsg", true);
                        MobilePortalServiceProvider.this.createLogoForLevelOneChnl(nNewSiteId);
                        MobilePortalServiceProvider.this.createSpecialChannel(nNewSiteId, bCreatePushMsg, bCreateOfficialWB);
                        MobilePortalServiceProvider.this.fullPublishSite(nNewSiteId);
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
                    }
                    finally {
                        BPROCESSING = false;
                        m_sMessage = "-1";
                        MobilePortalServiceProvider.this.m_sDocSDate = "";
                        ContextHelper.clear();
                    }
                }
            };
            t.start();
        }
    }

    private void setDocSynTime(String _sDocsDate) throws CMyException {
        if (CMyString.isEmpty(_sDocsDate)) {
            String sBeforeTenYearDateTime;
            CMyDateTime currDateTime = CMyDateTime.now();
            CMyDateTime beforeTenYearDateTime = currDateTime.dateAdd(1, -10);
            this.m_sDocSDate = sBeforeTenYearDateTime = beforeTenYearDateTime.toString("yyyy-MM-dd");
        } else {
            CMyDateTime dt = new CMyDateTime();
            dt.setDateTimeWithString(_sDocsDate, "yyyy-MM-dd");
            this.m_sDocSDate = dt.toString("yyyy-MM-dd");
        }
    }

    private int createSite(int _srcSiteId) throws WCMException {
        m_sMessage = "\u6b63\u5728\u521b\u5efa\u79fb\u52a8\u7ad9\u70b9";
        WebSite srcWebSite = WebSite.findById(_srcSiteId);
        if (srcWebSite == null) {
            throw new WCMException("\u4f20\u5165\u7684\u7ad9\u70b9Id\u3010" + _srcSiteId + "\u3011\u65e0\u6548.");
        }
        WebSite newWebSite = (WebSite)srcWebSite.cloneToNewObj();
        newWebSite.setName(newWebSite.getName() + "-mobile");
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        String sNewName = m_oNameGenerator.generate(newWebSite, "SITENAME", newWebSite.getName());
        newWebSite.setName(sNewName);
        newWebSite.setDesc(newWebSite.getDesc() + "-\u79fb\u52a8\u95e8\u6237");
        newWebSite.setOrder(newWebSite.getOrder() + 1);
        newWebSite.setMobile(true);
        newWebSite.setCrUser(this.getLoginUser());
        newWebSite.save(this.getLoginUser());
        int nNewSiteId = newWebSite.getId();
        IPublishElement srcPublishElement = PublishElementFactory.lookupElement(103, _srcSiteId);
        WCMFolderPublishConfig srcPublishConfig = new WCMFolderPublishConfig((IPublishFolder)srcPublishElement);
        String sRootDomain = srcPublishConfig.getRootDomain();
        String sDataPath = srcPublishConfig.getDataPath();
        sRootDomain = sRootDomain.lastIndexOf("/") == sRootDomain.length() - 1 ? sRootDomain.substring(0, sRootDomain.length() - 1) : sRootDomain;
        sRootDomain = sRootDomain.substring(0, sRootDomain.lastIndexOf("/") + 1);
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter filter = new WCMFilter("", "FolderType=?", "");
        filter.addSearchValues(103);
        sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", sDataPath + "mobile", filter);
        String sServiceId = "wcm6_publish";
        String sMethodName = "saveSitePublishConfig";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("OBJECTID", nNewSiteId);
        this.serviceMap.put("SITETYPE", newWebSite.getType());
        this.serviceMap.put("DATAPATH", sDataPath);
        this.serviceMap.put("SITELANGUAGE", "8");
        this.serviceMap.put("PAGEENCODING", "utf-8");
        this.serviceMap.put("ROOTDOMAIN", sRootDomain + sDataPath);
        this.serviceMap.put("STATUSESCANDOPUB", CMyString.join(this.m_nStatusOfCanPub, ","));
        this.serviceMap.put("STATUSIDAFTERMODIFY", "1");
        try {
            this.processor.excute(sServiceId, sMethodName, this.serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u521b\u5efa\u7ad9\u70b9\u53d1\u5e03\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
        return nNewSiteId;
    }

    private void importTemplate(int _nSiteId, String _sTemlateType) throws CMyException {
        String sTemplateDataPath;
        String sTempPath;
        m_sMessage = "\u6b63\u5728\u5bfc\u5165\u7ad9\u70b9\u6a21\u677f";
        String sMobileDataPath = this.getMobileDataPath();
        String sTemplateFileName = m_sTemplateFile + ".zip";
        String sTemplateDataFileBak = m_sTemplateFile + "_bak.zip";
        if (!CMyString.isEmpty(_sTemlateType) && CMyFile.fileExists(sMobileDataPath + m_sTemplateFile + _sTemlateType + ".zip")) {
            sTemplateFileName = m_sTemplateFile + _sTemlateType + ".zip";
            sTemplateDataFileBak = m_sTemplateFile + _sTemlateType + "_bak.zip";
        }
        if (!CMyFile.fileExists(sTempPath = (sTemplateDataPath = sMobileDataPath + sTemplateFileName) + "datatemp")) {
            CMyFile.makeDir(sTempPath, true);
        }
        sTemplateDataFileBak = sTempPath + File.separator + sTemplateDataFileBak;
        try {
            if (!CMyFile.fileExists(sTemplateDataPath)) {
                throw new WCMException("\u79fb\u52a8\u95e8\u6237\u7684\u6a21\u677f\u6587\u4ef6\u5305\u4e0d\u5b58\u5728\uff01\u3010" + sTemplateDataPath + "\u3011");
            }
            CMyFile.copyFile(sTemplateDataPath, sTemplateDataFileBak);
            String sServiceId = "wcm6_template";
            String sMethodName = "importTemplates";
            this.processor.reset();
            this.serviceMap.clear();
            this.serviceMap.put("IMPORTFILE", sTemplateDataFileBak);
            this.serviceMap.put("SRCFILENAME", "TEMPLATE--MOBILEPORTAL.zip");
            this.serviceMap.put("IMPORTMODE", 1);
            this.serviceMap.put("PICMODE", 1);
            this.serviceMap.put("HOSTID", _nSiteId);
            this.serviceMap.put("HOSTTYPE", 103);
            this.serviceMap.put("FILEENCODE", "utf-8");
            this.processor.excute(sServiceId, sMethodName, this.serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u5bfc\u5165\u6a21\u677f\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
        finally {
            CMyFile.deleteDir(sTempPath);
        }
        m_oTemplats = null;
    }

    private void configSiteTemplate(int nSiteId) throws WCMException {
        m_sMessage = "\u6b63\u5728\u914d\u7f6e\u7ad9\u70b9\u6a21\u677f";
        String sOutlineTemplateIds = this.getSiteOutLineTemplatesIds(nSiteId);
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, nSiteId);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, sOutlineTemplateIds, false);
    }

    private Templates getSiteAllTemplates(int _nSiteId) throws WCMException {
        if (m_oTemplats != null) {
            return m_oTemplats;
        }
        IPublishFolder publishFolder = (IPublishFolder)PublishElementFactory.lookupElement(103, _nSiteId);
        TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        m_oTemplats = m_oTemplateMgr.getManagedTemplates(publishFolder, -1, null, true);
        return m_oTemplats;
    }

    private String getSiteOutLineTemplatesIds(int _siteId) throws WCMException {
        String sTemplateName;
        Template template;
        int i;
        Templates templates = this.getSiteAllTemplates(_siteId);
        StringBuffer outlineTemplateIds = new StringBuffer();
        for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            if (!m_sSiteOutlineTemplateNames[0].equals(sTemplateName)) continue;
            outlineTemplateIds.append(template.getId());
        }
        block1: for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            for (int k = 1; k < m_sSiteOutlineTemplateNames.length; ++k) {
                if (!m_sSiteOutlineTemplateNames[k].equals(sTemplateName)) continue;
                if (CMyString.isEmpty(outlineTemplateIds.toString())) {
                    outlineTemplateIds.append(template.getId());
                    continue block1;
                }
                outlineTemplateIds.append("," + template.getId());
                continue block1;
            }
        }
        return outlineTemplateIds.toString();
    }

    private String getChannelOutLineTemplatesIds(int _siteId, String[] sOutLineTempNames) throws WCMException {
        String sTemplateName;
        Template template;
        int i;
        Templates templates = this.getSiteAllTemplates(_siteId);
        StringBuffer outlineTemplateIds = new StringBuffer();
        for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            if (!sOutLineTempNames[0].equals(sTemplateName)) continue;
            outlineTemplateIds.append(template.getId());
        }
        block1: for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            for (int k = 1; k < sOutLineTempNames.length; ++k) {
                if (!sOutLineTempNames[k].equals(sTemplateName)) continue;
                if (CMyString.isEmpty(outlineTemplateIds.toString())) {
                    outlineTemplateIds.append(template.getId());
                    continue block1;
                }
                outlineTemplateIds.append("," + template.getId());
                continue block1;
            }
        }
        return outlineTemplateIds.toString();
    }

    private int getDetailTemplateId(int _siteId) throws WCMException {
        Templates templates = this.getSiteAllTemplates(_siteId);
        int nTemplateId = 0;
        String[] detailTemplateNames = m_sDetailTemplateNames.split(",");
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            String sTemplateName = template.getName();
            if (this.m_bWJBhd) {
                if (sTemplateName.equals(detailTemplateNames[1])) {
                    nTemplateId = template.getId();
                }
            } else if (sTemplateName.equals(detailTemplateNames[0])) {
                nTemplateId = template.getId();
            }
            if (nTemplateId > 0) break;
        }
        return nTemplateId;
    }

    private void makeMobileChnls(int _nSrcSiteId, int _nMobileSiteId, String _sDelChnlIds) throws CMyException {
        User loginUser = this.getLoginUser();
        int[] nDelIds = null;
        if (!CMyString.isEmpty(_sDelChnlIds)) {
            nDelIds = CMyString.splitToInt(_sDelChnlIds, ",");
        }
        WebSite srcSite = WebSite.findById(_nSrcSiteId);
        List<Channel> childChnls = srcSite.getChildren(loginUser);
        for (int i = 0; i < childChnls.size(); ++i) {
            Channel currChannel = childChnls.get(i);
            this.makeChnlSelfAndchildren(null, currChannel, _nMobileSiteId, nDelIds, true);
        }
    }

    private int makeChnlSelfAndchildren(BaseChannel _parentChannel, Channel _currchannel, int _siteId, int[] nDelChnlIds, boolean bContainChildren) throws CMyException {
        if (_currchannel == null) {
            return 0;
        }
        if (this.isIgnore(_currchannel, nDelChnlIds)) {
            return 0;
        }
        Channel mobileChannel = this.makeOneMobileChannel(_parentChannel, _currchannel, _siteId, nDelChnlIds);
        if (bContainChildren) {
            List<Channel> children = _currchannel.getChildren(this.getLoginUser());
            for (int i = 0; i < children.size(); ++i) {
                Channel channel = children.get(i);
                this.makeChnlSelfAndchildren(mobileChannel, channel, _siteId, nDelChnlIds, bContainChildren);
            }
        }
        return mobileChannel.getId();
    }

    private boolean isContainChildren(Channel _currChnl, int[] nDelChnlIds) throws WCMException {
        List<Channel> children = _currChnl.getChildren(ContextHelper.getLoginUser(), 0);
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            Channel child = children.get(i);
            if (this.isIgnore(child, nDelChnlIds)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnore(Channel _currChnl, int[] _nDelChnlIds) {
        if (_currChnl.getType() != 0) {
            return true;
        }
        if (_currChnl.isOnlySearch()) {
            return true;
        }
        int currChnlId = _currChnl.getId();
        if (_nDelChnlIds == null) {
            return false;
        }
        for (int i = 0; i < _nDelChnlIds.length; ++i) {
            int delChnlId = _nDelChnlIds[i];
            if (delChnlId != currChnlId) continue;
            return true;
        }
        return false;
    }

    private Channel makeOneMobileChannel(BaseChannel _parentChannel, Channel _srcchannel, int _siteId, int[] nDelChnlIds) throws CMyException {
        Channel mobileChannel = (Channel)_srcchannel.cloneToNewObj();
        m_sMessage = "\u6b63\u5728\u4e3a\u680f\u76ee\u3010" + mobileChannel.getName() + "\u3011\u521b\u5efa\u79fb\u52a8\u680f\u76ee";
        mobileChannel.setSite(_siteId);
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        WCMFilter filter = new WCMFilter("", "siteid=?", "");
        filter.addSearchValues(_siteId);
        String sNewName = m_oNameGenerator.generate(mobileChannel, "CHNLNAME", mobileChannel.getName(), filter);
        mobileChannel.setName(sNewName);
        int nParentId = 0;
        if (_parentChannel != null && _parentChannel instanceof Channel) {
            nParentId = _parentChannel.getId();
        }
        mobileChannel.setParent(nParentId);
        this.setChannelListType(_srcchannel, mobileChannel, nParentId, nDelChnlIds);
        mobileChannel.setCrUser(this.getLoginUser());
        mobileChannel.setPropertyWithString("ContentAddEditPage", "../document/document_addedit.jsp");
        mobileChannel.setPropertyWithString("ContentShowPage", "../document/document_detail.jsp");
        mobileChannel.setPropertyWithString("ContentListPage", "../document/document_list.html");
        mobileChannel.setQuery("");
        mobileChannel.save();
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(_srcchannel);
        if (view != null) {
            this.m_oMetaViewEmployerMgr.setEmployer(this.getLoginUser(), mobileChannel, view);
        }
        int mobileChannelId = mobileChannel.getId();
        IPublishElement srcPublishElement = PublishElementFactory.lookupElement(101, _srcchannel.getId());
        WCMFolderPublishConfig srcPublishConfig = new WCMFolderPublishConfig((IPublishFolder)srcPublishElement);
        String sDataPath = srcPublishConfig.getDataPath();
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter dataPathfilter = new WCMFilter("", "FolderType=?", "");
        dataPathfilter.addSearchValues(101);
        sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", sDataPath, dataPathfilter);
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, mobileChannelId);
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, mobileChannelId);
        currPublishConfig.setDataPath(sDataPath);
        currPublishConfig.canEdit(this.getLoginUser());
        currPublishConfig.save(this.getLoginUser());
        m_sMessage = "\u6b63\u5728\u4e3a\u680f\u76ee\u3010" + mobileChannel.getName() + "\u3011\u7684\u79fb\u52a8\u680f\u76ee\u914d\u7f6e\u6a21\u677f";
        this.configChannelTemplate(mobileChannelId, _siteId, m_sChnlOutlineTemplateNames);
        m_sMessage = "\u6b63\u5728\u4e3a\u680f\u76ee\u3010" + mobileChannel.getName() + "\u3011\u540c\u6b65\u6570\u636e";
        this.setChannelSyn(_srcchannel.getId(), mobileChannelId);
        return mobileChannel;
    }

    private void setChannelListType(Channel _srcchannel, Channel _mobielChannel, int nParentId, int[] nDelChnlIds) throws WCMException {
        if (this.m_bWJBhd) {
            if (nParentId == 0) {
                WebSite site = _mobielChannel.getSite();
                if (site.getChildren(this.getLoginUser()).size() == 1) {
                    _mobielChannel.setAttribute("LISTTYPE", "6");
                    return;
                }
                _mobielChannel.setAttribute("LISTTYPE", "5");
                return;
            }
            Channel parentChannel = Channel.findById(nParentId);
            if (parentChannel.getParentId() == 0 && parentChannel.getChildren(this.getLoginUser()).size() == 0) {
                _mobielChannel.setAttribute("LISTTYPE", "13");
            } else {
                _mobielChannel.setAttribute("LISTTYPE", "1");
            }
            return;
        }
        boolean bHasNormalChild = this.isContainChildren(_srcchannel, nDelChnlIds);
        if (nParentId == 0) {
            if (bHasNormalChild) {
                _mobielChannel.setAttribute("LISTTYPE", "0");
            } else {
                _mobielChannel.setAttribute("LISTTYPE", "1");
            }
        } else {
            _mobielChannel.setAttribute("LISTTYPE", "1");
        }
    }

    private void setChannelSyn(int _channelId, int _targetChnlId) throws CMyException {
        String sServiceId = "wcm6_documentSyn";
        String sMethodName = "save";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("ObjectId", 0);
        this.serviceMap.put("CHANNELID", _channelId);
        this.serviceMap.put("DSTCHANNELIDS", _targetChnlId);
        this.serviceMap.put("CHANNELASTARGET", false);
        CMyDateTime currDateTime = CMyDateTime.now();
        String sCurrDate = currDateTime.toString("yyyy-MM-dd");
        CMyDateTime beforeTenYearDateTime = currDateTime.dateAdd(1, -10);
        String sBeforeTenYearDateTime = beforeTenYearDateTime.toString("yyyy-MM-dd");
        CMyDateTime afterTenYearDateTime = currDateTime.dateAdd(1, 20);
        String sAfterTenYearDateTime = beforeTenYearDateTime.toString("yyyy-MM-dd");
        this.serviceMap.put("SDATE", sCurrDate);
        this.serviceMap.put("EDATE", sAfterTenYearDateTime);
        this.serviceMap.put("DOCSDATE", this.m_sDocSDate);
        this.serviceMap.put("DOCEDATE", sBeforeTenYearDateTime);
        this.serviceMap.put("SYNTYPES", "PUBLISH");
        this.serviceMap.put("ATTRIBUTE", "TransmitType=3");
        this.serviceMap.put("TRANSMITTYPEASS", "3");
        this.serviceMap.put("OPERAFTER", "1");
        this.serviceMap.put("STATUSES", CMyString.join(this.m_nStatusOfCanPub, ","));
        this.serviceMap.put("STATUSESASS", CMyString.join(this.m_nStatusOfCanPub, ","));
        int nSynId = 0;
        try {
            Integer result = (Integer)this.processor.excute(sServiceId, sMethodName, this.serviceMap);
            nSynId = result;
        }
        catch (WCMException e) {
            throw new WCMException("\u521b\u5efa\u6587\u6863\u540c\u6b65\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
        if (nSynId <= 0) {
            return;
        }
        sServiceId = "wcm61_docsyn";
        sMethodName = "synUndoContent";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("ObjectIds", nSynId);
        try {
            this.processor.excute(sServiceId, sMethodName, this.serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u540c\u6b65\u6587\u6863\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
    }

    private void configChannelTemplate(int _chnlId, int _siteId, String[] sOutLineTempNames) throws WCMException {
        String sOutlineTemplateIds = this.getChannelOutLineTemplatesIds(_siteId, sOutLineTempNames);
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, _chnlId);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, sOutlineTemplateIds, false);
        int nDetailTemplateId = this.getDetailTemplateId(_siteId);
        this.m_oEmployMgr.setDetailTemplate((IPublishFolder)publishElement, nDetailTemplateId, false);
    }

    private void fullPublishSite(int _siteId) throws WCMException {
        m_sMessage = "\u6b63\u5728\u5b8c\u5168\u53d1\u5e03\u79fb\u52a8\u7ad9\u70b9\uff01";
        String sServiceId = "wcm6_publish";
        String sMethodName = "fullyPublish";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("OBJECTIDS", _siteId);
        this.serviceMap.put("OBJECTTYPE", 103);
        try {
            this.processor.excute(sServiceId, sMethodName, this.serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u5b8c\u5168\u53d1\u5e03\u7ad9\u70b9\u51fa\u73b0\u5f02\u5e38\uff01");
        }
    }

    private void createSpecialChannel(int _nSiteId, boolean _bCreateMsgPush, boolean _bCreateWB) throws WCMException {
        if (_bCreateMsgPush) {
            this.createOneSpecialChannel(m_sPushMsgChnlName, _nSiteId, 0, m_sPushMsgChnlPath, m_sPushMsgOutlineTemplateNames, 1);
        }
        if (_bCreateWB) {
            WebSite website = WebSite.findById(_nSiteId);
            if (website == null) {
                return;
            }
            int nParentId = 0;
            List<Channel> children = website.getChildren(this.getLoginUser());
            if (children.size() > 0) {
                BaseChannel parentChannel = children.get(0);
                nParentId = parentChannel.getId();
            }
            this.createOneSpecialChannel(m_sWBChnlName, _nSiteId, nParentId, m_sWBChnlPath, m_sChnlOutlineTemplateNames, 11);
        }
    }

    private void createOneSpecialChannel(String _sName, int _nSiteId, int _nParent, String _sDataPath, String[] outlineTempNames, int _listType) throws WCMException {
        Channel channel = Channel.createNewInstance();
        channel.setName(_sName);
        channel.setDesc(_sName);
        channel.setSite(_nSiteId);
        channel.setParent(_nParent);
        channel.setCrUser(this.getLoginUser());
        channel.setCanPub(true);
        channel.setAttribute("LISTTYPE", _listType + "");
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        WCMFilter filter = new WCMFilter("", "siteid=?", "");
        filter.addSearchValues(_nSiteId);
        String sNewName = m_oNameGenerator.generate(channel, "CHNLNAME", channel.getName(), filter);
        channel.setName(sNewName);
        channel.save();
        int nChannelId = channel.getId();
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, nChannelId);
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, nChannelId);
        currPublishConfig.setDataPath(_sDataPath);
        currPublishConfig.canEdit(this.getLoginUser());
        currPublishConfig.save(this.getLoginUser());
        this.configChannelTemplate(nChannelId, _nSiteId, outlineTempNames);
    }

    private void createLogoForLevelOneChnl(int _nSiteId) throws WCMException {
        User loginUser = this.getLoginUser();
        String sDataPath = this.getMobileDataPath();
        WebSite website = WebSite.findById(_nSiteId);
        List<Channel> children = website.getChildren(loginUser);
        int nSize = children.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = children.get(i);
            if (i > 2) break;
            String sLogoFilePath = sDataPath + m_sDefaultLogo[i];
            this.createLogoForChnl(channel, sLogoFilePath);
        }
    }

    private void createLogoForChnl(Channel channel, String sLocalLogoPath) throws WCMException {
        if (!CMyFile.fileExists(sLocalLogoPath)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sNewFileName = filesMan.getNextFileName("U0", CMyFile.extractFileExt(sLocalLogoPath));
        String sNewFilePath = filesMan.mapFilePath(sNewFileName, 0) + sNewFileName;
        try {
            CMyFile.copyFile(sLocalLogoPath, sNewFilePath);
        }
        catch (Exception e) {
            throw new WCMException("\u4fdd\u5b58\u6587\u4ef6[" + sLocalLogoPath + "]-->[" + sNewFilePath + "]\u5931\u8d25\uff01", e);
        }
        Logo currLogo = Logo.createNewInstance();
        currLogo.setHostId(channel.getId());
        currLogo.setHostType(101);
        currLogo.setFileName(sNewFileName);
        currLogo.save();
    }

    private String getMobileDataPath() throws WCMException {
        String sAppDir = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if ("\\".equals(File.separator)) {
            sAppDir = CMyString.replaceStr(sAppDir, "/", File.separator);
        }
        if ((sAppDir = CMyString.setStrEndWith(sAppDir, File.separatorChar)) == null || sAppDir.trim().equals("")) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u6240\u5728\u8def\u5f84\uff01");
        }
        String sMobileDataPath = sAppDir + "app" + File.separator + "mobile" + File.separator + "data" + File.separator;
        return sMobileDataPath;
    }

    @Override
    public void createMobileChannel(MethodContext _context) throws WCMException {
        if (!PluginConfig.isStartMobilePortal()) {
            throw new WCMException("\u60a8\u6ca1\u6709\u8d2d\u4e70\u79fb\u52a8\u95e8\u6237\uff01");
        }
        if (BPROCESSING) {
            return;
        }
        BPROCESSING = true;
        User loginUser = this.getLoginUser();
        int nSrcChnlId = _context.getValue("SrcChnlId", 0);
        int nDestHostId = _context.getValue("DestHostId", 0);
        int nDestHostType = _context.getValue("DestHostType", 0);
        boolean bContainChildren = _context.getValue("ContainChildren", false);
        try {
            Channel srcChannel = Channel.findById(nSrcChnlId);
            if (srcChannel == null) {
                throw new WCMException("\u65e0\u6cd5\u627e\u5230id\u4e3a\u3010" + nSrcChnlId + "\u3011\u7684\u680f\u76ee.");
            }
            if (!AuthServer.hasRight(loginUser, (CMSObj)srcChannel, 13)) {
                throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8[" + loginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u4ece\u680f\u76ee[" + srcChannel.getName() + "]\u521b\u5efa\u79fb\u52a8\u680f\u76ee.");
            }
            WebSite destSite = null;
            BaseChannel parentChannel = null;
            if (103 == nDestHostType) {
                destSite = WebSite.findById(nDestHostId);
                parentChannel = destSite;
            } else if (101 == nDestHostType) {
                parentChannel = Channel.findById(nDestHostId);
                if (parentChannel == null) {
                    throw new WCMException("\u65e0\u6cd5\u627e\u5230id\u4e3a\u3010" + nDestHostId + "\u3011\u7684\u680f\u76ee.");
                }
                destSite = parentChannel.getSite();
            }
            if (destSite == null) {
                throw new WCMException("\u65e0\u6cd5\u627e\u5230id\u4e3a\u3010" + nDestHostId + "\u3011\u7684\u7ad9\u70b9.");
            }
            if (!AuthServer.hasRight(loginUser, (CMSObj)parentChannel, 11)) {
                throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8[" + loginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u5728[" + parentChannel.getName() + "]\u4e0a\u521b\u5efa\u680f\u76ee.");
            }
            this.setDocSynTime(_context.getValue("DocSDate"));
            int nNewChannelId = this.makeChnlSelfAndchildren(parentChannel, srcChannel, destSite.getId(), null, bContainChildren);
            Channel mobileChannel = Channel.findById(nNewChannelId);
            if (mobileChannel == null) {
                return;
            }
            m_sMessage = "\u6b63\u5728\u5b8c\u5168\u53d1\u5e03\u79fb\u52a8\u680f\u76ee\uff01";
            String sServiceId = "wcm6_publish";
            String sMethodName = "fullyPublish";
            this.processor.reset();
            this.serviceMap.clear();
            this.serviceMap.put("OBJECTIDS", nNewChannelId);
            this.serviceMap.put("OBJECTTYPE", 101);
            try {
                this.processor.excute(sServiceId, sMethodName, this.serviceMap);
            }
            catch (WCMException e) {
                throw new WCMException("\u5b8c\u5168\u53d1\u5e03\u680f\u76ee\u51fa\u73b0\u5f02\u5e38\uff01");
            }
        }
        catch (Exception e) {
            throw new WCMException("\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u680f\u76ee\u51fa\u73b0\u5f02\u5e38!", e);
        }
        finally {
            BPROCESSING = false;
            m_sMessage = "-1";
            this.m_sDocSDate = "";
        }
    }

    @Override
    public String getCurrMessage(MethodContext _context) {
        return m_sMessage;
    }

    @Override
    public boolean isCanCreateMobile(MethodContext _context) throws WCMException {
        WebSite webSite;
        if (!PluginConfig.isStartMobilePortal()) {
            return false;
        }
        int nObjId = _context.getValue("ObjectId", 0);
        int nObjType = _context.getValue("ObjectType", 0);
        if (nObjType == 101) {
            Channel channel = Channel.findById(nObjId);
            if (channel == null) {
                return false;
            }
            if (channel.getType() != 0 || channel.isOnlySearch()) {
                return false;
            }
            WebSite site = channel.getSite();
            if (site == null || site.isMobile()) {
                return false;
            }
        } else if (nObjType == 103 && ((webSite = WebSite.findById(nObjId)) == null || webSite.isMobile())) {
            return false;
        }
        return true;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public boolean isMobileObject(MethodContext _context) throws WCMException {
        int nObjId = _context.getValue("ObjectId", 0);
        int nObjType = _context.getValue("ObjectType", 0);
        WebSite webSite = null;
        if (nObjType == 605) {
            ChnlDoc chnlDoc = ChnlDoc.findById(nObjId);
            if (chnlDoc == null) {
                return false;
            }
            Channel channel = chnlDoc.getChannel();
            if (channel == null) {
                return false;
            }
            webSite = channel.getSite();
        } else if (nObjType == 101) {
            Channel channel = Channel.findById(nObjId);
            if (channel == null) {
                return false;
            }
            webSite = channel.getSite();
        } else if (nObjType == 103) {
            webSite = WebSite.findById(nObjId);
        } else {
            return false;
        }
        return webSite != null && webSite.isMobile();
    }
}

