/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.logger;

import com.trs.cms.logger.LogInfo;
import com.trs.cms.logger.ObjLoggerBase;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.infra.persistent.BaseObj;
import java.util.Map;

public class TemplateEmployLogger
extends ObjLoggerBase {
    private static final String KEY = "TEMPLATEID";

    @Override
    public int getLogObjType() {
        return 953;
    }

    @Override
    protected Map getMajorKeys() {
        return null;
    }

    @Override
    protected String getObjName(BaseObj object) {
        StringBuffer buff = new StringBuffer(64);
        TemplateEmploy employ = (TemplateEmploy)object;
        if (employ.getTemplateType() == 2) {
            buff.append("\u7ec6\u89c8\u6a21\u677f\u914d\u7f6e");
        } else if (employ.isDefault() || employ.getNewPropertyAsInt("ISDEFAULT", 0) == 1) {
            buff.append("\u9996\u9875\u6a21\u677f\u914d\u7f6e");
        } else {
            buff.append("\u5176\u5b83\u6982\u89c8\u914d\u7f6e");
        }
        buff.append("[TemplateId=").append(employ.getTemplateId()).append("]");
        return buff.toString();
    }

    @Override
    public LogInfo makeLogOnAdd(BaseObj newobj) {
        String sObjName = this.getObjName(newobj);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u65b0\u5efa");
        this.appendEmployerInfo(detail, newobj);
        detail.append(sObjName);
        detail.append(", \u914d\u7f6e\u7684\u6a21\u677f\u662f");
        int nId = newobj.getPropertyAsInt(KEY, 0);
        try {
            detail.append(Template.findById(nId));
        }
        catch (Exception ex) {
            detail.append("ID=").append(nId);
        }
        return new LogInfo(this.getAddOpType(newobj), sObjName, detail.toString());
    }

    private void appendEmployerInfo(StringBuffer buff, BaseObj object) {
        TemplateEmploy employ = (TemplateEmploy)object;
        try {
            buff.append(employ.getEmployer().getInfo());
        }
        catch (Exception ex) {
            buff.append("EmployerType=");
            buff.append(employ.getEmployerType());
            buff.append(", EmployerId=");
            buff.append(employ.getEmployerId());
        }
        buff.append("\u7684");
    }

    @Override
    public LogInfo makeLogOnDel(BaseObj objdeleted) {
        String sObjName = this.getObjName(objdeleted);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u5220\u9664");
        this.appendEmployerInfo(detail, objdeleted);
        detail.append(sObjName);
        detail.append(", \u914d\u7f6e\u7684\u6a21\u677f\u662f");
        int nId = objdeleted.getPropertyAsInt(KEY, 0);
        try {
            detail.append(Template.findById(nId));
        }
        catch (Exception ex) {
            detail.append("ID=").append(nId);
        }
        return new LogInfo(this.getDeleteOpType(objdeleted), sObjName, detail.toString());
    }

    @Override
    public LogInfo makeLogOnModify(BaseObj objmodified) {
        if (!objmodified.isChangeProperty(KEY)) {
            return null;
        }
        String name = this.getObjName(objmodified);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u4fee\u6539");
        this.appendEmployerInfo(detail, objmodified);
        detail.append("\u6a21\u677f: ");
        int nOldId = objmodified.getPropertyAsInt(KEY, 0);
        int nNewId = objmodified.getNewPropertyAsInt(KEY, 0);
        try {
            detail.append(Template.findById(nOldId));
            detail.append(" --> ");
            detail.append(Template.findById(nNewId));
        }
        catch (Exception ex) {
            detail.append(nOldId).append(" --> ").append(nNewId);
        }
        return new LogInfo(this.getModifyOpType(objmodified), name, detail.toString());
    }

    @Override
    public String getClassDesc() {
        return "\u6a21\u677f\u914d\u7f6e\u65e5\u5fd7\u7c7b";
    }
}

