/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.logger;

import com.trs.cms.logger.LogInfo;
import com.trs.cms.logger.ObjLoggerBase;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.infra.persistent.BaseObj;
import java.util.Map;

public class FlowEmployLogger
extends ObjLoggerBase {
    private static final String KEY = "FLOWID";

    @Override
    public int getLogObjType() {
        return 30001;
    }

    @Override
    protected Map getMajorKeys() {
        return null;
    }

    @Override
    protected String getObjName(BaseObj object) {
        return "\u5de5\u4f5c\u6d41\u914d\u7f6e";
    }

    @Override
    public LogInfo makeLogOnAdd(BaseObj newobj) {
        String sObjName = this.getObjName(newobj);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u65b0\u5efa");
        this.appendEmployerInfo(detail, newobj);
        detail.append(sObjName);
        detail.append(", \u914d\u7f6e\u7684\u5de5\u4f5c\u6d41\u662f");
        int nId = newobj.getPropertyAsInt(KEY, 0);
        try {
            detail.append(Flow.findById(nId));
        }
        catch (Exception ex) {
            detail.append("ID=").append(nId);
        }
        return new LogInfo(this.getAddOpType(newobj), sObjName, detail.toString());
    }

    private void appendEmployerInfo(StringBuffer buff, BaseObj object) {
        FlowEmploy employ = (FlowEmploy)object;
        try {
            buff.append(employ.getEmployer());
        }
        catch (Exception ex) {
            buff.append("EmployerType=");
            buff.append(employ.getEmployerType());
            buff.append(", EmployerId=");
            buff.append(employ.getEmployerId());
        }
        buff.append("\u7684");
    }

    @Override
    public LogInfo makeLogOnDel(BaseObj objdeleted) {
        String sObjName = this.getObjName(objdeleted);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u5220\u9664");
        this.appendEmployerInfo(detail, objdeleted);
        detail.append(sObjName);
        detail.append(", \u914d\u7f6e\u7684\u5de5\u4f5c\u6d41\u662f");
        int nId = objdeleted.getPropertyAsInt(KEY, 0);
        try {
            detail.append(Flow.findById(nId));
        }
        catch (Exception ex) {
            detail.append("ID=").append(nId);
        }
        return new LogInfo(this.getDeleteOpType(objdeleted), sObjName, detail.toString());
    }

    @Override
    public LogInfo makeLogOnModify(BaseObj objmodified) {
        if (!objmodified.isChangeProperty(KEY)) {
            return null;
        }
        String name = this.getObjName(objmodified);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u4fee\u6539");
        this.appendEmployerInfo(detail, objmodified);
        detail.append("\u5de5\u4f5c\u6d41: ");
        int nOldId = objmodified.getPropertyAsInt(KEY, 0);
        int nNewId = objmodified.getNewPropertyAsInt(KEY, 0);
        try {
            detail.append(Flow.findById(nOldId));
            detail.append(" --> ");
            detail.append(Flow.findById(nNewId));
        }
        catch (Exception ex) {
            detail.append(nOldId).append(" --> ").append(nNewId);
        }
        return new LogInfo(this.getModifyOpType(objmodified), name, detail.toString());
    }

    @Override
    public String getClassDesc() {
        return "\u5de5\u4f5c\u6d41\u914d\u7f6e\u65e5\u5fd7\u7c7b";
    }
}

