/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class FilterOption
extends CMSObj {
    public static final int OBJ_TYPE = 158294668;
    public static final String DB_TABLE_NAME = "XWCMFILTEROPTION";
    public static final String DB_ID_NAME = "FILTEROPTIONID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 158294668;
    }

    public String getOptionName() {
        return this.getPropertyAsString("OPTIONNAME");
    }

    public boolean setOptionName(String _sOptionName) throws WCMException {
        return this.setProperty("OPTIONNAME", _sOptionName);
    }

    public String getOptionDesc() {
        return this.getPropertyAsString("OPTIONDESC");
    }

    public boolean setOptionDesc(String _sOptionDesc) throws WCMException {
        return this.setProperty("OPTIONDESC", _sOptionDesc);
    }

    public String getSearchCondition() {
        return this.getPropertyAsString("SEARCHCONDITION");
    }

    public boolean setSearchCondition(String _sSearchCondition) throws WCMException {
        return this.setProperty("SEARCHCONDITION", _sSearchCondition);
    }

    public String getNotAllowedSelectOptions() {
        return this.getPropertyAsString("NOTALLOWEDSELECTOPTIONS");
    }

    public boolean setNotAllowedSelectOptions(String _sNotAllowedSelectOptions) throws WCMException {
        return this.setProperty("NOTALLOWEDSELECTOPTIONS", _sNotAllowedSelectOptions);
    }

    public String getFirstPic() {
        return this.getPropertyAsString("FIRSTPIC");
    }

    public boolean setFirstPic(String _sFirstPic) throws WCMException {
        return this.setProperty("FIRSTPIC", _sFirstPic);
    }

    public String getSecondPic() {
        return this.getPropertyAsString("SECONDPIC");
    }

    public boolean setSecondPic(String _sSecondPic) throws WCMException {
        return this.setProperty("SECONDPIC", _sSecondPic);
    }

    public String getThirdPic() {
        return this.getPropertyAsString("THIRDPIC");
    }

    public boolean setThirdPic(String _sThirdPic) throws WCMException {
        return this.setProperty("THIRDPIC", _sThirdPic);
    }

    public int getGroupId() {
        return this.getPropertyAsInt("GROUPID", 0);
    }

    public boolean setGroupId(int _nGroupId) throws WCMException {
        return this.setProperty("GROUPID", _nGroupId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("FORDER", 0);
    }

    public boolean setOrder(int _nFOrder) throws WCMException {
        return this.setProperty("FORDER", _nFOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOption.class, "FilterOption.label1", "\u5c5e\u6027OptionName\u6ca1\u6709\u8bbe\u7f6e(FilterOption.isValid)"));
            }
            if (this.getProperty("GROUPID") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOption.class, "FilterOption.label2", "\u5c5e\u6027GroupId\u6ca1\u6709\u8bbe\u7f6e(FilterOption.isValid)"));
            }
            if (this.getProperty("FORDER") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOption.class, "FilterOption.label3", "\u5c5e\u6027FOrder\u6ca1\u6709\u8bbe\u7f6e(FilterOption.isValid)"));
            }
        } else {
            String sOriginalFileName;
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(FilterOption.class, "FilterOption.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FilterOption.isValid)"));
            }
            if (this.isChangeProperty("FIRSTPIC") && !CMyString.isEmpty(sOriginalFileName = this.getFirstPic())) {
                this.deleteOldPic(sOriginalFileName);
            }
            if (this.isChangeProperty("SECONDPIC") && !CMyString.isEmpty(sOriginalFileName = this.getSecondPic())) {
                this.deleteOldPic(sOriginalFileName);
            }
            if (this.isChangeProperty("THIRDPIC") && !CMyString.isEmpty(sOriginalFileName = this.getThirdPic())) {
                this.deleteOldPic(sOriginalFileName);
            }
        }
        this.changeOrder();
        return true;
    }

    private void deleteOldPic(String _sFileName) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sDstFilePath = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
        CMyFile.deleteFile(sDstFilePath);
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    @Override
    public int delete() throws WCMException {
        this.deleteRelationFiles();
        return super.delete();
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        this.deleteRelationFiles();
        return super.delete(_currUser);
    }

    private void deleteRelationFiles() throws WCMException {
        String sFileName = this.getFirstPic();
        this.deleteFile(sFileName);
        sFileName = this.getSecondPic();
        this.deleteFile(sFileName);
        sFileName = this.getThirdPic();
        this.deleteFile(sFileName);
    }

    private void deleteFile(String _sFileName) throws WCMException {
        if (!CMyString.isEmpty(_sFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sDstFilePath = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
            CMyFile.deleteFile(sDstFilePath);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("FORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("FORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "FORDER>=" + nMoveBeginAt + " AND FORDER <= " + nMoveEndAt + " and GROUPID=" + this.getGroupId();
        String sMoveSql = "UPDATE XWCMFILTEROPTION SET FORDER = FORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(FORDER) from XWCMFILTEROPTION where GROUPID=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(FORDER) from XWCMFILTEROPTION where GROUPID=?", new int[]{this.getGroupId()});
    }

    public static final FilterOption findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (FilterOption)BaseObj.findById(FilterOption.class, _nId);
    }

    public static final FilterOption createNewInstance() throws WCMException {
        return (FilterOption)BaseObj.createNewInstance(FilterOption.class);
    }

    public static final FilterOption findByKey(Object _oKey) throws WCMException {
        return (FilterOption)BaseObj.findByKey(FilterOption.class, _oKey);
    }
}

