/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.html.HtmlUtil;
import org.apache.log4j.Logger;

public class TagPreNextParser
implements ITagParser {
    private static Logger s_logger = Logger.getLogger(TagPreNextParser.class);
    private static TagBeanInfo s_oTagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_oTagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_PRENEXT");
            tbi.setDesc("TRS_PRENEXT");
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("ISURLABS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("PAGENUM");
            tbi.addAttrInfo(tbai);
            s_oTagBeanInfo = tbi;
        }
        return s_oTagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement host = _context.getUpperHost();
        if (host == null || !(host instanceof IPublishContent)) {
            return null;
        }
        String field = _context.getAttribute("FIELD");
        if (CMyString.isEmpty(field)) {
            field = "PAGENUM";
        }
        Document hostDoc = (Document)host.getSubstance();
        DBType dbtype = DBManager.getDBManager().getDBType();
        String sqlDay = dbtype.sqlFilterOneDay("CrTime", hostDoc.getCrTime().toString(), null);
        StringBuffer sbWhere = new StringBuffer(64);
        sbWhere.append("DocStatus>0 AND ");
        sbWhere.append(field).append("=?");
        sbWhere.append(" AND ").append(sqlDay);
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", "", "DocId desc");
        filter.addSearchValues(0, hostDoc.getPropertyAsString(field));
        filter.setWhere(sbWhere.toString());
        sbWhere = null;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("filter:" + filter));
        }
        IPublishFolder folder = _context.getPageFolder();
        IPublishElements contents = null;
        try {
            contents = folder.getAllContents(filter);
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6\u96c6\u5408\u5931\u8d25\uff01", e);
        }
        if (contents == null || contents.size() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append("<div id='_trsprenext' style='display:none'>");
        IPublishContent content = null;
        String linkUrl = null;
        boolean zRealtive = !_context.getAttribute("ISURLABS", false);
        String pagePath = _context.getPageHttpPath();
        PublishPathCompass compass = _context.getPathCompass();
        int nCurrentId = hostDoc.getId();
        int size = contents.size();
        for (int i = 0; i < size; ++i) {
            content = (IPublishContent)contents.get(i);
            if (content == null) continue;
            content.setFolder(folder);
            linkUrl = compass.getHttpUrl(content, 0);
            if (zRealtive) {
                linkUrl = HtmlUtil.calRelativePath(linkUrl, pagePath);
            }
            if (nCurrentId == content.getId()) {
                result.append("<span id='_current'>");
            } else {
                result.append("<span>");
            }
            result.append(linkUrl);
            result.append("</span>");
        }
        result.append("</div>");
        contents.clear();
        return new String[]{result.toString()};
    }

    public void clear() {
    }
}

