/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.components.wcm.epress.EPressHistoryGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class DocumentLCListener4EPress
implements IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (objModified == null || objModified.getWCMType() != 605) {
            return;
        }
        Document document = (Document)objModified;
        if (!document.isChangeProperty("DOCTITLE")) {
            return;
        }
        this.onEvent(document);
    }

    private void onEvent(Document document) throws WCMException {
        Channel channel = null;
        try {
            channel = document.getChannel().getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (channel == null || !EPressConf.instance().existsEPress(channel.getId())) {
            return;
        }
        String sPubDate = document.getPropertyAsString("PUBLISHDATE");
        CMyDateTime dtPubDate = CMyDateTime.now();
        if (CMyString.isEmpty(sPubDate) || dtPubDate.toString("yyyy.MM.dd").equals(sPubDate)) {
            return;
        }
        try {
            dtPubDate.setDateWithString(sPubDate, 1);
        }
        catch (CMyException cMyException) {
            // empty catch block
        }
        EPressHistoryGenerator generator = new EPressHistoryGenerator(channel);
        generator.generate(dtPubDate);
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (objDeleted == null || objDeleted.getWCMType() != 605) {
            return;
        }
        Document document = (Document)objDeleted;
        this.onEvent(document);
    }
}

