/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;

public class ReplaceCacheMgr
implements ICacheMgr {
    private static final char CHAR_UNDERSCORE = '_';
    private static final String PROPERTY_REPLACENAME = "REPLACENAME";
    private static final String PROPERTY_REPLACECONTENT = "REPLACECONTENT";
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    String getReplaceContent(int _nChannelId, String _sReplaceName) throws WCMException {
        this.assertNameNotEmpty(_sReplaceName);
        return (String)cache.get(this.makeKey(_nChannelId, _sReplaceName));
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (this.notified(_oObjAdded)) {
            Replace replace = (Replace)_oObjAdded;
            cache.set(this.makeKey(replace), replace.getContent());
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (this.notified(_oObjDeleted)) {
            Replace replace = (Replace)_oObjDeleted;
            cache.clear(this.makeKey(replace));
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (this.notified(_oObjModified)) {
            Replace replace = (Replace)_oObjModified;
            boolean bChanngedName = replace.isChangeProperty(PROPERTY_REPLACENAME);
            boolean bChannedCont = replace.isChangeProperty(PROPERTY_REPLACECONTENT);
            if (!bChanngedName && !bChannedCont) {
                return;
            }
            if (bChanngedName && !bChannedCont) {
                String sNewName = replace.getNewPropertyAsString(PROPERTY_REPLACENAME);
                String sNewKey = this.makeKey(replace.getChnlId(), sNewName);
                cache.clear(this.makeKey(replace));
                cache.set(sNewKey, replace.getContent());
                return;
            }
            if (!bChanngedName && bChannedCont) {
                String sNewCont = replace.getNewPropertyAsString(PROPERTY_REPLACECONTENT);
                cache.set(this.makeKey(replace), sNewCont);
                return;
            }
            if (bChanngedName && bChannedCont) {
                String sNewName = replace.getNewPropertyAsString(PROPERTY_REPLACENAME);
                String sNewKey = replace.getChnlId() + 95 + sNewName;
                String sNewCont = replace.getNewPropertyAsString(PROPERTY_REPLACECONTENT);
                cache.clear(this.makeKey(replace));
                cache.set(sNewKey, sNewCont);
                return;
            }
        }
    }

    private boolean notified(BaseObj _object) {
        if (_object == null) {
            return false;
        }
        return 105 == _object.getWCMType();
    }

    private synchronized void loadReplaces() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        Replaces replaces = Replaces.openWCMObjs(User.getSystem(), null);
        HashMap hReplaces = new HashMap(replaces.size(), 1.0f);
        Replace replace = null;
        for (int i = 0; i < replaces.size(); ++i) {
            replace = (Replace)replaces.getAt(i);
            if (replace == null) continue;
            cache.set(this.makeKey(replace), replace.getContent());
        }
    }

    private String getKey() {
        return ReplaceCacheMgr.class.getName();
    }

    private String makeKey(Replace _replace) {
        return this.getKey() + _replace.getChnlId() + '_' + _replace.getName();
    }

    private String makeKey(int _nChannelId, String _sReplaceName) {
        return this.getKey() + _nChannelId + '_' + _sReplaceName;
    }

    private void assertNameNotEmpty(String _name) throws WCMException {
        if (_name == null || _name.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(ReplaceCacheMgr.class, "ReplaceCacheMgr.label1", "\u65e0\u6548\u7684\u66ff\u6362\u5185\u5bb9\u5bf9\u8c61\u7684\u540d\u79f0!"));
        }
    }

    @Override
    public boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        this.loadReplaces();
        cache.set(this.getKey(), "true");
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
    }
}

