/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class LoggerSwitch
extends CMSObj {
    public static final int OBJ_TYPE = 900;
    public static final String DB_TABLE_NAME = "WCMLOGGER";
    public static final String DB_ID_NAME = "LOGGERID";
    public static final String DB_CLASSNAME = "CLASSNAME";
    public static final String DB_CLASSDESC = "CLASSDESC";
    public static final String DB_STATUS = "STATE";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 900;
    }

    public void setLoggerClassName(String className) throws WCMException {
        if (className == null || className.indexOf(".") < 0) {
            return;
        }
        this.setPropertyWithString(DB_CLASSNAME, className);
    }

    public void setLoggerDesc(String desc) throws WCMException {
        if (desc == null) {
            return;
        }
        this.setPropertyWithString(DB_CLASSDESC, desc);
    }

    public void setLoggerState(int status) throws WCMException {
        if (status > 1 || status < 0) {
            return;
        }
        this.setProperty(DB_STATUS, status);
    }

    public String getLoggerClassName() {
        return this.getPropertyAsString(DB_CLASSNAME);
    }

    public String getLoggerDesc() {
        return this.getPropertyAsString(DB_CLASSDESC);
    }

    public int getLoggerState() {
        return this.getPropertyAsInt(DB_STATUS, 1);
    }

    @Override
    public boolean isValid() throws WCMException {
        return this.getLoggerClassName() != null;
    }

    public static final LoggerSwitch findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (LoggerSwitch)BaseObj.findById(LoggerSwitch.class, _nId);
    }

    public static final LoggerSwitch createNewInstance() throws WCMException {
        return new LoggerSwitch();
    }
}

