/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChildrenMgr;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyMemory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ChildrenCacheMgr
implements IChildrenMgr {
    private static Logger logger = Logger.getLogger(ChildrenCacheMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public void clear() {
    }

    @Override
    public List<Channel> listChildren(User _currUser, BaseChannel _parent, int _nType) throws WCMException {
        return this.listChildren(_currUser, _parent, new int[]{_nType});
    }

    @Override
    public final List<Channel> listChildren(User _currUser, BaseChannel _parent, int[] _arrayNeedType) throws WCMException {
        List childrenList = null;
        Channel childChannel = null;
        if (_parent == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label1", "\u65e0\u6548\u7684\u7236\u9891\u9053/\u7ad9\u70b9[null]"));
        }
        if (_arrayNeedType == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label2", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u7684\u5b50\u9891\u9053\u7c7b\u578b\uff01"));
        }
        ArrayList<Channel> list = new ArrayList<Channel>();
        if (_arrayNeedType.length == 0) {
            return list;
        }
        childrenList = this.getChildrenList(_parent);
        if (childrenList == null) {
            return list;
        }
        for (int i = 0; i < childrenList.size(); ++i) {
            childChannel = Channel.findByKey(childrenList.get(i));
            if (!this.isNeeded(childChannel, _arrayNeedType)) continue;
            list.add(childChannel);
        }
        return list;
    }

    @Override
    public int getChildrenSize(User _currUser, BaseChannel _parent) throws WCMException {
        if (_parent == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label1", "\u65e0\u6548\u7684\u7236\u9891\u9053/\u7ad9\u70b9[null]"));
        }
        List list = this.getChildrenList(_parent);
        return list == null ? 0 : list.size();
    }

    @Override
    public Channel getChildAt(BaseChannel _parent, int _nIndex) throws WCMException {
        if (_parent == null) {
            throw new WCMException(10, I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label1", "\u65e0\u6548\u7684\u7236\u9891\u9053/\u7ad9\u70b9[null]"));
        }
        List list = this.getChildrenList(_parent);
        if (list == null || list.size() <= _nIndex) {
            return null;
        }
        return Channel.findById((Integer)list.get(_nIndex));
    }

    @Override
    public int getSiblingIndex(BaseChannel _channel) throws WCMException {
        List childrenList = this.getChildrenList(_channel.getHost());
        if (childrenList == null) {
            return -1;
        }
        return childrenList.indexOf(_channel);
    }

    @Override
    public synchronized boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return false;
        }
        cache.set(this.getKey(), "true");
        logger.info((Object)I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label3", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u5f00\u59cb..."));
        logger.info((Object)(I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label4", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u524d\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        String sWhere = "Status!=-1 and ChnlType in(1, 2)";
        WCMFilter topFiler = new WCMFilter("", sWhere, " ChnlType desc ");
        this.loadChildren(topFiler);
        sWhere = "Status=0 and ChnlType not in(1, 2)";
        WCMFilter normalFiler = new WCMFilter("", sWhere, " ChnlOrder desc ");
        this.loadChildren(normalFiler);
        logger.info((Object)I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label5", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u5b8c\u6210\uff01"));
        logger.info((Object)(I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label6", "\u5b50\u9891\u9053\u7f13\u51b2\u521d\u59cb\u5316\u540e\u5185\u5b58\u4f7f\u7528\u60c5\u51b5[") + CMyMemory.toMemoryInfo() + "]"));
        return true;
    }

    private void loadChildren(WCMFilter _aFilter) throws WCMException {
        Channels aChannels = Channels.openWCMObjs(User.getSystem(), _aFilter);
        int nCount = aChannels.size();
        for (int i = 0; i < nCount; ++i) {
            BaseChannel host;
            Channel aChannel = (Channel)aChannels.getAt(i);
            if (aChannel == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u7f13\u5b58\u7236\u5b50\u5173\u7cfb\u680f\u76ee\uff1a" + aChannel));
            }
            if ((host = aChannel.getHost()) == null) {
                logger.warn((Object)(aChannel + "\u7adf\u7136\u6ca1\u6709\u7236\u5bf9\u8c61"));
                continue;
            }
            cache.rpush(this.getKey(host), aChannel.getId());
        }
        aChannels.clear();
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (_oObjAdded.getWCMType() != 101) {
            return;
        }
        Channel aChannel = (Channel)_oObjAdded;
        this.reloadChildren(aChannel.getHost());
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof BaseChannel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label7", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(ChildrenCacheMgr.class, "ChildrenCacheMgr.label8", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        BaseChannel aChannel = (BaseChannel)_oObjDeleted;
        cache.clear(this.getKey(aChannel));
        if (aChannel instanceof Channel) {
            cache.lrem(this.getKey(aChannel.getHost()), 1L, aChannel.getId());
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (_oObjModified.getWCMType() != 101) {
            return;
        }
        Channel currChannel = (Channel)_oObjModified;
        int nOldParentId = currChannel.getParentId();
        if (currChannel.isChangeProperty("SiteId")) {
            boolean bChangeParentId = currChannel.isChangeProperty("ParentId");
            int nNewParentId = currChannel.getNewPropertyAsInt("PARENTID", 0);
            if (nOldParentId == 0 && bChangeParentId) {
                this.reloadChildren(currChannel.getSite());
                this.reloadChildren(WebSite.findById(currChannel.getNewPropertyAsInt("SITEID", 0)));
                return;
            }
            if (bChangeParentId) {
                this.reloadChildren(this.getParent(currChannel));
                this.reloadChildren(Channel.findById(nNewParentId));
                return;
            }
        }
        if (currChannel.isChangeProperty("ParentId")) {
            this.reloadChildren(this.getParent(currChannel));
            int nNewParentId = currChannel.getNewPropertyAsInt("ParentId", 0);
            if (nNewParentId == 0) {
                this.reloadChildren(currChannel.getSite());
            } else {
                this.reloadChildren(Channel.findById(nNewParentId));
            }
            return;
        }
        if (currChannel.isChangeProperty("ChnlOrder")) {
            this.reloadChildren(currChannel.getHost());
            return;
        }
        if (currChannel.isChangeProperty("Status")) {
            int nStatus = currChannel.getNewPropertyAsInt("Status", -2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notifyOnModifyObj:" + nStatus));
            }
            this.reloadChildren(currChannel.getHost());
            return;
        }
        if (currChannel.isChangeProperty("ChnlType")) {
            int nNewType = currChannel.getNewPropertyAsInt("ChnlType", 0);
            int nOldType = currChannel.getType();
            if (this.isSpecialType(nNewType) ^ this.isSpecialType(nOldType)) {
                this.reloadChildren(currChannel.getHost());
            }
            return;
        }
        this.reloadChildren(currChannel.getHost());
    }

    private boolean isSpecialType(int _nType) {
        return 2 == _nType || 1 == _nType;
    }

    @Override
    public void reloadChildren(BaseChannel _parent) throws WCMException {
        List list = this.loadChildren(_parent);
        String sKey = this.getKey(_parent);
        cache.clear(sKey);
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            cache.rpush(sKey, list.get(i));
        }
    }

    private List loadChildren(BaseChannel _parent) throws WCMException {
        WCMFilter aFilter = null;
        Channels childChannels = null;
        Channel channel = null;
        ArrayList<Integer> childrenList = new ArrayList<Integer>();
        channel = this.getChannelByType(2, _parent);
        if (channel != null) {
            childrenList.add(channel.getKey());
        }
        if ((channel = this.getChannelByType(1, _parent)) != null) {
            childrenList.add(channel.getKey());
        }
        String sWhere = "Status!=-1";
        sWhere = _parent.isSite() ? sWhere + " and SiteId=" + _parent.getId() + " AND ParentId=0" : sWhere + " and ParentId=" + _parent.getId();
        sWhere = sWhere + " and ChnlType not in(2, 1)";
        aFilter = new WCMFilter("", sWhere, "ChnlOrder desc", "CHANNELID");
        childChannels = Channels.openWCMObjs(User.getSystem(), aFilter);
        for (int i = 0; i < childChannels.size(); ++i) {
            channel = (Channel)childChannels.getAt(i);
            if (channel == null) continue;
            childrenList.add(channel.getKey());
        }
        return childrenList;
    }

    private Channel getChannelByType(int _nChnlType, BaseChannel _parent) throws WCMException {
        String sWhere = "Status!=-1";
        sWhere = _parent.isSite() ? sWhere + " and SiteId=" + _parent.getId() + " and ParentId=0 and ChnlType=" + _nChnlType : sWhere + " and ParentId=" + _parent.getId() + " and ChnlType=" + _nChnlType;
        WCMFilter aFilter = new WCMFilter("", sWhere, "", "CHANNELID");
        aFilter.setMaxRowNumber(1);
        Channels aChnls = Channels.openWCMObjs(User.getSystem(), aFilter);
        if (aChnls.isEmpty()) {
            return null;
        }
        return (Channel)aChnls.getAt(0);
    }

    private boolean isNeeded(Channel _channel, int[] _arrayNeedTypes) {
        if (_channel == null) {
            return false;
        }
        int nType = _channel.getType();
        for (int i = 0; i < _arrayNeedTypes.length; ++i) {
            int temp = _arrayNeedTypes[i];
            if (-1 != temp && nType != temp) continue;
            return true;
        }
        return false;
    }

    private List getChildrenList(BaseChannel _parent) throws WCMException {
        this.init();
        return cache.lrange(this.getKey(_parent), 0L, -1L);
    }

    private BaseChannel getParent(Channel _aChannel) throws WCMException {
        if (_aChannel.getParentId() == 0) {
            return _aChannel.getSite();
        }
        return Channel.findById(_aChannel.getParentId());
    }

    private void removeChildFromCache(Channel _child) throws WCMException {
        if (_child.isDeleted()) {
            return;
        }
        cache.lrem(this.getKey(_child.getHost()), 1L, _child.getKey());
    }

    private String getKey() {
        return ChildrenCacheMgr.class.getName();
    }

    private String getKey(BaseChannel baseChannel) {
        if (baseChannel instanceof WebSite) {
            return this.getKey() + ".site." + baseChannel.getId();
        }
        return this.getKey() + ".channel." + baseChannel.getId();
    }
}

